package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.service.DWFile;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.FileInfo;
import com.digiwin.athena.knowledgegraph.service.IFileService;
import com.digiwin.athena.knowledgegraph.clients.DMCUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@Lang
@Service
@Slf4j
public class FileService implements IFileService {
    @Autowired
    private DMCUtils dmcUtils;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate sysMongoTemplate;

    @Override
    public Object postUpload(DWFile file, String key, String version) throws Exception {
       return this.postUpload(file, key, version, "");
    }

    @Override
    public Object postUpload(DWFile file, String key, String version, String desc) throws Exception {
        log.info("fileUpload key:{}, version:{}, desc:{}", key, version, desc);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(file.getFileName());
        fileInfo.setDescription(desc);
        String upload = this.dmcUtils.upload(file, fileInfo);

        Query query = new Query();
        Criteria criteria = Criteria.where("key").is(key).and("version").is(version);
        query.addCriteria(criteria);

        Update update = new Update();
        update.set("fileId", upload).set("desc", desc);
        this.sysMongoTemplate.upsert(query, update, "fileInfo");

        return upload;
    }

    @Override
    public void getDownloadTemplate(String fileId) throws Exception {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        dmcUtils.downLoadTemplate(fileId, response);
    }

    @Override
    public Object getFileId(String key, String version) throws Exception {
        Query query = new Query();
        Criteria criteria = Criteria.where("key").is(key).and("version").is(version);
        query.addCriteria(criteria);
        Map fileInfo = this.sysMongoTemplate.findOne(query, Map.class, "fileInfo");
        if(fileInfo == null){
            return null;
        }
        return String.valueOf(fileInfo.get("fileId"));
    }


}
