package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.service.IMechanismTemplateService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.springframework.stereotype.Service;

import java.util.*;

@Lang
@Service
public class MechanismTemplateService implements IMechanismTemplateService {
    @Override
    public Object getQuery(String mechanismTemplateId) throws Exception {
        List<Map<String, Object>> templateResults = Neo4jManager.getNeo4jManager().ExecuteQuery(
                "Match (template:ManagementMechanism) where template.mechanismTemplateId = '"
                        + mechanismTemplateId + "' return template"
        );
        List<Map<String, Object>> ruleResults = Neo4jManager.getNeo4jManager().ExecuteQuery(
                "Match (template:ManagementMechanism)-[:Contains]->(rule:ScheduleRule) "
                        + "where template.mechanismTemplateId = '"
                        + mechanismTemplateId + "' return rule"
        );
        if (templateResults.size() == 0) {
            Map<String, String> result = new HashMap<String, String>();
            result.put("mechanismTemplateId", mechanismTemplateId);
            result.put("result", "Not Found.");
            return result;
        }
        else {
            Map<String, Object> templateItem = templateResults.get(0);
            Map<String, Object> result = new HashMap<String, Object>();
            Object template = templateItem.get("template");
            if (template instanceof Map) {
                Map templateAsMap = (Map) template;
                result.putAll(templateAsMap);
                ArrayList<Map> rules = new ArrayList<Map>();
                for (Map<String, Object> ruleItem : ruleResults) {
                    //先找到别名是rule的结果
                    Object rule = ruleItem.get("rule");
                    if (rule instanceof Map) {
                        rules.add((Map) rule);
                    }
                    else {
                        throw new DWException(I18nUtils.getValue("knowledgegraph.wrongQuery.scheduleRule"));
                    }
                }
                result.put("rule", rules);
                return result;
            }
            else {
                throw new DWException(I18nUtils.getValue("knowledgegraph.wrongQuery.mechanismTemplate"));
            }
        }

    }

    @Override
    public Object put(String mechanismTemplateId, Map<String, Object> content) throws Exception {
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(
                GetMechanismTemplateStatement(mechanismTemplateId, content, false)
        );
        //todo 上面这句只会新增原本不存在的属性或者节点，更新节点属性值需要另外写set语句
        Map<String, String> result = new HashMap<String, String>();
        result.put("mechanismTemplateId", mechanismTemplateId);
        result.put("result", "succeed");
        return result;
    }

    @Override
    public Object post(Map<String, Object> content) throws Exception {
        String mechanismTemplateId = UUID.randomUUID().toString().replaceAll("-","").toLowerCase();
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(
                GetMechanismTemplateStatement(mechanismTemplateId, content, true)
        );

        Map<String, String> result = new HashMap<String, String>();
        result.put("mechanismTemplateId", mechanismTemplateId);
        result.put("result", "succeed");
        return result;
    }

    @Override
    public Object delete(String mechanismTemplateId) throws Exception {
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(
                GetDeleteMechanismTemplateStatements(mechanismTemplateId));
        Map<String, String> result = new HashMap<String, String>();
        result.put("mechanismTemplateId", mechanismTemplateId);
        result.put("result", "succeed");
        return result;
    }

    @Override
    public Object post(String mechanismTemplateId, Map<String, Object> updatedContent) throws Exception {
        //todo 检查code是否重复
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(
                GetMechanismTemplateStatement(mechanismTemplateId, updatedContent, true)
        );

        Map<String, String> result = new HashMap<String, String>();
        result.put("mechanismTemplateId", mechanismTemplateId);
        result.put("result", "succeed");
        return result;
    }

    private static String GetMechanismTemplateStatement(String mechanismTemplateId, Map<String, Object> content, boolean isNew) throws Exception {
        if (content.size() == 0) {
            return "";
        }
        String operation = isNew ? "CREATE" : "MERGE";
        StringBuffer buf = new StringBuffer(content.size() * 10);

        ArrayList<String> statementsToAppend = new ArrayList<String>();
        buf.append(operation);
        buf.append(" (template:ManagementMechanism { mechanismTemplateId:'");
        buf.append(mechanismTemplateId);
        buf.append("', ");
        for(Map.Entry<String, Object> entry : content.entrySet()) {
            String propertyName = entry.getKey();
            switch (propertyName) {
                case "code":
                    buf.append("code:'");
                    buf.append((String)entry.getValue());
                    buf.append("',");
                    break;
                case "name":
                    buf.append("name:'");
                    buf.append((String)entry.getValue());
                    buf.append("',");
                    break;
                case "rule":
                    List rules = (List)entry.getValue();
                    int i = 0;
                    for (Object rule : rules) {
                        statementsToAppend.add(GetScheduleRuleStatement(
                                "template",
                                (Map<String, Object>) rule,
                                isNew, i++));
                    }
                    break;
                default:
                    break;
            }
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("})");

        for (String statement : statementsToAppend) {
            buf.append(" ");
            buf.append(statement);
        }

        return buf.toString();
    }

    public static String GetScheduleRuleStatement(String mechanismTemplateAlias, Map<String, Object> content, boolean isNew, int aliasSeq) throws Exception {

        if (content.size() == 0) {
            return "";
        }
        String operation = isNew ? "CREATE" : "MERGE";
        String scheduleRuleId = content.containsKey("scheduleRuleId") ?
                (String)content.get("scheduleRuleId") :
                UUID.randomUUID().toString().replaceAll("-","").toLowerCase();

        StringBuffer buf = new StringBuffer(content.size() * 10);

        ArrayList<String> statementsToAppend = new ArrayList<String>();
        buf.append(operation);
        buf.append(" (rule");
        buf.append(aliasSeq);
        buf.append(":ScheduleRule { scheduleRuleId:'");
        buf.append(scheduleRuleId);
        buf.append("', ");
        for(Map.Entry<String, Object> entry : content.entrySet()) {
            String propertyName = entry.getKey();
            switch (propertyName) {
                case "code":
                    buf.append("code:'");
                    buf.append((String)entry.getValue());
                    buf.append("',");
                    break;
                case "name":
                    buf.append("name:'");
                    buf.append((String)entry.getValue());
                    buf.append("',");
                    break;
                case "defaultTriggerList":
                    buf.append("trigger:'");
                    buf.append(entry.getValue().toString());
                    buf.append("',");
                    break;
                default:
                    break;
            }
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("}) ");

        buf.append(operation);
        buf.append(" (");
        buf.append(mechanismTemplateAlias);
        buf.append(")-[:Contains]->(rule");
        buf.append(aliasSeq);
        buf.append(") ");
        return buf.toString();
    }

    private static List<String> GetDeleteMechanismTemplateStatements(String mechanismTemplateId) throws DWException {
        List<String> statements = new ArrayList<String>();
        List<Map<String, Object>> result = Neo4jManager.getNeo4jManager().ExecuteQuery(
                "Match (template:ManagementMechanism)-[:Contains]->(rule:ScheduleRule) "
                        + "where template.mechanismTemplateId = '"
                        + mechanismTemplateId + "' return rule"
        );
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (Map<String, Object> entity : result) {
            //先找到别名是rule的结果
            Object rule = entity.get("rule");
            if (rule instanceof Map) {
                ruleIds.add((String)((Map) rule).get("scheduleRuleId"));
            }
            else {
                throw new DWException(I18nUtils.getValue("knowledgegraph.wrongQuery.scheduleRule"));
            }
        }

        statements.add("Match (template:ManagementMechanism)-[r:Contains]-(rule:ScheduleRule) "
                + "where template.mechanismTemplateId = '"
                + mechanismTemplateId + "' delete r");
        for (String ruleId : ruleIds) {
            statements.add("Match (rule:ScheduleRule) where rule.scheduleRuleId = '"
                    + ruleId + "' delete rule");
        }
        statements.add("Match (template:ManagementMechanism) where template.mechanismTemplateId = '"
                + mechanismTemplateId + "' delete template");
        return statements;

    }

    public static String GetUpdateMechanismStatement(
            String mechanismTemplateId, Map<String, Object> content) {
        StringBuffer buf = new StringBuffer();
        buf.append("Match (template:ManagementMechanism) "
                + "where template.mechanismTemplateId = '"
                + mechanismTemplateId + "' set ");
        for(Map.Entry<String, Object> entry : content.entrySet()) {
            String propertyName = entry.getKey();
            switch (propertyName) {
                case "code":
                    buf.append("code:'");
                    buf.append((String) entry.getValue());
                    buf.append("',");
                    break;
                case "name":
                    buf.append("name:'");
                    buf.append((String) entry.getValue());
                    buf.append("',");
                    break;
                default:
                    break;
            }
        }
        return buf.toString();
    }
}
