package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.service.ISqlIndexAdvanceService;
import com.digiwin.athena.knowledgegraph.utils.FieldMergerUtils;
import com.digiwin.athena.knowledgegraph.utils.SQLIndexSuggestionUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @title: SqlIndexAdvanceService
 * @author: linc
 * @date 2024/4/17 17:42
 * @version: 1.0
 */
@Lang
@Service
@Slf4j
public class SqlIndexAdvanceService implements ISqlIndexAdvanceService {
    @Override
    public Object postSqlIndex(String sql) {
        List<String> sqlList = Arrays.asList(sql.split(";"));
        Set<String> resultSet = new HashSet<>();
        if (CollectionUtils.isEmpty(sqlList)) {
            return resultSet;
        }

        for (String sqlStr : sqlList) {
            try {
                Select select = (Select) CCJSqlParserUtil.parse(sqlStr);
                Map<String, String> tableAliasMap = new HashMap<>();
                Set<String> joinColumnsSet = new HashSet<>();
                SQLIndexSuggestionUtils.extractTablesWithAlias(select.getSelectBody(), tableAliasMap,joinColumnsSet);

                // 获取表名
                TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
                List<String> tablesList = tablesNamesFinder.getTableList(select);

                List<String> joinColumnsList = new ArrayList<>(joinColumnsSet);
                Collections.sort(joinColumnsList);
                List<String> data = SQLIndexSuggestionUtils.getOptimizationSuggestions(tablesList,tableAliasMap,joinColumnsList);
                resultSet.addAll(FieldMergerUtils.mergeFields(data));
            } catch (JSQLParserException e) {
                log.error("The Sql is error : {}" ,e);
            }
        }
        return resultSet;
    }
}
