package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.module.DWModuleConfigUtils;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.KmHttpUtil;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.service.ISubscribeService;
import com.digiwin.athena.knowledgegraph.service.model.CommentResult;
import com.digiwin.athena.knowledgegraph.service.model.GoodsEntityRelation;
import com.digiwin.athena.knowledgegraph.service.model.SimpleHttpEntity;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import lombok.Setter;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.validation.Valid;
import java.util.Date;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

/**
 * @program: athena_backend
 * @description:
 * 用户在执行任务前查询订购关系,查看是否订购
 * athena在触发侦测规则的时候查询订购关系,查看是否订购---待定
 *
 * https://cac-test.digiwincloud.com.cn/api/cac/v4/authorizations/tenants/athenaTest/goods/athena_task_MO/modules 查看租户和商品的订购关系
 * 其中 athenaTest 租户id athena_task_MO商品id
 * https://cac-test.digiwincloud.com.cn/api/cac/v4/authorizations/tenants/athenaTest/users/athenaTestTenant/goods/athena_task_MO/module/002 查看用户和实体订购关系
 * 其中 athenaTest租户id, athenaTestTenant用户id,athena_task_MO商品id, 002实体id 对应Tack的code字段 MonitorRule的code字段
 * @author: Tuo
 * @create: 2020-07-09 18:11
 **/

@Lang
@Service
public class SubscribeService implements ISubscribeService {

    @Value("${cacUrl}")
    private String cacUrl = "https://cac1-test.digiwincloud.com.cn";


//    {
//
//        if(!UnitTestHelper.isUnitTest){
//            cacUrl = DWModuleConfigUtils.getCurrentModuleProperty("cacUrl");
//        }
//    }


    @Override
    public Object postRelation(GoodsEntityRelation relation) throws DWException {



        if(null==relation.getEntityID() || null==relation.getGoodsID() || null==relation.getType()){
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdGoodsOrTypeEmpty"));
        }

        MongoCollection<Document> col = getCol();

        Document doc = col.find(and(eq("entityID", relation.getEntityID()))).first();//eq("goodsID", relation.getGoodsID()) 一个实体只对应一个商品
        if(null!=doc){
            return null;
        }

        doc = new Document();
        doc.put("entityID",relation.getEntityID());
        doc.put("goodsID",relation.getGoodsID());
        doc.put("type",relation.getType());
        doc.put("createTime",new Date());

        col.insertOne(doc);

        return null;
    }

    @Override
    public Object deleteRelation(String entityID,String goodsID) throws DWException {


        if(null==entityID || null==goodsID){
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdGoodsEmpty"));
        }

        MongoCollection<Document> col = getCol();
        col.deleteOne(and(eq("entityID", entityID), eq("goodsID", goodsID)));

        return null;
    }

    @Override
    public Object getSubscription(String tenantID,String userID, String entityID,String type) throws DWException {

        if(null==entityID || null==tenantID || null==userID){
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdTenantEmpty"));
        }

        MongoCollection<Document> col = getCol();
        //目前一个实体对应一个商品
        Document doc = col.find(and(eq("entityID", entityID), eq("type", type))).first();
        if(doc==null){
            return null;
        }
        String goodsID = doc.getString("goodsID");


        String url = cacUrl+"/api/cac/v4/authorizations/tenants/"+tenantID+"/users/"+userID+"/goods/"+goodsID+"/module/"+entityID;
        SimpleHttpEntity entity = KmHttpUtil.get(url,null,null,SimpleHttpEntity.class);


        return null;
    }



    private MongoCollection<Document> getCol(){
        MongoDatabase database =MongoDBManager.getMongoDBManager().getDatabase();
        MongoCollection<Document> col = database.getCollection("GoodsEntityRelation");
        return col;
    }

}
