package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.mechanism.FormulaTemplate;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismFormula;
import com.digiwin.athena.knowledgegraph.domain.mechanism.TenantSettings;
import com.digiwin.athena.knowledgegraph.repoSystem.FormulaTemplateRepository;
import com.digiwin.athena.knowledgegraph.repo.TenantSettingsRepository;
import com.digiwin.athena.knowledgegraph.service.ITenantSettingsService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-07-24 20:41
 **/
@Lang
@Service
public class TenantSettingsService  implements ITenantSettingsService {

    @Autowired
    private TenantSettingsRepository repository;

    @Autowired
    private FormulaTemplateRepository formulaTemplateRepository;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate template;


    @Override
    public Object postScheduleConstructionThreshold(String tenantId,String taskId) {

        TenantSettings settings = repository.findOneByTenantId(tenantId);
        if(null!=settings){
            Map<String,Object> data = new HashMap<>();
            data.put("threshold",settings.getScheduleConstructionThreshold());
            return data;
        }

        return null;
    }


    @Override
    public Object postMechanismFormulaUpdate(String tenantId,String taskId,String key) {

        Map<String,String> data =new HashMap<>();
        FormulaTemplate ftemplate = formulaTemplateRepository.findOneByKey(key);
        if(null!=ftemplate){
            MechanismFormula update = new MechanismFormula();
            update.setTenantId(tenantId);
            update.setStatus(0);
            update.setKey(ftemplate.getKey());
            update.setName(ftemplate.getName());
            update.setFormulaName(ftemplate.getFormulaName());
            update.setFormulaVariables(ftemplate.getItems());
            update.setActionId(ftemplate.getActionId());
            update.setLang(ftemplate.getLang());
            template.save(update);
            data.put("newFormulaId",update.getId());
            data.put("variableKey",update.getKey());
            data.put("variableName",update.getName());
            data.put("formulaName",update.getFormulaName());

        }
        TenantSettings settings = repository.findOneByTenantId(tenantId);
        if(null!=settings){
            data.put("oldFormulaId",settings.getScheduleConstructionFormulaId());
        }

        return data;
    }


    @Override
    public Object getFormula(String formulaId) {

        MechanismFormula formula = template.findById(formulaId,MechanismFormula.class);

        return formula;
    }

    @Override
    public Object getCurrentFormula(String tenantId, String taskId) {

        TenantSettings settings = repository.findOneByTenantId(tenantId);
        if(null!=settings && null!= settings.getScheduleConstructionFormulaId()){
            MechanismFormula formula = template.findById(settings.getScheduleConstructionFormulaId(),MechanismFormula.class);

          //  result.setData(formula);
            Map<String,Object> data = new HashMap<>();
            data.put("actionId",formula.getActionId());
            if(null!=formula.getFormulaVariables()){
                formula.getFormulaVariables().forEach(e->{
                    data.put(e.getKey(),e.getValue());
                });
            }
            return data;

        }
        return null;
    }

    @Override
    public Object postFormula(MechanismFormula param) {

        if(null==param.getId()){
            template.save(param);

        }else {
            MechanismFormula formula = template.findById(param.getId(),MechanismFormula.class);
            if(null!=formula){
                if(null!=param.getStatus()){
                    formula.setStatus(param.getStatus());
                }
                if(null!=param.getRemark()){
                    formula.setRemark(param.getRemark());
                }
                if(null!=param.getTenantId()){
                    formula.setTenantId(param.getTenantId());
                }
                if(null!=param.getFormulaVariables()){
                    formula.setFormulaVariables(param.getFormulaVariables());
                }
                if(null!=param.getKey()){
                    formula.setKey(param.getKey());
                }
                if(null!=param.getName()){
                    formula.setName(param.getName());
                }
                template.save(formula);

                if(param.getStatus()!=null && param.getStatus()==3){
                    TenantSettings settings = repository.findOneByTenantId(param.getTenantId());
                    settings.setScheduleConstructionFormulaId(param.getId());
                    repository.save(settings);
                }

            }

        }


        return param;
    }

    /**
     *
     * 暂时用不到的调用 可拓展
     *
     * @param code
     * @return
     * @throws Exception
     */
    public Object getSynchronously(String code) throws Exception {
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is("system").and("code").is(code));
        TenantSettings system = template.findOne(query, TenantSettings.class);
        Query query2 = new Query();
        query2.addCriteria(Criteria.where("tenantId").is(AthenaUtils.getTenantId()).and("code").is(code));
        TenantSettings tenantSettings = template.findOne(query2, TenantSettings.class);
        if (tenantSettings != null) {
            AthenaUtils.mergeObject(tenantSettings, system);
        }
        if (system != null) {
            LanguageUtil.processLocaleLanguage(system.getExecuteType(), AthenaUtils.getCurrentLocale());
        }
        return system;

    }
}
