package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO2;
import com.digiwin.athena.knowledgegraph.domain.business.BkField;
import com.digiwin.athena.knowledgegraph.domain.business.BkInfo;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.po.BkRequest;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.SimpleRequest;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.rule.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.rule.model.ReturnColumnDTO;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IViewService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.ActivityService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.vo.BkResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.integration.util.CallerBlocksPolicy;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.*;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-11-29 14:37
 **/
@Lang
@Service
@Slf4j
public class ViewService implements IViewService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    MonitorRuleManager monitorRuleManager;
    @Autowired
    TaskService taskService;
    @Autowired
    ActivityService activityService;

    @Autowired
    TenantService tenantService;

    @Autowired
    TaskRepository taskRepository;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    private DataPickService dataPickService;

    ExecutorService monitorsPool = new ThreadPoolExecutor(1,10,60, TimeUnit.SECONDS,new LinkedBlockingQueue<>(2),new CallerBlocksPolicy(Integer.MAX_VALUE));


    @Override
    public Object getTest(String code) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        return taskRepository.findTaskAndActivities(tenantId,code, tenantVersion);
    }

    @Override
    public Object getEmail(String emailCode, String locale) throws DWException {
        System.out.println("test getEmail:"+emailCode +" and locale="+locale);
        Map<String,Object> map = new HashMap<>();
        String tenantId = AthenaUtils.getTenantId();
        String version = tenantService.getTenantVersion(tenantId);
        EmailView viewUser = mongoTemplateUser.findOne(Query.query(Criteria.where("code").is(emailCode).and("tenantId").is(tenantId).and("version").is(version)),EmailView.class);
        EmailView viewSystem = dataPickService.findOneByCondition(Criteria.where("code").is(emailCode), EmailView.class, "emailView");
        if(null!=viewSystem){
            if(null!=viewUser){
                AthenaUtils.mergeObject(viewUser,viewSystem);
            }
            if(null!=viewSystem.getLocaleViews() && null!=viewSystem.getLocaleViews().get(locale)){
                map.put("eventId",viewSystem.getLocaleViews().get(locale));
            }
            if(null!=viewSystem.getConfig()){
                if(null!=viewSystem.getConfig().getTables()){
                    viewSystem.getConfig().getTables().forEach(table->{
                        if(null!=table.getLang() && null!=table.getLang().get("name") && null!=table.getLang().get("name").get(locale)){
                            table.setName(table.getLang().get("name").get(locale));

                        }
                        table.setLang(null);
                        if(null!=table.getFields()){
                            table.getFields().forEach(
                                    field->{
                                        if(null!=field.getLang() && null!=field.getLang().get("name") && null!=field.getLang().get("name").get(locale)){
                                            field.setName(field.getLang().get("name").get(locale));
                                        }
                                        field.setLang(null);
                                    }
                            );
                        }
                    });
                }
                map.put("meta",viewSystem.getConfig());
            }

        }
        return map;
    }

    /*
    支持项目/任务/api级别bk信息获取,
    对于项目和任务如果BkInfo已经配置bk信息则优先取该配置,如果没有则取inputData中的信息
    api则必须要进行配置
     */

    @Override
    public Object postBk(BkRequest request) throws DWException {
        BkResponse resp = new BkResponse();
        Criteria criteria = Criteria.where("objectType").is(request.getObjectType()).and("objectValue").is(request.getObjectValue());
        List<BkInfo> infos = dataPickService.find(criteria, BkInfo.class, "bkInfo");
        resp.setType(request.getObjectType());
        resp.setQueryCode(request.getObjectValue());
        resp.setBkInfo(infos);
        if(infos.isEmpty()){
            Map<String, Object> m=null;
            if("task".equalsIgnoreCase(request.getObjectType())){
                m  = (Map) taskService.getInputData(request.getObjectValue());
            }else if("activity".equalsIgnoreCase(request.getObjectType())){
                m  = (Map) activityService.getInputData(request.getObjectValue());
            }
            if(null!=m && null!=m.get("inputData")){
                Object obj = m.get("inputData");
                List infos2 = new ArrayList();
                Map<String,Object> info2 = new HashMap<>();
                List bk = new ArrayList();
                info2.put("bk",bk);

                if(obj instanceof DataEntityMetadataDTO){
                    DataEntityMetadataDTO defaultbk=(DataEntityMetadataDTO) obj;
                    info2.put("entityName",defaultbk.getEntity_name());
                    info2.put("entity_name",defaultbk.getEntity_name());
                    bk.add(defaultbk);
                }else if(obj instanceof Map){
                    Map defaultbk = (Map) obj;
                    info2.put("entityName",defaultbk.get("entity_name"));
                    info2.put("entity_name",defaultbk.get("entity_name"));
                    bk.add(defaultbk);
                } else{
                    try{
                        DataEntityMetadataDTO defaultbk = JSON.parseObject(JSON.toJSONString(obj),DataEntityMetadataDTO.class);
                        info2.put("entityName",defaultbk.getEntity_name());
                        info2.put("entity_name",defaultbk.getEntity_name());
                        bk.add(defaultbk);
                    }catch (Exception e){
                        DataEntityMetadataDTO2 defaultbk2 = JSON.parseObject(JSON.toJSONString(obj),DataEntityMetadataDTO2.class);
                        info2.put("entityName",defaultbk2.getEntity_name());
                        info2.put("entity_name",defaultbk2.getEntity_name());
                        bk.add(defaultbk2);
                    }

                }
                infos2.add(info2);
                resp.setBkInfo(infos2);
            }
        }else {
            infos.forEach(info->{transBk(info);});
        }


        return resp;
    }


    private void transBk(BkInfo in){
        in.setEntity_name(in.getEntityName());
        if(null!=in.getBk()){
            transbkField(in.getBk());
        }
    }

    private void transbkField(List<BkField> fields){
        fields.forEach(fd->{
            fd.setEntity_name(fd.getEntityName());
            fd.setData_type(fd.getDataType());
            fd.setData_name(fd.getDataName());
            fd.setBk_name(fd.getBkName());
            fd.setIs_array(fd.getIsArray());
            fd.setIs_businesskey(fd.getIsBusinesskey());
            if(null!=fd.getField()){
                transbkField(fd.getField());
            }
        });
    }

    /*
    仅有任务支持校验规则获取.
    校验规则以侦测规则形式进行配置.bkinfo中包含ruleId指向对应的校验信息
    如果传入任务code表示仅查询一个任务的校验信息,如果不传入则需要查询所有任务的校验信息并做合并Action_params和Return_columns两项
     */
    @Override
    public Object postBkMeta(BkRequest request) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String version = tenantService.getTenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        Query query = null;
        if("activityCheckCycle".equalsIgnoreCase(request.getObjectType())){
            query = Query.query(Criteria.where("objectType").is("activityCheckCycle"));
        }else{
            String bkConcat = bkConcat(request.getBk());
            query = Query.query(Criteria.where("objectType").is("activityCheck").and("bkConcat").is(bkConcat).and("entityName").is(request.getEntityName()));
            resp.setBkConcat(bkConcat);
        }

        if(null!=request.getTaskCode()){
            query.addCriteria(Criteria.where("objectValue").is(request.getTaskCode()));
        }
        //应该使用activityCode的 但接口已经给出,这里就做个兼容吧
        if(null!=request.getActivityCode()){
            query.addCriteria(Criteria.where("objectValue").is(request.getActivityCode()));
        }
        query.addCriteria(Criteria.where("version").is(version));
        List<BkInfo> infos = mongoTemplate.find(query,BkInfo.class);
        infos = dataPickService.excludeWithSameCode(infos);
        resp.setQueryCode(request.getTaskCode());
        resp.setEntityName(request.getEntityName());


        if(infos.size()>0){
            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
            MonitorRuleDTO dto = getRule(infos.get(0).getRuleId(),tenantId,tenantVersion);
            if(dto==null){
                return resp;
            }
            resp.setRule(dto);
            resp.setProductName(dto.getProduct_name());
            if(infos.size()>1){
                List<String> ruleIds = new ArrayList<>();
                for(int i=1;i<infos.size();i++){
                    BkInfo info = infos.get(i);
                    if(null!=info.getRuleId() && !ruleIds.contains(info.getRuleId())){
                        ruleIds.add(info.getRuleId());
                    }
                }
                List<Future<MonitorRuleDTO>> fds = new ArrayList<>();
                ruleIds.forEach(ruleId->{
                    Future<MonitorRuleDTO> fd =  monitorsPool.submit(new Callable<MonitorRuleDTO>() {
                        @Override
                        public MonitorRuleDTO call() throws Exception {
                            return getRule(ruleId,tenantId,tenantVersion);
                        }
                    });
                    fds.add(fd);
                });

                Set<ActionParamDTO> params = new HashSet<>();
                Set<ReturnColumnDTO> returnCols = new HashSet<>();
                fds.forEach(fd->{
                    try {
                        MonitorRuleDTO dto1 = fd.get();
                        if(null!=dto1){
                            if(null!=dto1.getAction_params()){
                                params.addAll(dto1.getAction_params());
                            }
                            if(null!=dto1.getReturn_columns()){
                                returnCols.addAll(dto1.getReturn_columns());
                            }
                        }
                    } catch (Exception e) {
                        log.error("",e);
                    }
                });
                dto.setAction_params(new ArrayList<>());
                dto.setReturn_columns(new ArrayList<>());
                dto.getAction_params().addAll(params);
                dto.getReturn_columns().addAll(returnCols);

            }

        }

        return resp;
    }

    @Override
    public Object postDataMap(SimpleRequest request) throws DWException {
        DapResponse resp = dataMapService.requestDataMap(request.getUri(), request.getMethod() ,request.getParam());
        return resp.getResponse();
    }

    @Override
    public Object postDataMapPublic(SimpleRequest request) throws DWException {
        DapResponse resp = dataMapService.requestDataMap(request.getUri(), request.getMethod() ,request.getParam());
        return resp.getResponse();
    }

    private MonitorRuleDTO getRule(String ruleId,String tenantId,String tenantVersion)  {
        if(null==ruleId){return null;}
        try {
            Map<String, Object> config = new HashMap<>();
            config.put("ruleId",ruleId);
            config.put("tenantId",tenantId);
            MonitorRuleDTO dto = monitorRuleManager.getMonitorRule(config,tenantVersion);
            return dto;
        }catch (Exception e){
            log.error("query monitor rule error by ruleId:"+ruleId,e);
        }
        return null;
    }


    public static String bkConcat(List<String> bks){
        Collections.sort(bks);
        StringBuilder sb = new StringBuilder();
        bks.forEach(bk->{
            sb.append(bk).append("$&");
        });
        return sb.toString();
    }

}
