package com.digiwin.athena.knowledgegraph.service.model;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ActivityTemplateDTO {

    private String uniqueId;

    /**
     * 模板关系类型   SYSTEM/TENANT_COPY/SYSTEM_EDIT
     */
    private String type;

    private String originId;

    private String sourceId;

    private String tenantId;

    private String application;

    private String activityId;

    /**
     * 任务 BUSINESS_PERFORM  项目 BUSINESS_CHARGE   基础资料  DATA_ENTRY_PERFORM
     */
    private String pattern;

    private String code;

    /**
     * 客户端类型  APP  WEB
     */
    private String client;

    private String templateId;

    private String version;

    private String adpDataSourceType;

    private String adpDataSourceId;

    private String athena_namespace;

    private Boolean commonApp;

    private String compileVersion;

    /**
     * 模板启用状态 0 未启用  1 启用
     */
    private Integer status;

    private String locale;

    private String name;

    public Map<String, Map<String, String>> lang;

    private String createDate;

    private String createBy;

    private String editDate;

    private String editBy;

    private String activityName;

    /**
     * 所有转换参数的定义
     */
    private List<Map> actionParams;
}
