package com.digiwin.athena.knowledgegraph.service.model;

import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class MonitorRuleConfigDTO {
    /**
     * 配置id
     */
    private String configId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 侦测id
     */
    private String monitorRuleId;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 类型
     */
    private String type;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 触发器规则
     */
    private TriggerDTO standardPollingRule;
    /**
     * 运营单元
     */
    private EocMapDTO eocMap;
    /**
     * 类型
     */
    private String changeType;
    /**
     * 租户动态条件
     */
    private Map<String, Object> tenantDynamicCondition;
    /**
     * 回溯时间
     */
    private String backtrackDate;
    /**
     * 是否直接执行
     */
    private Boolean directExecution;
    /**
     * MQ或HTTP，当为空时默认为MQ
     */
    private String sendWay;
    /**
     * 多个侦测时间
     */
    private List<TriggerDTO> standardPollingRules;
    /**
     * 是否存在机制参数或者自定义变量，如果存在那么需要推动消息给 SD
     */
    private boolean hasMechanismOrCustomParam;
}
