package com.digiwin.athena.knowledgegraph.set.partParsers;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.core.approve.ApproveInfo;
import com.digiwin.athena.domain.core.approve.ApproveInitiator;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.*;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataField;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.constant.SmartAdjustConstants;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.po.CommonDrivenSchemaReq;
import com.digiwin.athena.knowledgegraph.service.*;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.EmailTemplateReq;
import com.digiwin.athena.knowledgegraph.set.*;
import com.digiwin.athena.knowledgegraph.spi.ApimgmtService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.set.Tag;
import com.digiwin.athena.set.TagEntity;
import com.digiwin.athena.set.part.*;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class SmartAdjustProjectPartParser implements IPartParser {
    @Autowired
    KgService kgService;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    TagSystemService tagSystemService;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired(required = false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required = false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;
    @Autowired
    CacService cacService;
    @Autowired
    private ATMCService atmcService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    ESPUtils espUtils;
    @Autowired
    private ApimgmtService apimgmtService;
    @Autowired
    private IamService iamService;

    @Autowired
    @Qualifier("baseExecutor")
    ThreadPoolTaskExecutor executor;

    private static final String TASK_DETAIL="task-detail";
    private static final String TASK_DETAIL_MOBILE="task-detail-mobile";

    private static final String QUERY_DATA="query_data";
    private static final String SUBMIT_ACTION="submitAction";
    private static final String SUBMIT_ACTIONS="submitActions";
    private static final String PROJECT_CARD="project-card";
    private static final String TASK_CARD="task-card";
    private static final String PART_TYPE="smartAdjustProject";
    private static final String BUSINESS="business";

    private static final String RULE="rule";
    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase(PART_TYPE, part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        Map<String, Object> dtdRelatedInfoMap = new HashMap<>();
        SmartAdjustProjectPart smartAdjustProjectPart = JSON.parseObject(JSON.toJSONString(part),
                SmartAdjustProjectPart.class);
        DTDRelatedInfo dtdRelatedInfo = new DTDRelatedInfo();
        dtdRelatedInfo.setVersion(context.getCurrentSet().getVersion());
        context.setDtdRelatedInfo(dtdRelatedInfo);
       //PC端 task-detail->dataStates->submitActions 对应的路径下才有submitActions信息
        //移动端页面进行设计的时候task-detail-mobile->dataStates->submitActions没有任务信息，所以不用考虑
        parseBackstageApiInfo(smartAdjustProjectPart);
        //建立neo4j的action DataEntry  DataField 其中action的response_object
        buildAction(context, smartAdjustProjectPart);
        //建立节点
        buildDataDescriptionAndDataState(context, smartAdjustProjectPart);
        //固定流程-创建4个任务  自动分组 人工 签核 后台自动回写
        buildGroupTask(context, smartAdjustProjectPart);
        // 将每个任务卡的数据主键推送到流程变量中，先放到人工任务前面去
//        buildDataSaveTask(context, smartAdjustProjectPart);
        buildManualTask(context, smartAdjustProjectPart);
        buildApproveTask(context, smartAdjustProjectPart);
        buildBackstageTask(context, smartAdjustProjectPart);
        buildProject(context, smartAdjustProjectPart);
        //生成项目和任务卡的页面配置
        Set<String> showFieldCodes = buildPageView(context, smartAdjustProjectPart);
//        // 保存邮件配置
        buildEmailSetting(context, smartAdjustProjectPart);
//        // 将返回字段的定义存到common-driven服务中去
        saveDataFieldDefination(context, smartAdjustProjectPart);
        //入库-mongodb-applicationRelation
        buildAppRelation(context);
        // 入库-neo4j-根据buildAction生成的action等
        createNeo4jSql(context);
        log.info("before executeNeo4jScript:{}", context.getNeo4jSql());
        executeNeo4jScript(context.getNeo4jSql(), sessionFactoryDomain1);
        executeNeo4jScript(context.getNeo4jSql(), sessionFactoryDomain2);
        ////入库-neo4j+mongodb-根据buildAction生成的tag 当责者（项目卡） 执行者（任务卡） 各类页面字段类型  tag生成 调用tagSys的批量插入
        executor.execute(() -> {
            try {
                tagSystemService.syncTags(handleTagParams(context, smartAdjustProjectPart.getReturnFields(), showFieldCodes));
            } catch (DWBusinessException e) {
                log.error("/tag/batchTags failed,{}", e.toString());
                throw new RuntimeException(e);
            }
        });
        // 调用dataMap translateContent 接口需要传入对象，先通过 DisableCircularReferenceDetect 去除原对象中的引用，然后在转回来
        context.getDtdRelatedInfo().setAppCode(context.getCurrentSet().getAppCode());
        log.info("before translateContent:{}", JSON.toJSONString(context.getDtdRelatedInfo()));
        String infoStr =
                translateUtils.translateContent(JSON.parseObject(JSON.toJSONString(context.getDtdRelatedInfo(),
                        SerializerFeature.DisableCircularReferenceDetect), DTDRelatedInfo.class));
        DTDRelatedInfo dtdRelatedInfoReq = JSON.parseObject(infoStr, DTDRelatedInfo.class);
        // 任务code <=> name映射
        Map<String, String> taskCodeLangMap = new HashMap<>();
        for (Task task : dtdRelatedInfoReq.getTaskList()) {
            if (MapUtils.isEmpty(task.getLang())||MapUtils.isEmpty(task.getLang().get("name"))) {
                task.setLang(ImmutableMap.of("name",ImmutableMap.of("zh_CN",task.getName(),"zh_TW",task.getName())));
            }
            taskCodeLangMap.put(task.getCode(), task.getName());
        }
        for (Phase phase : dtdRelatedInfoReq.getProject().getPhases()) {
            if (MapUtils.isEmpty(phase.getLang())||MapUtils.isEmpty(phase.getLang().get("name"))) {
                String name = taskCodeLangMap.get(phase.getCode());
                if (name != null) {
                    phase.setLang(ImmutableMap.of("name",ImmutableMap.of("zh_CN",name,"zh_TW",name)));
                }
            }
        }
        dtdRelatedInfoMap.put("dtdRelatedInfo", dtdRelatedInfoReq);
        dataMapService.requestDataMap("/set/saveDtdRelatedInfo", "post", dtdRelatedInfoMap);
    }

    /**
     * 解析回写api信息
     * @param part part
     */
    private void parseBackstageApiInfo(SmartAdjustProjectPart part) {
        List<PageView> pageViews = part.getPageViews();
        PageView pageView = pageViews.get(0);
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONObject submitAction = pages.getJSONObject(TASK_DETAIL).getJSONArray("dataStates").getJSONObject(0).getJSONArray(SUBMIT_ACTIONS).getJSONObject(0);
        part.setProductName(submitAction.getString("productName"));
        part.setServiceName(submitAction.getString("serviceName"));
        part.setActionId(submitAction.getString("actionId"));
        JSONArray params = submitAction.getJSONArray("params");
        if (params != null) {
            List<Processor> processors = JSONArray.parseArray(params.toJSONString(), Processor.class);
            part.setParams(processors);
        } else {
            part.setParams(new ArrayList<>());
        }
    }

    /**
     * 将返回字段的定义存到common-driven服务中去
     * @param context 上下文
     * @param part part
     * @throws DWBusinessException 业务异常
     */
    private void saveDataFieldDefination(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(part.getReturnFields())) {
            // 查询影响到的租户id
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String token = request.getHeader("token");
            if (null == token) {
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            CommonDrivenSchemaReq req = new CommonDrivenSchemaReq();
            List<CommonDrivenSchemaReq.Field> fields = getFieldList(part);
            CommonDrivenSchemaReq.Model model = new CommonDrivenSchemaReq.Model();
            req.setModel(model);
            // 模型名和表名都使用code
            model.setCode(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
            model.setDescription(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
            JSONObject appInfo = new JSONObject();
            appInfo.put("prod", SetConstants.COMMON_DATA_PRODUCT);
            model.setAppInfo(appInfo);
            CommonDrivenSchemaReq.Schema schema = new CommonDrivenSchemaReq.Schema();
            schema.setComment(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
            schema.setFields(fields);
            // 曾加索引
            CommonDrivenSchemaReq.Index index = new CommonDrivenSchemaReq.Index()
                    .setId("B001")
                    .setMember(Collections.singletonList(SetConstants.COMMON_DATA_DEFAULT_PK))
                    .setType("unique");
            schema.setIndex(Collections.singletonList(index));
            // 判断是否已经发布过
            schema.setPublished(context.isExists());
            schema.setSystem(true);
            // 表名，
            schema.setName(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
            schema.setPk(SetConstants.COMMON_DATA_DEFAULT_PK);
            schema.setSwitchCfg(new CommonDrivenSchemaReq.SwitchCfg());
            model.setSchema(schema);
            log.info("随心控业务数据表结构：{}", JSON.toJSONString(req));
            try {
                Object execute = espUtils.callEspService(model, token, AthenaUtils.getTenantId(), "common-driven", SetConstants.COMMON_DATA_MODEL_UPDATE_API);
                log.info("请求common-driven更新表结构，response：{}", JSON.toJSONString(execute));
                // api平台只有测试区，没有正式区，所以只能获取测试区的来调用，直接用正式区的token会报错
                String testIntegrationToken = iamService.getTestIntegrationToken(AthenaUtils.getTenantId());
                log.info("获取test区继承账号token：{}", testIntegrationToken);
                String updateScriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/updateApiSaveStruct.json");
                String create = updateScriptTemplate.replaceAll("#apiDescription#", "新增随心控数据数据")
                        .replaceAll("#apiName#", SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + context.getCurrentSet().getCode() + ".create")
                        .replaceAll("#schemaName#", SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
                apimgmtService.publishActionMeataDataToApimgmt(JSONArray.parseArray(create), testIntegrationToken);

                String update = updateScriptTemplate.replaceAll("#apiDescription#", "更新随心控数据数据")
                        .replaceAll("#apiName#", SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + context.getCurrentSet().getCode() + ".update")
                        .replaceAll("#schemaName#", SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
                apimgmtService.publishActionMeataDataToApimgmt(JSONArray.parseArray(update), testIntegrationToken);

                saveListGetApi(context, part, testIntegrationToken);
            } catch (Exception e) {
                throw new DWBusinessException(e.getMessage());
            }
        }
    }

    /**
     * 保存list Api
     *
     * @param context context
     * @param part    part
     * @param token   token
     */
    private void saveListGetApi(SetParseContext context, SmartAdjustProjectPart part, String token) {
        String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/apiSaveStruct.json");
        String list = scriptTemplate.replaceAll("#apiDescription#", "查询随心控数据数据列表")
                .replaceAll("#apiName#", SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + context.getCurrentSet().getCode() + ".list.get")
                .replaceAll("#schemaName#", SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
        JSONArray listApiData = JSONArray.parseArray(list);
        JSONObject apiMgmtModelSave = listApiData.getJSONObject(0).getJSONObject("apiMgmtModelSave");
        JSONArray responseMessageSuccessSpec = apiMgmtModelSave.getJSONArray("responseMessageSuccessSpec");
        JSONObject responseField = new JSONObject();
        String uid = UUID.randomUUID().toString();
        JSONObject lang = new JSONObject().fluentPut("en_US", "随心控数据数据")
                .fluentPut("zh_CN", "随心控数据数据")
                .fluentPut("zh_TW", "随心控数据数据");
        JSONObject remarkLang = new JSONObject().fluentPut("en_US", "随心控数据数据")
                .fluentPut("zh_CN", "随心控数据数据")
                .fluentPut("zh_TW", "随心控数据数据");
        responseField.fluentPut("_uid", uid)
                .fluentPut("canFilter", "Y")
                .fluentPut("canSort", "Y")
                .fluentPut("columnType", "M")
                .fluentPut("dataDescription", "随心控数据数据")
                .fluentPut("dataDescriptionMultilingual", lang)
                .fluentPut("dataName", SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode())
                .fluentPut("dataNameRemark", "查询随心控数据数据列表")
                .fluentPut("dataNameRemarkMultilingual", remarkLang)
                .fluentPut("dataType", "object")
                .fluentPut("editHistory", "")
                .fluentPut("id", 10)
                .fluentPut("isArray", "Y")
                .fluentPut("isBusinessKey", "N")
                .fluentPut("isDatakey", "N")
                .fluentPut("isRequired", "Y")
                .fluentPut("listEnum", "Y")
                .fluentPut("listEnumMultilingual", new JSONObject().fluentPut("en_US", "")
                        .fluentPut("zh_CN", "")
                        .fluentPut("zh_TW", ""))
                .fluentPut("parentId", 0)
                .fluentPut("productPrecision", Collections.emptyMap())
                .fluentPut("value", "")
                .fluentPut("type", "responseSuccess");
        JSONArray children = new JSONArray();
        Map<String, String> existsFieldMap = new HashMap<>();
        for (ReturnField returnField : part.getReturnFields()) {
            if ("@taskPerformerId".equals(returnField.getDatasourceField()) || existsFieldMap.containsKey(returnField.getDatasourceField())) {
                continue;
            }
            String dataType = returnField.getValueType();
            if ("number".equals(returnField.getValueType())) {
                dataType = "numeric";
            } else if ("text".equals(returnField.getValueType()) || "percent".equals(returnField.getValueType())) {
                dataType = "string";
            }
            // 防止字段重复
            existsFieldMap.put(returnField.getDatasourceField(), "exists");
            JSONObject field = new JSONObject();
            JSONObject fieldLang = new JSONObject().fluentPut("en_US", returnField.getDisplayName())
                    .fluentPut("zh_CN", returnField.getDisplayName())
                    .fluentPut("zh_TW", returnField.getDisplayName());
            field.fluentPut("_uid",UUID.randomUUID().toString())
                    .fluentPut("canFilter","Y")
                    .fluentPut("canSort","Y")
                    .fluentPut("columnType","MF")
                    .fluentPut("dataDescription",returnField.getDisplayName())
                    .fluentPut("dataDescriptionMultilingual",fieldLang)
                    .fluentPut("dataName",returnField.getDatasourceField())
                    .fluentPut("dataType",dataType)
                    .fluentPut("expand",false)
                    .fluentPut("isArray","N")
                    .fluentPut("isBusinessKey","N")
                    .fluentPut("isDatakey","N")
                    .fluentPut("isRequired","N")
                    .fluentPut("parentId",uid)
                    .fluentPut("type","responseSuccess");
            children.add(field);
        }
        JSONObject pkField = new JSONObject();
        JSONObject pkFieldLang = new JSONObject().fluentPut("en_US", "主键")
                .fluentPut("zh_CN", "主键")
                .fluentPut("zh_TW", "主键");
        pkField.fluentPut("_uid",UUID.randomUUID().toString())
                .fluentPut("canFilter","Y")
                .fluentPut("canSort","Y")
                .fluentPut("columnType","MF")
                .fluentPut("dataDescription","主键")
                .fluentPut("dataDescriptionMultilingual",pkFieldLang)
                .fluentPut("dataName",SetConstants.COMMON_DATA_DEFAULT_PK)
                .fluentPut("dataType","numeric")
                .fluentPut("expand",false)
                .fluentPut("isArray","N")
                .fluentPut("isBusinessKey","Y")
                .fluentPut("isDatakey","Y")
                .fluentPut("isRequired","Y")
                .fluentPut("parentId",uid)
                .fluentPut("type","responseSuccess");
        children.add(pkField);
        responseField.put("childrens", children);
        responseMessageSuccessSpec.add(responseField);
        apimgmtService.publishActionMeataDataToApimgmt(listApiData, token);
    }

    /**
     * 配置默认的字段
     * @param part part
     * @return 字段定义
     */
    private static List<CommonDrivenSchemaReq.Field> getFieldList(SmartAdjustProjectPart part) {
        List<CommonDrivenSchemaReq.Field> fields = new ArrayList<>();
        // 添加主键
        CommonDrivenSchemaReq.Field pkField = new CommonDrivenSchemaReq.Field();
        pkField.setAutoIncrement(true);
        pkField.setFieldId(SetConstants.COMMON_DATA_DEFAULT_PK);
        pkField.setFieldName("主键");
        pkField.setFieldType(DataTypeEnum.BIGINT.getName());
        pkField.setPk(true);
        pkField.setSystem(true);
        pkField.setNotNull(true);
        pkField.setSize("20");
        fields.add(pkField);
        // 添加tenantsid，区分不同租户数据
        CommonDrivenSchemaReq.Field tenantSidField = new CommonDrivenSchemaReq.Field();
        tenantSidField.setAutoIncrement(false);
        tenantSidField.setFieldId("tenantsid");
        tenantSidField.setFieldName("租户sid");
        tenantSidField.setFieldType(DataTypeEnum.BIGINT.getName());
        tenantSidField.setSystem(true);
        tenantSidField.setNotNull(true);
        tenantSidField.setUnique(false);
        tenantSidField.setSize("20");
        fields.add(tenantSidField);

        CommonDrivenSchemaReq.Field statusField = new CommonDrivenSchemaReq.Field();
        statusField.setFieldId("heart_control_data_status");
        statusField.setFieldName("数据审批状态");
        statusField.setFieldType(DataTypeEnum.VARCHAR.getName());
        statusField.setSize("20");
        statusField.setDefaultValue("0");
        fields.add(statusField);

        CommonDrivenSchemaReq.Field sourceIdsField = new CommonDrivenSchemaReq.Field();
        tenantSidField.setAutoIncrement(false);
        sourceIdsField.setFieldId("sourceIds");
        sourceIdsField.setFieldName("来源id");
        sourceIdsField.setFieldType(DataTypeEnum.VARCHAR.getName());
        sourceIdsField.setSize("20");
        fields.add(sourceIdsField);
        Map<String, String> existsFieldMap = new HashMap<>();
        for (ReturnField returnField : part.getReturnFields()) {
            if (returnField.getDatasourceField().equals(SetConstants.COMMON_DATA_DEFAULT_PK)
                    || "tenantsid".equals(returnField.getDatasourceField())
                    || "heart_control_data_status".equals(returnField.getDatasourceField())
                    || existsFieldMap.containsKey(returnField.getDatasourceField())) {
                continue;
            }
            // 防止字段重复
            existsFieldMap.put(returnField.getDatasourceField(), "exists");
            CommonDrivenSchemaReq.Field field = new CommonDrivenSchemaReq.Field();
            field.setFieldId(returnField.getDatasourceField());
            field.setFieldName(returnField.getDisplayName());
            // 转换一下类型
            switch (returnField.getValueType()) {
                case "text":
                    field.setFieldType(DataTypeEnum.TEXT.getName());
                    break;
                case "number":
                    field.setFieldType(DataTypeEnum.INT.getName());
                    break;
                case "numeric":
                    field.setFieldType(DataTypeEnum.DECIMAL.getName());
                    field.setScale("4");
                    break;
                case "boolean":
                    field.setFieldType(DataTypeEnum.BIT.getName());
                    field.setSize("1");
                    break;
                case "datetime":
                    field.setFieldType(DataTypeEnum.DATETIME.getName());
                    field.setSize(null);
                    break;
                case "date":
                    field.setFieldType(DataTypeEnum.DATE.getName());
                    field.setSize(null);
                    break;
                case "time":
                    field.setFieldType(DataTypeEnum.TIME.getName());
                    field.setSize(null);
                    break;
                case "string":
                case "percent":
                default:
                    field.setFieldType(DataTypeEnum.VARCHAR.getName());
                    break;
            }
            fields.add(field);
        }
        return fields;
    }

    private void buildDataSaveTask(SetParseContext context, SmartAdjustProjectPart smartAdjustProjectPart) {
        // 后台回写api任务
        List<Activity> activities = this.buildDataSaveActivity(context);
        FlowGraph flowGraph = this.buildWithBackstageGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.dataSave);
        task.setPattern("BUSINESS");
        task.setType("business");
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.dataSave);
        task.setMerge(false);
        task.setCategory("PROCESS");
        task.setMilestone(false);
        task.setPriority(0);
        task.setName("推送数据唯一id");
        // 发起任务节点开始  到人工任务
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_backstage");
        Map<String, String> output = new HashMap<>();
        output.put("end0", context.getCurrentSet().getCode() + "_end"); // key的值与FlowGraph中end节点的dataKey值相等
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private Map<String, Object> handleTagParams(SetParseContext context, List<ReturnField> returnFields, Set<String> showFieldCodes) throws DWBusinessException {
        String pluginId = context.getCurrentSet().getCode();
        List<TagEntity> tagEntities = new ArrayList<>();
        List<Task> taskList =
                context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals(SmartAdjustConstants.TaskBuilder.manual)).collect(Collectors.toList());
        //先创建任务的tag（类型为activity）目前没发现有taggingData  类型为role需要再补
        TagEntity activityTagEntity = new TagEntity();
        ArrayList<Tag> activityTag = new ArrayList<>();
        String resourceId = "esp_" + SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + pluginId + ".list.get";
        for (Task task : taskList) {
            activityTagEntity.setResourceId(resourceId);
            Tag tag = new Tag();
            tag.setCategory("ACTIVITY");
            tag.setCode(task.getCode());
            activityTag.add(tag);

            //根据字段开始打tag order  根据类型打页面类型tag  百分比 金额等
            int order = 10;
            int step = 10;
            // 开放界面设计后返回字段不用再打tag，只保留执行人分组字段的
            for (ReturnField field : returnFields) {
                // 显示字段
                if (!showFieldCodes.contains(field.getDatasourceField())) {
                    continue;
                }
                TagEntity fieldTagEntity = new TagEntity();
                fieldTagEntity.setResourceId(resourceId);
                fieldTagEntity.setResourceContent(resourceId + ".response." + SetConstants.COMMON_DATA_MODEL_PREFIX + pluginId + "." + field.getDatasourceField());
                fieldTagEntity.setTags(new ArrayList<>());
                //fixme 生成tag目前先这样写 希望后续有机会优化
                //当责者 执行人的order和ROLE__ACTIVITY
                if (!field.isHide()) {
                    fieldTagEntity.getTags().add(Tag.builder().category("ORDER").code("charge__" + task.getCode() +
                            "__ORDER_" + order).build());
                }
                if (!field.isHide()) {
                    fieldTagEntity.getTags().add(Tag.builder().category("ROLE__ACTIVITY").code("charge__" + task.getCode()).build());
                }
                fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() +
                        "__UNEDITABLE").build());
                //页面类型转tag  目前已实现文本 百分比 金额
                switch (field.getValueType()) {
                    case "text":
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__TEXTAREA").build());
                        break;
                    case "percent":
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__BUSINESS_PERCENT_INPUT").build());
                        break;
                    case "numeric":
                        fieldTagEntity.getTags().add(Tag.builder().category("DISPLAY").code("charge__" + task.getCode() + "__BUSINESS_AMOUNT").build());
                        break;
                    default:
                        break;
                }
                order = order + step;
                tagEntities.add(fieldTagEntity);
            }
            // 项目卡详情按照执行人分组需要给执行人字段打上tag
            for (String s : SmartAdjustConstants.PAGE_VIEW_GROUP_FIELDS) {
                TagEntity fieldTagEntity = new TagEntity();
                fieldTagEntity.setResourceId(resourceId);
                fieldTagEntity.setResourceContent(resourceId + ".response." + SetConstants.COMMON_DATA_MODEL_PREFIX + pluginId + "." + s);
                fieldTagEntity.setTags(new ArrayList<>());
                fieldTagEntity.getTags().add(Tag.builder().category("ORDER").code("charge__" + task.getCode() +
                        "__ORDER_" + order).build());
                fieldTagEntity.getTags().add(Tag.builder().category("ROLE__ACTIVITY").code("charge__" + task.getCode()).build());
                order = order + step;
                tagEntities.add(fieldTagEntity);
            }
        }
        activityTagEntity.setTags(activityTag);
        tagEntities.add(activityTagEntity);
        tagEntities.forEach(en -> {
            if (null != en.getResourceContent()) {
                String resourceContent = "{'response': '" + en.getResourceContent() + "'}";
                en.setResourceContent(resourceContent);
            }
        });
        Map<String, Object> param = new HashMap<>();
        param.put("pluginId", pluginId);
        param.put("athena_namespace", context.getCurrentSet().getAppCode());
        param.put("version", context.getCurrentSet().getVersion());
        param.put("tagEntities", tagEntities);
        return param;
    }

    private void createNeo4jSql(SetParseContext context) throws DWBusinessException {
        ArrayList<String> sql = new ArrayList<>();
        sql.add("MATCH (n:Action{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        sql.add("MATCH (n:DataEntity{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        sql.add("MATCH (n:DataField{pluginId: '" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'})-[r]-() DELETE n, r;");
        List<Action> actionList = context.getDtdRelatedInfo().getActionList();
        for (Action action : actionList) {
            List<DataEntity> createsEntity = action.getCreatesEntity();
            //多语言一次性设置
            handleLang(createsEntity);
            String actionSql = "MERGE (a:Action {" +
                    "athena_namespace: '" + context.getCurrentSet().getAppCode() + "'," +
                    "actionId: '" + action.getActionId() + "'," +
                    "actionName: '" + action.getActionName() + "'," +
                    "version: '" + action.getVersion() + "'," +
                    "request_parameters: '" + action.getRequest_parameters() + "'," +
                    "pluginId: '" + action.getPluginId() + "'," +
                    "emergency: " + action.getEmergency() + "," +
                    "response_object: '" + handleActionResponseObject(createsEntity) + "'});";
            sql.add(actionSql);
            if (!createsEntity.isEmpty()) {
                DataEntity dataEntity = createsEntity.get(0);
                String dataEntitySql = "MERGE (a:DataEntity { dataType: 'object'," +
                        "athena_namespace: '" + context.getCurrentSet().getAppCode() + "'," +
                        "fullPath: '" + dataEntity.getName() + "'," +
                        "name: '" + dataEntity.getName() + "'," +
                        "version: '" + action.getVersion() + "'," +
                        "pluginId: '" + action.getPluginId() + "'," +
                        "field: '" + JSON.toJSONString(handleDataEntityResponseObject(dataEntity),
                        SerializerFeature.NotWriteDefaultValue) + "'});";
                sql.add(dataEntitySql);
                if (!dataEntity.getField().isEmpty()) {
                    List<DataField> field = dataEntity.getField();
                    for (DataField dataField : field) {
                        String dataFieldSql = "MERGE (a:DataField { required: 'false',is_datakey: 'false',is_array: " +
                                "false,businessKey: false," +
                                "athena_namespace: '" + context.getCurrentSet().getAppCode() + "'," +
                                "fullPath: '" + dataField.getFullPath() + "'," +
                                "dataType: '" + dataField.getDataType() + "'," +
                                "name: '" + dataField.getName() + "'," +
                                "description: '" + dataField.getDescription() + "'," +
                                "version: '" + action.getVersion() + "'," +
                                "pluginId: '" + action.getPluginId() + "'});";
                        sql.add(dataFieldSql);
                    }
                }
            }
        }
        //fixme 增加action dataEntity dataField 关联关系  目前默认一定三连  没做动态action绑定关系
        sql.add("match (a:Action{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) match (d:DataEntity{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) create(a)-[:Creates]->(d);");
        sql.add("match (de:DataEntity{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) match (df:DataField{pluginId:'" + context.getCurrentSet().getCode() + "',version:'" + context.getCurrentSet().getVersion() + "'}) create(de)-[:Contains]->(df);");
        context.getNeo4jSql().addAll(sql);
    }


    private String handleActionResponseObject(List<DataEntity> createsEntity) {
        if (createsEntity.isEmpty()) {
            return "";
        }
        DataEntity dataEntity = createsEntity.get(0);
        ApiDataFieldMetadataDTO dataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
        dataFieldMetadataDTO.setData_name(dataEntity.getName());
        dataFieldMetadataDTO.setData_type("object");
        dataFieldMetadataDTO.setDescription(new MultiLanguageDTO());
        dataFieldMetadataDTO.setIs_array(true);
        dataFieldMetadataDTO.setField(handleDataEntityResponseObject(dataEntity));
        return JSON.toJSONString(dataFieldMetadataDTO);
    }

    private ArrayList<ApiDataFieldMetadataDTO> handleDataEntityResponseObject(DataEntity dataEntity) {
        ArrayList<ApiDataFieldMetadataDTO> fieldMetadataDTOS = new ArrayList<>();
        List<DataField> field = dataEntity.getField();
        for (DataField dataField : field) {
            ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
            apiDataFieldMetadataDTO.setData_name(dataField.getName());
            apiDataFieldMetadataDTO.setData_type(dataField.getDataType());
            apiDataFieldMetadataDTO.setFullPath(dataField.getFullPath());
            apiDataFieldMetadataDTO.setRequired("false");
            apiDataFieldMetadataDTO.setDescription(JSON.parseObject(dataField.getDescription(),
                    MultiLanguageDTO.class));
            fieldMetadataDTOS.add(apiDataFieldMetadataDTO);
        }
        return fieldMetadataDTOS;
    }

    private void handleLang(List<DataEntity> createsEntity) throws DWBusinessException {
        for (DataEntity dataEntity : createsEntity) {
            List<DataField> fields = dataEntity.getField();
            HashMap<String, Object> langMap = new HashMap<>();
            for (DataField field : fields) {
                langMap.put(field.getName(), field.getDescription());
            }
            JSONObject lang =
                    JSON.parseObject(translateUtils.translateContent(JSON.parseObject(JSON.toJSONString(langMap),
                            Object.class))).getJSONObject("lang");
            fields.forEach(v -> v.setDescription(null == lang.getJSONObject(v.getName()) ?
                    "{\"zh_TW\":\"" + v.getDescription() + "\"," +
                            "\"zh_CN\":\" " + v.getDescription() + "\"}" :
                    lang.getJSONObject(v.getName()).toString()));
        }
    }

    public static void main(String[] args) throws DWBusinessException {
        String s = "var info=$(data);\n"+
                "var idStr = [];\n" +
                "if(info&&info.length>0) {\n" +
                "for(var i=0;i<info.length;i++){" +
                "var item=info[i];" +
                "if(item."+SetConstants.COMMON_DATA_DEFAULT_PK+") {" +
                "idStr.push({'heart_control_data_id':item."+SetConstants.COMMON_DATA_DEFAULT_PK+"});" +
                "}}}" +
                "return{'success':true,'processVariable':{'query_condition':idStr},'errorMessage':''};";
        System.out.println(s);
    }

    private void buildAction(SetParseContext context, SmartAdjustProjectPart smartAdjustProjectPart) {
        String version = context.getCurrentSet().getVersion();
        String pluginId = context.getCurrentSet().getCode();

        List<ReturnField> returnFields = context.getReturnFieldAll();
        List<String> showReturnFieldKey =
                returnFields.stream().map(ReturnField::getDatasourceField).distinct().collect(Collectors.toList());

        List<Processor> params = smartAdjustProjectPart.getParams();
        List<String> apiKey =
                params.stream().filter(v -> !v.getType().equals("Constant")).map(Processor::getValue).distinct().collect(Collectors.toList());
        //字段选人员 则也要列入流转定义中  透传
        if (smartAdjustProjectPart.getProcessor().getType().equals("field")) {
            apiKey.add(smartAdjustProjectPart.getProcessor().getValue());
        }

        //先加所有需要展示的字段 后续打tag排序
        returnFields.forEach(v -> v.setHide(false));
        ArrayList<ReturnField> actionList = new ArrayList<>(returnFields);
        conventionField(actionList);

        List<ReturnField> returnFieldAll = context.getReturnFieldAll();
        for (ReturnField returnField : returnFieldAll) {
            //是需要传给回写api的字段  并且show里面没有  则 加入action创建对象  后续打排序字段不带
            if (apiKey.contains(returnField.getDatasourceField()) && !showReturnFieldKey.contains(returnField.getDatasourceField())) {
                returnField.setHide(true);
                actionList.add(returnField);
            }
        }
        smartAdjustProjectPart.setReturnFields(actionList);
        ArrayList<DataField> dataFields = new ArrayList<>();
        if (!returnFields.isEmpty()) {
            for (ReturnField returnField : actionList) {
                DataField dataField = new DataField();
                dataField.setFullPath(SmartAdjustConstants.DATA + "." + returnField.getDatasourceField());
                dataField.setDataType(returnField.getDataFieldDataType());
                dataField.setVersion(version);
                dataField.setName(returnField.getDatasourceField());
                // 多语言翻译 后面准备入库的时候再生成{'zh_TW":"余量","en_US":"余量","zh_CN":"余量"}结构
                dataField.setDescription(returnField.getDisplayName());
                dataFields.add(dataField);
            }
        }

        DataEntity dataEntity = new DataEntity();
        dataEntity.setPluginId(pluginId);
        dataEntity.setVersion(version);
//        dataEntity.setName(SmartAdjustConstants.DATA);
        // 开放页面设计使用dsl模式后需要和数据源的名称相同
        dataEntity.setName(SmartAdjustConstants.HEART_CONTROL_ACTION);
        dataEntity.setIsArray(true);
        dataEntity.setField(dataFields);

        Action action = new Action();
        action.setActionId(SmartAdjustConstants.HEART_CONTROL_ACTION + SmartAdjustConstants.UNDERLINE + pluginId);
        action.setActionName(SmartAdjustConstants.HEART_CONTROL_ACTION);
        action.setVersion(version);
        action.setRequest_parameters("[]");
        action.setPluginId(pluginId);
        action.setCreatesEntity(Collections.singletonList(dataEntity));
        context.getDtdRelatedInfo().getActionList().add(action);

    }


    private void buildAppRelation(SetParseContext context) {
        String pluginId = context.getCurrentSet().getCode();
        /*Query query =
                new Query(Criteria.where("pluginId").is(pluginId).and("version").is(context.getCurrentSet()
                .getVersion()));
        this.mongoTemplateSystem.remove(query, "applicationRelation");*/

        List<ApplicationRelation> lists = new ArrayList<>();
        DTDRelatedInfo dtdRelatedInfo = context.getDtdRelatedInfo();
        Project project = dtdRelatedInfo.getProject();
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setCode(project.getCode());
        applicationRelation.setName(project.getName());
        applicationRelation.setType("task");
        applicationRelation.setAppCode(context.getCurrentSet().getAppCode());
        applicationRelation.setPluginId(pluginId);
        applicationRelation.setVersion(context.getCurrentSet().getVersion());
        applicationRelation.setApplication(context.getCurrentSet().getAppCode());
        applicationRelation.setAthena_namespace(context.getCurrentSet().getAppCode());
        lists.add(applicationRelation);
        List<Task> taskList = dtdRelatedInfo.getTaskList();
        for (Task task : taskList) {
            ApplicationRelation applicationRelation1 = new ApplicationRelation();
            applicationRelation1.setCode(task.getCode());
            applicationRelation1.setName(task.getName());
            applicationRelation1.setType("activity");
            applicationRelation1.setAppCode(context.getCurrentSet().getAppCode());
            applicationRelation1.setPluginId(pluginId);
            applicationRelation1.setVersion(context.getCurrentSet().getVersion());
            applicationRelation1.setApplication(context.getCurrentSet().getAppCode());
            applicationRelation1.setAthena_namespace(context.getCurrentSet().getAppCode());
            applicationRelation1.setTenantId("SYSTEM");
            lists.add(applicationRelation1);
        }
        this.mongoTemplateSystem.insert(lists, "applicationRelation");
    }


    private void buildDataDescriptionAndDataState(SetParseContext context, SmartAdjustProjectPart part) {
        String version = context.getCurrentSet().getVersion();
        DataDescription dataDescription = new DataDescription();
        dataDescription.setCode(context.getCurrentSet().getCode());
        dataDescription.setTenantId("SYSTEM");
        dataDescription.setApplication(context.getCurrentSet().getAppCode());
        dataDescription.setVersion(version);

        FieldDescription dataStruct = new FieldDescription();
        dataStruct.setDataType("OBJECT");
        dataStruct.setKey("data");
        dataStruct.setFields(this.getFields(part));
        dataDescription.setDataStruct(dataStruct);

        dataDescription.setUniKeys(this.getUnKeys(part));
        dataDescription.setPluginId(context.getCurrentSet().getCode());

        //套件发起的项目中有4个任务，所以会有5个状态   开始-发起任务-发起签核-发起回写-结束
        List<DataState> dataStateList = new ArrayList<>();
        DataState dataState = new DataState();
        dataState.setTenantId("SYSTEM");
        dataState.setApplication(context.getCurrentSet().getAppCode());
        dataState.setVersion(version);
        dataState.setCode(context.getCurrentSet().getCode() + "_start");
        dataState.setDataCode(dataDescription.getCode());
        dataState.setName("start");
        dataState.setPluginId(context.getCurrentSet().getCode());

        DataState dataState1 = new DataState();
        dataState1.setTenantId("SYSTEM");
        dataState1.setApplication(context.getCurrentSet().getAppCode());
        dataState1.setVersion(version);
        dataState1.setCode(context.getCurrentSet().getCode() + "_task");
        dataState1.setDataCode(dataDescription.getCode());
        dataState1.setName("task");
        dataState1.setPluginId(context.getCurrentSet().getCode());

        DataState dataState2 = new DataState();
        dataState2.setTenantId("SYSTEM");
        dataState2.setApplication(context.getCurrentSet().getAppCode());
        dataState2.setVersion(version);
        dataState2.setCode(context.getCurrentSet().getCode() + "_approve");
        dataState2.setDataCode(dataDescription.getCode());
        dataState2.setName("approve");
        dataState2.setPluginId(context.getCurrentSet().getCode());

        DataState dataState3 = new DataState();
        dataState3.setTenantId("SYSTEM");
        dataState3.setApplication(context.getCurrentSet().getAppCode());
        dataState3.setVersion(version);
        dataState3.setCode(context.getCurrentSet().getCode() + "_backstage");
        dataState3.setDataCode(dataDescription.getCode());
        dataState3.setName("backstage");
        dataState3.setPluginId(context.getCurrentSet().getCode());

        DataState dataState4 = new DataState();
        dataState4.setTenantId("SYSTEM");
        dataState4.setApplication(context.getCurrentSet().getAppCode());
        dataState4.setVersion(version);
        dataState4.setCode(context.getCurrentSet().getCode() + "_end");
        dataState4.setDataCode(dataDescription.getCode());
        dataState4.setName("end");
        dataState4.setPluginId(context.getCurrentSet().getCode());

        dataStateList.add(dataState);
        dataStateList.add(dataState1);
        dataStateList.add(dataState2);
        dataStateList.add(dataState3);
        dataStateList.add(dataState4);

        context.getDtdRelatedInfo().setDataDescription(dataDescription);
        context.getDtdRelatedInfo().setDataStateList(dataStateList);
        //
        //context.getDtdRelatedInfo().setFrom(dataState.getCode());
        //context.getDtdRelatedInfo().setTo(dataState2.getCode());
        //
        context.getDtdRelatedInfo().setProjectInitDataState(dataState);
        context.getDtdRelatedInfo().setProjectEndDataState(dataState4);
    }


    private List<String> getUnKeys(SmartAdjustProjectPart part) {
        List<String> unKeys = new ArrayList<>();
        List<ReturnField> returnFields = part.getReturnFields();
        if (!CollectionUtils.isEmpty(returnFields)) {
            unKeys.addAll(returnFields.stream().map(ReturnField::getDatasourceField).distinct().collect(Collectors.toList()));
        }
        return unKeys;
    }

    private List<FieldDescription> getFields(SmartAdjustProjectPart part) {
        List<FieldDescription> list = new ArrayList<>();
        List<ReturnField> returnFields = part.getReturnFields();
        if (!CollectionUtils.isEmpty(returnFields)) {
            for (ReturnField returnField : returnFields) {
                FieldDescription fieldDescription = new FieldDescription();
                // 这里需要转换下类型 比如百分比转为DOUBLE   对应dataStruct.fields[].dataType
                fieldDescription.setDataType(returnField.getDataDescriptionFieldType());
                fieldDescription.setKey(returnField.getDatasourceField());
                fieldDescription.setName(returnField.getDisplayName());
                list.add(fieldDescription);
            }
        }

        return list;
    }

    private void buildProject(SetParseContext context, SmartAdjustProjectPart part) {
        Project project = new Project();
        project.setTenantId("SYSTEM");
        project.setApplication(context.getCurrentSet().getAppCode());
        project.setVersion(context.getCurrentSet().getVersion());
        project.setPluginId(context.getCurrentSet().getCode());
        project.setCode(SetConstants.PROJECT_PREFIX + context.getCurrentSet().getCode());
        project.setName(context.getCurrentSet().getName());
        project.setDescription(context.getCurrentSet().getName());
        project.setType("BUSINESS");
        project.setExecuteType("user");
        project.setPresetVariables(Collections.emptyList());
        project.setMerge(false);
        project.setAtmcDatas(this.atmcDatas());

        project.setEnd(context.getDtdRelatedInfo().getProjectEndDataState());
        project.setInit(context.getDtdRelatedInfo().getProjectInitDataState());
        project.setPersonInCharge(this.getUserDefinition(part.getPersonIncharge(), "$(charge_id)"));
        project.setPhases(this.getPhases(context.getDtdRelatedInfo().getTaskList()));
        project.setMainLineTasks(this.getMainLineTask(context.getDtdRelatedInfo().getTaskList()));
        ProjectTarget projectTarget = new ProjectTarget();
        projectTarget.setName(part.getTaskName());
        projectTarget.setCode(SetConstants.PROJECT_PREFIX + context.getCurrentSet().getCode());
        project.setTarget(projectTarget);
        project.setSourceName(part.getTaskName());
        project.setSourceEntityName("sourceIds");
        project.setAssignAble(false);
        project.setConfig(ImmutableMap.of("hideDeliverySetting",true));
        context.getDtdRelatedInfo().setProject(project);
    }

    private List<String> getMainLineTask(List<Task> tasks) {
        return tasks.stream().map(Task::getCode).collect(Collectors.toList());
    }

    private List<Phase> getPhases(List<Task> tasks) {
        List<Phase> phases = new ArrayList<>();
        for (Task task : tasks) {
            if (task.getMilestone()) {
                Phase phase = new Phase();
                phase.setCode(task.getCode());
                phase.setName(task.getName());
                phase.setTaskCodes(Collections.singletonList(task.getCode()));
                phases.add(phase);
            }
        }
        return phases;
    }

    private void buildGroupTask(SetParseContext context, SmartAdjustProjectPart part) {
        // 分组任务
        List<Activity> activities = this.buildGroupActivity(context, part);
        FlowGraph flowGraph = this.buildFlow(context, activities, SmartAdjustConstants.TaskBuilder.group);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.group);
        task.setPattern("BUSINESS");
        task.setType("business");
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.group);
        task.setMerge(false);
        task.setCategory("PROCESS");
        task.setMilestone(false);
        task.setPriority(0);
        task.setName("数据分组");
        //分组任务从 开始节点开始  到发起任务节点
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_start"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_start");
        Map<String, String> output = new HashMap<>();
        output.put("end0", context.getCurrentSet().getCode() + "_task"); // key的值与FlowGraph中end节点的dataKey值相等
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private TimeDefinition defaultDueDate() {
        TimeDefinition timeDefinition = new TimeDefinition();
        timeDefinition.setDatatype("second");
        timeDefinition.setIsBusiness(false);
        timeDefinition.setValue(86400);
        return timeDefinition;
    }

    private void buildManualTask(SetParseContext context, SmartAdjustProjectPart part) {
        List<Activity> activities = this.buildDataSaveActivity(context);
        //普通人工任务
        activities.addAll(this.buildManualActivity(context, part));
        FlowGraph flowGraph = this.buildFlow(context, activities, SmartAdjustConstants.TaskBuilder.manual);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        // 人工型任务按照页面设置的预完日
        task.setDueDate(Objects.isNull(part.getDueDate()) ? defaultDueDate() : part.getDueDate());
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual);
        task.setPattern("BUSINESS");
        task.setType("business");
        task.setExecuteType(SmartAdjustConstants.TaskBuilder.manual);
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual);
        task.setMerge(false);
        task.setCategory("PROCESS");
        task.setMilestone(true);
        task.setPriority(0);
        task.setName(part.getTaskName());
        //人工任务从  发起任务节点开始  到签核节点
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_task"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_approve"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_task");
        Map<String, String> output = new HashMap<>();
        output.put("end0", context.getCurrentSet().getCode() + "_approve"); // key的值与FlowGraph中end节点的dataKey值相等
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private void buildApproveTask(SetParseContext context, SmartAdjustProjectPart part) {
        // 签核任务
        List<Activity> activities = this.buildApproveActivity(context, part);
        FlowGraph flowGraph = this.buildWithRefuseGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setDueDate(defaultDueDate());
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve);
        task.setPattern("BUSINESS");
        task.setType("approve");
        task.setExecuteType(SmartAdjustConstants.TaskBuilder.manual);
        task.setFlowCode(flowGraph.getCode());
        task.setStartApproveActivity(Collections.singletonList(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual));
        task.setStartApproveActivityName(part.getTaskName());
        task.setPageCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve);
        task.setMerge(false);
        task.setCategory("APPROVAL");
        task.setMilestone(true);
        task.setPriority(0);
        task.setName(part.getTaskName() + "签核");
        //签核任务从 签核节点开始  到回写节点
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_approve"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_backstage"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_approve");
        Map<String, String> output = new HashMap<>();
        output.put("end0", context.getCurrentSet().getCode() + "_backstage"); // key的值与FlowGraph中end节点的dataKey值相等
        output.put("end1", context.getCurrentSet().getCode() + "_task"); // key的值与FlowGraph中end节点的dataKey值相等
        output.put("projectEnd", context.getCurrentSet().getCode() + "_end");
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private void buildBackstageTask(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        // 后台回写api任务
        List<Activity> activities = this.buildBackstageActivity(context, part);
        FlowGraph flowGraph = this.buildWithBackstageGatewayFlow(context, activities);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion(context.getCurrentSet().getVersion());
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.backstage);
        task.setPattern("BUSINESS");
        task.setType("business");
        task.setExecuteType("auto");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.backstage);
        task.setMerge(false);
        task.setCategory("PROCESS");
        task.setMilestone(false);
        task.setPriority(0);
        task.setName("调用esp回写");
        //签核任务从 签核节点开始  到回写节点
        task.setFrom(Collections.singletonList(context.getCurrentSet().getCode() + "_backstage"));
        task.setTo(Collections.singletonList(context.getCurrentSet().getCode() + "_end"));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getCurrentSet().getCode() + "_backstage");
        Map<String, String> output = new HashMap<>();
        output.put("end0", context.getCurrentSet().getCode() + "_end"); // key的值与FlowGraph中end节点的dataKey值相等
        stateMap.setOutput(output);
        task.setStateMaps(Collections.singletonList(stateMap));
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().getTaskList().add(task);
        context.getDtdRelatedInfo().getFlowGraphList().add(flowGraph);
        context.getDtdRelatedInfo().getActivityList().addAll(activities);
    }

    private List<AtmcData> atmcDatas() {
        List<AtmcData> atmcDatas = new ArrayList<>();
        AtmcData atmcData = new AtmcData();
        atmcData.setProVarKey("personInCharge");
        atmcData.setAthenaKey("personInCharge");
        atmcDatas.add(atmcData);

        AtmcData atmcData2 = new AtmcData();
        atmcData2.setProVarKey("dueDate");
        atmcData2.setAthenaKey("dueDate");
        atmcDatas.add(atmcData2);

        AtmcData atmcData3 = new AtmcData();
        atmcData3.setProVarKey("$(data[0].sourceIds)");
        atmcData3.setAthenaKey("sourceIds");
        atmcDatas.add(atmcData3);

        AtmcData atmcData4 = new AtmcData();
        atmcData4.setProVarKey("performer_id");
        atmcData4.setAthenaKey("performer_id");
        atmcDatas.add(atmcData4);

        AtmcData atmcData5 = new AtmcData();
        atmcData5.setProVarKey("charge_id");
        atmcData5.setAthenaKey("charge_id");
        atmcDatas.add(atmcData5);

        AtmcData atmcData6 = new AtmcData();
        atmcData6.setProVarKey("query_condition");
        atmcData6.setAthenaKey("query_condition");
        atmcDatas.add(atmcData6);

        return atmcDatas;
    }

    private FlowGraph buildFlow(SetParseContext context, List<Activity> activities, String suffix) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + suffix);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setVersion(context.getCurrentSet().getVersion());
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();

        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);

        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        if (!SmartAdjustConstants.TaskBuilder.group.equals(suffix)) {
            endNode.setDataKey("end0");  // 与Task中stateMaps中有关系  分组不需要
        }
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);

        String from = startNodeId;
        for (Activity activity : activities) {
            FlowNode endNode2 = new FlowNode();
            endNode2.setId(activity.getCode());
            endNode2.setActivityCode(activity.getCode());
            endNode2.setName(activity.getName());
            endNode2.setType(SmartAdjustConstants.activity);
            flowGraph.getNodes().add(endNode2);
            FlowLink flowLink = new FlowLink();
            flowLink.setFrom(from);
            flowLink.setTo(activity.getCode());
            flowGraph.getLinks().add(flowLink);
            from = activity.getCode();
        }

        FlowLink flowLink2 = new FlowLink();
        flowLink2.setFrom(from);
        flowLink2.setTo(endNodeId);
        flowGraph.getLinks().add(flowLink2);

        return flowGraph;
    }

    private FlowGraph buildWithRefuseGatewayFlow(SetParseContext context, List<Activity> activities) {
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        String gatewayNodeId = "gateway_" + context.getCurrentSet().getCode();
        FlowGraph flowGraph = buildFlowGraph(context, activities,
                SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve);
        FlowNode endNode = new FlowNode();
        endNode.setId("end1_" + context.getCurrentSet().getCode());
        endNode.setType("end");
        endNode.setDataKey("end1");
        flowGraph.getNodes().add(endNode);
        FlowNode projectEndNode = new FlowNode();
        projectEndNode.setId("projectEnd" + context.getCurrentSet().getCode());
        projectEndNode.setType("end");
        projectEndNode.setDataKey("projectEnd");
        flowGraph.getNodes().add(projectEndNode);
        flowGraph.getLinks().add(FlowLink.builder().from(startNodeId).to(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve).build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve).to(gatewayNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'agree'").from(gatewayNodeId).to(endNodeId).build());
        // 直接走到项目结束状态
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'disagree'").from(gatewayNodeId).to(projectEndNode.getId()).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("'$(_approveResult)' == 'reexecute'").from(gatewayNodeId).to("end1_" + context.getCurrentSet().getCode()).build());
        return flowGraph;
    }

    private FlowGraph buildWithBackstageGatewayFlow(SetParseContext context, List<Activity> activities) {
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        String gatewayNodeId = "gateway_" + context.getCurrentSet().getCode();
        FlowGraph flowGraph = buildFlowGraph(context, activities,
                SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.backstage);
        flowGraph.getLinks().add(FlowLink.builder().from(startNodeId).to(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.filter).build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.filter).to(gatewayNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("$(apiData).length == 0").from(gatewayNodeId).to(endNodeId).build());
        flowGraph.getLinks().add(FlowLink.builder().condition("$(apiData).length > 0").from(gatewayNodeId).to(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.backstage).build());
        flowGraph.getLinks().add(FlowLink.builder().from(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.backstage).to(endNodeId).build());
        return flowGraph;
    }

    private FlowGraph buildFlowGraph(SetParseContext context, List<Activity> activities, String code) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode() + code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setVersion(context.getCurrentSet().getVersion());
        flowGraph.setLinks(new ArrayList<>());
        flowGraph.setNodes(new ArrayList<>());

        FlowNode start = new FlowNode();
        start.setId("start_" + context.getCurrentSet().getCode());
        start.setType("start");
        flowGraph.getNodes().add(start);

        FlowNode endNode = new FlowNode();
        endNode.setId("end_" + context.getCurrentSet().getCode());
        endNode.setType("end");
        endNode.setDataKey("end0");
        flowGraph.getNodes().add(endNode);

        FlowNode gatewayNode = new FlowNode();
        gatewayNode.setId("gateway_" + context.getCurrentSet().getCode());
        gatewayNode.setType("gateway");
        gatewayNode.setGateType("exclusive");
        flowGraph.getNodes().add(gatewayNode);

        for (Activity activity : activities) {
            FlowNode activityNode = new FlowNode();
            activityNode.setId(activity.getCode());
            activityNode.setActivityCode(activity.getCode());
            activityNode.setName(activity.getName());
            activityNode.setType(SmartAdjustConstants.activity);
            flowGraph.getNodes().add(activityNode);
        }
        return flowGraph;
    }

    private List<Activity> buildGroupActivity(SetParseContext context, SmartAdjustProjectPart part) {
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.group);
        activity.setType("createData");
        activity.setName("数据分组发卡");
        HashMap<String, Object> config = new HashMap<>();
        config.put("dataKey", "end0");
        config.put("groupType", "ByKey");
        config.put("groupedVariable", "data");
        config.put("dataVariable", "data");
        //是字段类型 说明有真实分组环境
        if (part.getProcessor().getType().equals("field")) {
            config.put("groupKeys", Collections.singletonList(part.getProcessor().getValue()));
        } else {
            config.put("groupKeys", Collections.singletonList("groupKeys"));
        }
        activity.setConfig(config);
        activity.setMilestone(false);
        List<Activity> lists = new ArrayList<>();
        lists.add(activity);
        return lists;
    }

    /**
     * 将任务卡的数据主键推送到流程变量
     * @param context
     * @return
     */
    private List<Activity> buildDataSaveActivity(SetParseContext context) {
        List<Activity> lists = new ArrayList<>();
        Activity filterActivity = new Activity();
        filterActivity.setTenantId("SYSTEM");
        filterActivity.setApplication(context.getCurrentSet().getAppCode());
        filterActivity.setVersion(context.getCurrentSet().getVersion());
        filterActivity.setPluginId(context.getCurrentSet().getCode());
        filterActivity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.dataSave);
        filterActivity.setType("script");
        filterActivity.setName("推送数据唯一id");
        HashMap<String, Object> filterConfig = new HashMap<>();
        filterConfig.put("executionMode", "script");
        filterConfig.put("scriptMode", ImmutableMap.of("responseScript", getDataSaveRequestScript()));
        filterActivity.setConfig(filterConfig);
        filterActivity.setMilestone(false);
        lists.add(filterActivity);
        return lists;
    }

    private String getDataSaveRequestScript() {
        // 侦测数据在服务编排时已经存到common-driven服务，并且加上了唯一id
        // 此处将每个任务卡的唯一id存到processVariable里，在任务卡页面请求时带上这些id
        // 问了仙仙，流程变量作为esp请求参数时只能用字符串
        return "var info=$(data);\n"+
                "var idStr = [];\n" +
                "if(info&&info.length>0) {\n" +
                "for(var i=0;i<info.length;i++){" +
                "var item=info[i];" +
                "if(item."+SetConstants.COMMON_DATA_DEFAULT_PK+") {" +
                "idStr.push({'heart_control_data_id':item."+SetConstants.COMMON_DATA_DEFAULT_PK+"});" +
                "}}}" +
                "return{'success':true,'processVariable':{'query_condition':idStr},'errorMessage':''};";
    }

    private List<Activity> buildManualActivity(SetParseContext context, SmartAdjustProjectPart part) {
        List<Activity> lists = new ArrayList<>();
        //执行人选择的字段
        if (part.getProcessor().getType().equals("field")) {
            Activity activity = new Activity();
            activity.setTenantId("SYSTEM");
            activity.setApplication(context.getCurrentSet().getAppCode());
            activity.setVersion(context.getCurrentSet().getVersion());
            activity.setPluginId(context.getCurrentSet().getCode());
            activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.extractPerformer);
            activity.setName("获取执行人");
            HashMap<String, Object> config = new HashMap<>();
            config.put("executionMode", "script");
            //如果需要转换 则创建http调用eoc接口放performer_id  否则直接创建script脚本放performer_id
            if (part.getProcessor().isConvert()) {
                activity.setType(SmartAdjustConstants.ActivityBuilder.http);
                config.put("method", "post");
                config.put("domain", "eoc");
                config.put("contentType", "json");
                config.put("url", "/api/eoc/v2/emp/user/id");
                config.put("headers", ImmutableMap.of("security-token", "$(_ActLatelySecurityToken)"));
                config.put("scriptMode", ImmutableMap.of("responseScript", "var response=$(response);" +
                                "return{\"success\":response.success,\"processVariable\":{\"performer_id\":response" +
                                ".data},\"errorMessage\":response.message};", "requestScript",
                        "var info=$(data);var request={'empId':info[0]." + part.getProcessor().getValue() + "};return" +
                                " request;"));
            } else {
                config.put("scriptMode", ImmutableMap.of("responseScript",
                        extractPerformerResponseScript(part.getProcessor().getValue())));
                activity.setType(SmartAdjustConstants.ActivityBuilder.script);
            }
            activity.setConfig(config);
            activity.setMilestone(false);
            lists.add(activity);
        }
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual);
        activity.setType(SmartAdjustConstants.TaskBuilder.manual);
        activity.setName("人工任务");
        activity.setExecutor(this.getUserDefinition(part.getProcessor(), "$(performer_id)"));
        activity.setMilestone(true);
        lists.add(activity);
        buildSubmitterManualActivity(context, part, lists);
        return lists;
    }

    /**
     * 创建让人工任务将上一个提交人转化为任务提交人并推送到流程变量中
     * @param context 上下文
     * @param part 参数
     * @param lists 活动集合
     */
    private void buildSubmitterManualActivity(SetParseContext context, SmartAdjustProjectPart part, List<Activity> lists) {
        List<Processor> params = part.getParams();
        if (CollUtil.isEmpty(params)) {
            return;
        }
        if (params.stream().anyMatch(e -> StrUtil.equals(e.getType(), "processVariable"))) {
            Activity activity = new Activity();
            activity.setTenantId("SYSTEM");
            activity.setApplication(context.getCurrentSet().getAppCode());
            activity.setVersion(context.getCurrentSet().getVersion());
            activity.setPluginId(context.getCurrentSet().getCode());
            activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.taskSubmitter);
            activity.setName("获取任务提交人");
            // 调用eoc接口转换任务提交人
            HashMap<String, Object> config = new HashMap<>();
            config.put("executionMode", "script");
            activity.setType(SmartAdjustConstants.ActivityBuilder.http);
            config.put("method", "post");
            config.put("domain", "eoc");
            config.put("contentType", "json");
            config.put("url", "/api/eoc/v2/emp/id");
            config.put("headers", ImmutableMap.of("security-token", "$(_ActLatelySecurityToken)"));
            config.put("scriptMode", ImmutableMap.of("responseScript", "var response=$(response);" +
                            "return{\"success\":response.success,\"processVariable\":{\"@taskPerformerId\":response" +
                            ".data},\"errorMessage\":response.message};", "requestScript",
                    "var request={'userId':'$(_ActLatelyPerformerId)'};return request;"));
            activity.setConfig(config);
            activity.setMilestone(false);
            lists.add(activity);
        }

    }

    private Object extractPerformerResponseScript(String performer) {
        return "var data=$(data);return{'success':true,'processVariable':{'performer_id':data[0]." + performer + "}," +
                "'errorMessage':''};";
    }

    private List<Activity> buildApproveActivity(SetParseContext context, SmartAdjustProjectPart part) {
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.approve);
        activity.setType(SmartAdjustConstants.TaskBuilder.approve);
        activity.setName("签核");
        HashMap<String, Object> config = new HashMap<>();
        ApproveInfo approve = part.getApprove();
        ApproveInitiator approveInitiator = new ApproveInitiator();
        approveInitiator.setType("processVariable");
        approveInitiator.setValue("personInCharge");
        approve.setInitiator(approveInitiator);
        config.put(SmartAdjustConstants.TaskBuilder.approve, part.getApprove());
        activity.setConfig(config);
        activity.setMilestone(true);
        List<Activity> lists = new ArrayList<>();
        lists.add(activity);
        return lists;
    }

    private List<Activity> buildBackstageActivity(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        List<Activity> lists = new ArrayList<>();
        Activity filterActivity = new Activity();
        filterActivity.setTenantId("SYSTEM");
        filterActivity.setApplication(context.getCurrentSet().getAppCode());
        filterActivity.setVersion(context.getCurrentSet().getVersion());
        filterActivity.setPluginId(context.getCurrentSet().getCode());
        filterActivity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.filter);
        filterActivity.setType("script");
        filterActivity.setName("筛选数据");
        HashMap<String, Object> filterConfig = new HashMap<>();
        filterConfig.put("executionMode", "script");
        filterConfig.put("scriptMode", ImmutableMap.of("responseScript", filerResponseScript(part)));
        filterActivity.setConfig(filterConfig);
        filterActivity.setMilestone(false);
        lists.add(filterActivity);

        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion(context.getCurrentSet().getVersion());
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.activity + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.ActivityBuilder.backstage);
        activity.setType("esp");
        activity.setName("回写");
        HashMap<String, Object> config = new HashMap<>();
        config.put("async", false);
        config.put("executionMode", "script");
        config.put("product", part.getProductName());
        String serviceName = part.getServiceName();
        config.put("serviceName", serviceName);
        config.put("headers", ImmutableMap.of("security-token", "$(_ActLatelySecurityToken)"));
        config.put("scriptMode", ImmutableMap.of("responseScript", getResponseScript(), "requestScript",
                getRequestScript(part, context)));
        activity.setConfig(config);
        activity.setMilestone(true);
        lists.add(activity);
        return lists;
    }

    private Object filerResponseScript(SmartAdjustProjectPart part) {
        List<Processor> params = part.getParams();
        ArrayList<StringBuilder> stringBuilderArrayList = new ArrayList<>();
        for (Processor param : params) {
            StringBuilder stringBuilder = new StringBuilder();
            if (param.getType().equals("Constant")) {
                stringBuilder.append("newItem.").append(param.getName()).append("= '").append(param.getValue()).append("'");
            } else if (param.getType().equals("processVariable")) {
                stringBuilder.append("newItem.").append(param.getName()).append("= ").append("'$(@taskPerformerId)'");
            } else {
                stringBuilder.append("newItem.").append(param.getName()).append("= item.").append(param.getValue());
            }
            stringBuilderArrayList.add(stringBuilder);
        }
        String collect = String.join(";", stringBuilderArrayList);
        return "var rd=$(data);var info=[];if(rd&&rd.length>0){for(var i=0;i<rd.length;i++){var item=rd[i];if(item" +
                ".adjust===true){var newItem={};" + collect + ";info.push(newItem)}}};var success=true;var " +
                "errorMessage='';" +
                "return{'success':success,'processVariable':{'apiData':info},'errorMessage':errorMessage};";
    }

    private String getRequestScript(SmartAdjustProjectPart part, SetParseContext context) throws DWBusinessException {
        List<ApiDataFieldMetadataDTO> actionParameters =
                kgService.getActionParameters(part.getActionId(), AthenaUtils.getTenantId(),
                        context.getCurrentSet().getVersion());
        String credit_info = "credit_info";
        if (!actionParameters.isEmpty()) {
            credit_info = actionParameters.get(0).getData_name();
        }
        return "var request={'std_data':{'parameter':{'" + credit_info + "':$(apiData)}}};return request;";
    }

    private String getResponseScript() {
        return "var response = $(response);\n" +
                "  var success = true;\n" +
                "  var result = '';\n" +
                "  var errorMessage = '';\n" +
                "  if (response['std_data']['execution']['code'] == '0') {\n" +
                "      errorMessage = 'Success';\n" +
                "      result = response['std_data']['parameter']['result'];\n" +
                "  } else {\n" +
                "      success = false;\n" +
                "      errorMessage = response['std_data']['execution']['description'];\n" +
                "  }\n" +
                "  return {\n" +
                "      'success': success,\n" +
                "      'processVariable': {\n" +
                "          'process_result': result\n" +
                "      },\n" +
                "      'errorMessage': errorMessage\n" +
                "  };";
    }

    private Set<String> buildPageView(SetParseContext context, SmartAdjustProjectPart part) {
        List<PageView> pageViews = part.getPageViews();
        String code = context.getCurrentSet().getCode();
        Set<String> showFieldCodes = new HashSet<>();
        // 前端没传过来，走老逻辑
        if (CollectionUtils.isEmpty(pageViews)) {
            List<PageView> pageViewList = new ArrayList<>();
            List<Task> taskList =
                    context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals(SmartAdjustConstants.TaskBuilder.manual)).collect(Collectors.toList());
            for (Task task : taskList) {
                //todo 1.project-detail  2.showMetadatas字段里需要吗 貌似词库   3.task-card 4.mobile都暂不增加
                String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/" + task.getType() + "TaskPageView.json");
                String replaced = scriptTemplate.replaceAll("#pluginId#", code)
                        .replaceAll("#appCode#", context.getCurrentSet().getAppCode())
                        .replaceAll("#name#", task.getName())
                        .replaceAll("#code#", task.getCode())
                        .replaceAll("#taskName#", part.getTaskName())
                        .replaceAll("#version#", context.getCurrentSet().getVersion());
                pageViewList.add(JSON.parseObject(replaced, PageView.class));
            }
            context.getDtdRelatedInfo().setPageViewList(pageViewList);
        } else {
            PageView pageView = pageViews.get(0);
            Map<String, Object> pageViewPages = pageView.getPages();
            // 当前任务卡页面设计，使用前端传的替换掉默认的
            Object taskDetail = pageViewPages.get(TASK_DETAIL);
            Object taskDetailMobile = pageViewPages.get(TASK_DETAIL_MOBILE);
            Object projectCard = pageViewPages.get(PROJECT_CARD);
            Object taskCard = pageViewPages.get(TASK_CARD);
            List<PageView> pageViewList = new ArrayList<>();
            //PC端规则
            JSONArray rules = null;
            //手机端规则
            JSONArray mobileRules=null;
            List<Task> taskList =
                    context.getDtdRelatedInfo().getTaskList().stream().filter(v -> v.getExecuteType().equals(SmartAdjustConstants.TaskBuilder.manual)).collect(Collectors.toList());

            String queryServiceName = SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + context.getCurrentSet().getCode() + ".list.get";
            String submitServiceName = SetConstants.COMMON_DATA_MODEL_DATA_API_PREFIX + context.getCurrentSet().getCode() + ".update";
            String schemaName = SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode();
            String defaultPageViewField = AthenaUtils.loadStream("/sets/smartAdjust/defaultPageViewFields.json");
            String defaultPageViewFieldReplaced = defaultPageViewField.replaceAll("#queryActionId#", "esp_" + queryServiceName)
                    .replaceAll("#queryServiceName#", queryServiceName)
                    .replaceAll("#submitActionId#", "esp_" + submitServiceName)
                    .replaceAll("#submitServiceName#", submitServiceName)
                    .replaceAll("#submitActionSchema#", schemaName)
                    .replaceAll("#version#", context.getCurrentSet().getVersion());
            JSONObject defaultPageViewFieldObj = JSON.parseObject(defaultPageViewFieldReplaced);
            // 提交按钮配置
            JSONObject submitAction = buildSubmitParams(defaultPageViewFieldObj, part, schemaName);

            for (Task task : taskList) {
                //todo 1.project-detail  2.showMetadatas字段里需要吗 貌似词库   3.task-card 4.mobile都暂不增加
                String scriptTemplate = AthenaUtils.loadStream("/sets/smartAdjust/" + task.getType() + "TaskPageView.json");
                String replaced = scriptTemplate.replaceAll("#pluginId#", code)
                        .replaceAll("#appCode#", context.getCurrentSet().getAppCode())
                        .replaceAll("#name#", task.getName())
                        .replaceAll("#code#", task.getCode())
                        .replaceAll("#taskName#", part.getTaskName())
                        .replaceAll("#dataSourceName#", schemaName)
                        .replaceAll("#version#", context.getCurrentSet().getVersion());
                PageView parsedPageView = JSON.parseObject(replaced, PageView.class);
                // 数据源换成api类型
                Map<String, Object> dataSources = new HashMap<>();
                dataSources.put(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode(), defaultPageViewFieldObj.get("dataSources"));
                parsedPageView.setDataSources(dataSources);
                // 默认的pages
                JSONObject pages = new JSONObject(parsedPageView.getPages());
                // 拿到默认的submitActions替换掉前端传过来的
                Object submitActions = pages.getJSONObject(TASK_DETAIL).getJSONArray("dataStates").getJSONObject(0).get(SUBMIT_ACTIONS);

                String taskDetailStr = JSON.toJSONString(taskDetail);

                // 前端全部写死的query_data，后面可能需要换成实际的 schema
                //处理PC端签核任务
                JSONObject taskDetailObject = JSONObject.parseObject(taskDetailStr.replaceAll(QUERY_DATA, schemaName).replaceAll(SmartAdjustConstants.HEART_CONTROL_ACTION, schemaName));
                 rules = taskDetailObject.getJSONArray(RULE);

                setProveTaskDisable(taskDetailObject,showFieldCodes,task.getType(),submitAction,submitActions,true);
                pages.put(TASK_DETAIL, taskDetailObject);

                //此处要确认PC端提交的action和移动端提交的action是否一致，目前默认认为一致
                if(!Objects.isNull(taskDetailMobile)){
                String  taskDetailMobileStr= JSON.toJSONString(taskDetailMobile);
                    //处理移动端签核任务【手机端没有submitActions】
                    JSONObject taskDetailMobileObject = JSONObject.parseObject(taskDetailMobileStr.replaceAll(QUERY_DATA, schemaName).replaceAll(SmartAdjustConstants.HEART_CONTROL_ACTION, schemaName));
                    mobileRules = taskDetailMobileObject.getJSONArray(RULE);
                    //移动的submitActions和PC公用
                    setProveTaskDisable(taskDetailMobileObject,showFieldCodes,task.getType(),submitAction,submitActions,true);
                    pages.put(TASK_DETAIL_MOBILE, taskDetailMobileObject);
                }
                pages.put(PROJECT_CARD, handleCard(JSONObject.parseObject(JSON.toJSONString(projectCard).replaceAll(SmartAdjustConstants.HEART_CONTROL_ACTION, schemaName)), queryServiceName));
                pages.put(TASK_CARD, handleCard(JSONObject.parseObject(JSON.toJSONString(taskCard).replaceAll(SmartAdjustConstants.HEART_CONTROL_ACTION, schemaName)), queryServiceName));

                parsedPageView.setPages(pages);
                JSONObject parsedDataSource = new JSONObject(parsedPageView.getDataSources()).getJSONObject(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode());
                JSONObject dataSource = new JSONObject(pageView.getDataSources()).getJSONObject(SmartAdjustConstants.HEART_CONTROL_ACTION);
                JSONObject replacedDataSource = JSON.parseObject(dataSource.toJSONString().replaceAll(QUERY_DATA, schemaName));
                for (String key : replacedDataSource.keySet()) {
                    if (!parsedDataSource.containsKey(key)) {
                        if ("metadataFields".equals(key)) {
                            JSONArray metadataFields = replacedDataSource.getJSONArray("metadataFields");
                            if(!CollectionUtils.isEmpty(metadataFields)) {
                                replacedDataSource.put(key, metadataFields.getJSONObject(0).get("subFields"));
                            }
                        }
                        parsedDataSource.put(key, replacedDataSource.get(key));
                    }
                }
                parsedPageView.getDataSources().put(SetConstants.COMMON_DATA_MODEL_PREFIX + context.getCurrentSet().getCode(), parsedDataSource);
                pageViewList.add(parsedPageView);
            }
            // 保存规则
            saveRules(context, rules);
            //保存手机端规则
            saveRules(context,mobileRules);
            context.getDtdRelatedInfo().setPageViewList(pageViewList);
        }
        return showFieldCodes;
    }

    private JSONObject buildSubmitParams(JSONObject jsonObject, SmartAdjustProjectPart part, String schemaName) {
        JSONObject submitAction = jsonObject.getJSONObject(SUBMIT_ACTION);
        List<JSONObject> actionParams = new ArrayList<>();
        for (ReturnField returnField : part.getReturnFields()) {
            JSONObject field = new JSONObject();
            field.put("name", schemaName + "." + returnField.getDatasourceField());
            field.put("source", "");
            field.put("type", "GET_ACTION_RESPONSE");
            field.put("value", schemaName + "." + returnField.getDatasourceField());
            actionParams.add(field);
        }
        // 传入主键
        actionParams.add(new JSONObject().fluentPut("name", schemaName + "." + SetConstants.COMMON_DATA_DEFAULT_PK)
                .fluentPut("source", "")
                .fluentPut("type", "GET_ACTION_RESPONSE")
                .fluentPut("value", schemaName + "." + SetConstants.COMMON_DATA_DEFAULT_PK));
        submitAction.put("actionParams", actionParams);
        return submitAction;
    }

    /**
     * 处理卡片
     *
     * @param cardObj 卡片
     * @param serviceName 查询api名称
     * @return 处理后的卡片
     */
    private JSONObject handleCard(JSONObject cardObj, String serviceName) {
        if (cardObj != null) {
            JSONArray dataStates = cardObj.getJSONArray("dataStates");
            if (!CollectionUtils.isEmpty(dataStates)) {
                JSONObject dataState = dataStates.getJSONObject(0);
                JSONArray summaryFields = dataState.getJSONArray("summaryFields");
                if (!CollectionUtils.isEmpty(summaryFields)) {
                    for (int i = 0; i < summaryFields.size(); i++) {
                        JSONObject summaryField = summaryFields.getJSONObject(i);
                        summaryField.put("actionId", "esp_" + serviceName);
                    }
                }
            }
        }
        return cardObj;
    }

    /**
     * 保存规则
     *
     * @param context 上下文
     * @param rules   规则
     */
    private void saveRules(SetParseContext context, JSONArray rules) {
        if (null != rules && !rules.isEmpty()) {
            String code = context.getCurrentSet().getCode();
            String appCode = context.getCurrentSet().getAppCode();
            String version = context.getCurrentSet().getVersion();
            String activityCode = code + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual;
            List<Rule> ruleList = JSONObject.parseArray(rules.toJSONString(), Rule.class);
            // 人工任务
            for (Rule rule : ruleList) {
                rule.setApplication(appCode);
                rule.setDomain(PresetDomainEnum.ACTIVITY);
                rule.setDomainId(activityCode);
                rule.setPluginId(code);
                rule.setVersion(version);
            }
            // 存的是系统级的规则
            dataMapService.saveRules(ruleList);
        }
    }

    private void buildEmailSetting(SetParseContext context, SmartAdjustProjectPart part) throws DWBusinessException {
        // 上次的邮件定义
        List<EmailNotice> lastEmailNotices = context.getEmailNotices();
        if (!CollectionUtils.isEmpty(lastEmailNotices)) {
            List<EmailNotice> emailNotices = Optional.ofNullable(part.getEmailNotices()).orElse(new ArrayList<>());
            // 如果上次有但是这次没有，就调用新增接口，状态为停用
            List<EmailNotice> needCloseList = lastEmailNotices.stream().filter(e -> emailNotices.stream().noneMatch(e1 -> e1.getTiming().equals(e.getTiming()))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(needCloseList)) {
                String appCode = context.getCurrentSet().getAppCode();
                String code = context.getCurrentSet().getCode();
                // 查询影响到的租户id
                List<String> tenantIds = getTenantIds(appCode);
                String userId = AthenaUtils.getUserId();
                String currentLocale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
                String projectCode = SetConstants.PROJECT_PREFIX + code;
                String manualTaskCode = code + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.task + SmartAdjustConstants.UNDERLINE + SmartAdjustConstants.TaskBuilder.manual;
                if (!CollectionUtils.isEmpty(tenantIds)) {
                    for (EmailNotice emailNotice : needCloseList) {
                        if (CollectionUtils.isEmpty(emailNotice.getReceivers())) {
                            continue;
                        }
                        EmailNoticeTimingEnum timingEnum = EmailNoticeTimingEnum.getByCode(emailNotice.getTiming());
                        for (String tenantId : tenantIds) {
                            EmailTemplateReq req = new EmailTemplateReq();
                            req.setTenantId(tenantId);
                            req.setAppCode(appCode);
                            JSONObject name = new JSONObject();
                            name.put("zh_CN", String.format("业务过程随心控%s邮件通知", timingEnum.getDesc()));// 任务完成 ， 项目结案
                            name.put("zh_TW", String.format("业务过程随心控%s邮件通知", timingEnum.getDesc()));
                            name.put("en_US", String.format("业务过程随心控%s邮件通知", timingEnum.getDesc()));
                            req.setEmailName(name);
                            req.setDescription(name);
                            switch (timingEnum) {
                                case TASK_END:
                                    req.setType(2);
                                    break;
                                case PROJECT_BEGIN:
                                    req.setType(3);
                                    break;
                                case PROJECT_END:
                                    req.setType(4);
                                    break;
                                case TASK_BEGIN:
                                default:
                                    req.setType(1);
                                    break;
                            }
                            // 直接停用，服务编排里会新增本次添加的
                            req.setState(0);
                            req.setUpdateBy(userId);
                            req.setReceiveStaff(emailNotice.getReceivers());
                            req.setLangName(currentLocale);
                            List<Map<String, String>> activities = new ArrayList<>();
                            Map<String, String> map = new HashMap<>();
                            map.put("taskId", projectCode);
                            map.put("activityId", EmailNoticeTimingEnum.PROJECT_END.equals(timingEnum) ? null : manualTaskCode);
                            activities.add(map);
                            req.setActivityList(activities);
                            req.setPreviewId(EmailEventIdEnum.getEmailEventId(timingEnum.getCode(), currentLocale));
                            atmcService.addEmailTemplate(req);
                        }
                    }
                }
            }
        }
    }

    /**
     * 查询受影响的租户id
     * @param appCode 应用code
     * @return 受影响的租户id
     */
    private List<String> getTenantIds(String appCode) {
        List<String> tenantIds = new ArrayList<>();
        List<AppPurchaseInfo> tenantIdDataList = cacService.getAllEffectiveTenantAndAppInfo(appCode).getList();
        if (!CollectionUtils.isEmpty(tenantIdDataList)) {
            tenantIds = tenantIdDataList.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
        }
        return tenantIds;
    }


    private UserDefinition getUserDefinition(Processor processor, String variable) {
        UserDefinition userDefinition = new UserDefinition();
        userDefinition.setChoosePolicy("single");
        userDefinition.setProcessType("signOr");
        Identity identity = new Identity();
        //如果是字段类型 代表一定为人员  且取约定的流程变量
        if (processor.getType().equals("field")) {
            identity.setPerformerType("user");
            identity.setPerformerValue(variable);
        } else {
            identity.setPerformerType(processor.getType());
            identity.setPerformerValue(processor.getValue());
        }
        identity.setPerformerName(processor.getName());
        userDefinition.setIdentities(Collections.singletonList(identity));
        return userDefinition;
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction()) {
            for (String str : executeNeo4jScripts) {
                session.query(str, new HashMap<>());
            }
            transaction.commit();
        } catch (Exception e) {
            log.error("executeNeo4jScript error:{}", e.toString());
        }
        session.clear();
    }

    private void conventionField(ArrayList<ReturnField> actionList) {
        ReturnField performerField = new ReturnField();
        performerField.setHide(true);
        performerField.setEditable(false);
        performerField.setValueType("string");
        performerField.setDatasourceField("performer_id");
        performerField.setDisplayName("执行人");
        actionList.add(performerField);
        ReturnField chargeField = new ReturnField();
        chargeField.setHide(true);
        chargeField.setEditable(false);
        chargeField.setValueType("string");
        chargeField.setDatasourceField("charge_id");
        chargeField.setDisplayName("当责者");
        actionList.add(chargeField);
        ReturnField adjustField = new ReturnField();
        adjustField.setHide(true);
        adjustField.setEditable(false);
        adjustField.setValueType("boolean");
        adjustField.setType("Fixed");
        adjustField.setDatasourceField("adjust");
        adjustField.setDisplayName("是否调整");
        actionList.add(adjustField);
        ReturnField remarkField = new ReturnField();
        remarkField.setHide(true);
        remarkField.setEditable(false);
        remarkField.setValueType("text");
        remarkField.setType("Fixed");
        remarkField.setDatasourceField("remark");
        remarkField.setDisplayName("备注/说明");
        actionList.add(remarkField);
        ReturnField taskPerformerField = new ReturnField();
        taskPerformerField.setHide(true);
        taskPerformerField.setEditable(false);
        taskPerformerField.setValueType("string");
        taskPerformerField.setType("processVariable");
        taskPerformerField.setDatasourceField("@taskPerformerId");
        taskPerformerField.setDisplayName("任务提交人员工Id");
        actionList.add(taskPerformerField);
    }

    /***
     * 设置签核任务不可编辑，并设置actions
     * @param taskDetailObject
     * @param showFieldCodes
     * @param taskType
     * @param submitAction
     * @param submitActions
     * @param isSetAction
     */
    public void setProveTaskDisable(JSONObject taskDetailObject, Set<String> showFieldCodes ,
                                    String taskType,JSONObject submitAction,Object submitActions,boolean isSetAction){
        JSONArray dataStates = taskDetailObject.getJSONArray("dataStates");
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject jsonObject = dataStates.getJSONObject(0);
            JSONArray layout = jsonObject.getJSONArray("layout");
            if (!CollectionUtils.isEmpty(layout)) {
                for (int i = 0; i < layout.size(); i++) {
                    JSONObject layoutItem = layout.getJSONObject(i);
                    if (layoutItem != null && "ATHENA_TABLE".equals(layoutItem.getString("type"))) {
                        JSONArray columnDefs = layoutItem.getJSONArray("columnDefs");
                        if (!CollectionUtils.isEmpty(columnDefs)) {
                            for (int j = 0; j < columnDefs.size(); j++) {
                                JSONArray columns = columnDefs.getJSONObject(j).getJSONArray("columns");

                                if (!CollectionUtils.isEmpty(columns)) {
                                    JSONObject column = columns.getJSONObject(0);
                                    showFieldCodes.add(column.getString("schema"));
                                    // 签核任务字段不可编辑
                                    if(StringUtils.equals(SmartAdjustConstants.TaskBuilder.approve,taskType)) {
                                        column.put("disabled", true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if(isSetAction){
                if (StringUtils.equals(BUSINESS,taskType)) {
                    // 人工任务改成esp提交
                    jsonObject.put(SUBMIT_ACTIONS, Collections.singletonList(submitAction));
                } else {
                    jsonObject.put(SUBMIT_ACTIONS, submitActions);
                }
            }
        }
    }
}
