package com.digiwin.athena.knowledgegraph.spi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.*;
import com.digiwin.athena.knowledgegraph.support.BusinessException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/6/3 <br>
 */
@Slf4j
@Service
public class ApimgmtService  {


    @Value("${apimgmtUrl}")
    private String apimgmtUrl;

    @Value("${envMode}")
    private String envMode;

    /**
     * @return void
     * @Description //同步数据到apimgmt，第一次同步是草稿状态，所以同步完需要调用更新接口，变成开发中
     * @Date 2023/6/8 11:05
     * @Param [publishActionMetaDataInfo, token]
     **/
    public void publishActionMeataDataToApimgmt(JSONArray publishActionMetaDataInfo, String token) {

        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return;
        }


        // 保存api数据
        log.info("----------------开始保存数据");
        List<ApiMgmtBaseInfo> apiMgmtBaseInfos = dealApiMgmtProcessSave(publishActionMetaDataInfo, token);
        log.info("----------------开始保存数据--完成");

        // 送审
        log.info("----------------开始送审");
        dealApiMgmtProcessUpdate(apiMgmtBaseInfos,token);
        log.info("----------------送审完成--完成");

        // 定版,  paas区和华为test区，不需要定版
        if(!envMode.equals(Constants.ENV_MODE_HW_TEST) && !envMode.equals(Constants.ENV_MODE_PASS)){
            log.info("--------------需要定版--开始定版--定版");
            dealApiMgmtProcessConfirmed(apiMgmtBaseInfos, token);
            log.info("----------------定版完成--完成");
        }

        log.info("update api mgmt success, apiName is list");
    }

    // 定版--正式区才需要定版
    private void dealApiMgmtProcessConfirmed(List<ApiMgmtBaseInfo> apiUpdateList, String token) {
        if(CollUtil.isEmpty(apiUpdateList)){
            log.info("update api mgmt apiUpdateList is null, not need to Confirmed");
            return;
        }
        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiUpdateList);
        String jsonUpdateRequest = JSON.toJSONString(apiMgmtUpdateModel);

        String domain = apimgmtUrl;
        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        // 定版
        String confirmedUrl = domain + "/restful/standard/apimgmt/ApiComfirmed/Update";
        log.info("apiConfirmedUpdate api mgmt request is -->{}", jsonUpdateRequest);
        String confirmedResponse = HttpUtil.createPost(confirmedUrl).addHeaders(headers).body(jsonUpdateRequest).execute().body();
        log.info("apiConfirmedUpdate api mgmt response is -->{}", confirmedResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject(confirmedResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(confirmedResponse);
        }
    }



    // 送审
    private void dealApiMgmtProcessUpdate(List<ApiMgmtBaseInfo> apiUpdateList, String token) {

        if(CollUtil.isEmpty(apiUpdateList)){
            log.info("update api mgmt apiUpdateList is null, no need to update");
            return;
        }
        String domain = apimgmtUrl;
        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        // 更新状态到开发中
        String updateUrl = domain + "/restful/standard/apimgmt/ApiReview/Update";

        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiUpdateList);
        String jsonUpdateRequest = JSON.toJSONString(apiMgmtUpdateModel);
        log.info("update api mgmt request is -->{}", jsonUpdateRequest);
        String updateResponse = HttpUtil.createPost(updateUrl).body(jsonUpdateRequest).addHeaders(headers).execute().body();
        log.info("update api mgmt update response is -->{}", updateResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject(updateResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(updateResponse);
        }


    }

    private List<ApiMgmtBaseInfo> dealApiMgmtProcessSave(JSONArray publishActionMetaDataInfo, String token){

        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return new ArrayList<>();
        }

        String domain = apimgmtUrl;
        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        List<ApiMgmtBaseInfo> apiUpdateList = new ArrayList<>();

        for (int i = 0; i < publishActionMetaDataInfo.size(); i++) {

            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();

            JSONObject jsonObject = publishActionMetaDataInfo.getJSONObject(i);
            JSONObject apiMgmtModelSaveJson = jsonObject.getJSONObject("apiMgmtModelSave");
            if (apiMgmtModelSaveJson == null) {
                continue;
            }
            String tenantId = apiMgmtModelSaveJson.getString("tenantId");
            if (StringUtils.isNotBlank(tenantId)) {
                apiMgmtModelSaveJson.remove("tenantId");
            }

            String apiName = jsonObject.getString("apiName");
            String version = jsonObject.getString("version");
//            if (!CollectionUtils.isEmpty(noPublishApis) && noPublishApis.contains(apiName)) {
//                log.info("The api {} does not need to publish api mgmt", apiName);
//                continue;
//            }
            if(null==version){
                version="1.0";
            }

            apiMgmtBaseInfo.setApiName(apiName);

            //先删除后增加
            dealApiMgmtDelete(apiName,version,token);

            // 1.查询api的最大版本号，和状态
//            String advanceSearchUrl = domain + "/restful/standard/apimgmt/AdvanceSearchApiList/Get";
//
//            List<ApiMgmtCondition> apiMgmtConditions = new ArrayList<>();
//            ApiMgmtCondition apiMgmtCondition = new ApiMgmtCondition();
//            apiMgmtCondition.setCondition("apiName");
//            apiMgmtCondition.setEquation("equal");
//            apiMgmtCondition.setContent(apiName);
//
//            apiMgmtConditions.add(apiMgmtCondition);
//
//            AdvanceSearchConditions advanceSearchConditions = new AdvanceSearchConditions();
//            advanceSearchConditions.setConditionList(apiMgmtConditions);
//
//            String advanceSearchRequest = JSON.toJSONString(advanceSearchConditions);
//            log.info("advanceSearch api mgmt request is -->{}", advanceSearchRequest);
//            String advanceSearchResponse = HttpUtil.createPost(advanceSearchUrl).addHeaders(headers).body(advanceSearchRequest).execute().body();
//            log.info("advanceSearch api mgmt response is -->{}", advanceSearchResponse);
//
//            int status = 0;
//            List<ApiAdvanceSearchInfo> apiAdvanceSearchList = new ArrayList<>();
//            try{
//                // 1.1获取到结果后处理
//                ObjectMapper objectMapper = new ObjectMapper();
//                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
//
//                // 解析参数
//                ApiAdvanceSearchResponse apiAdvanceSearchResponse =
//                        objectMapper.readValue(advanceSearchResponse, new TypeReference<ApiAdvanceSearchResponse>() {
//                });
//                status = apiAdvanceSearchResponse.getStatus();
//                apiAdvanceSearchList = apiAdvanceSearchResponse.getResponse();
//
//            }
//            catch (Exception exception){
//                throw new BusinessException("解析-查询api结果异常");
//            }
//
//            if (status != 200) {
//                throw new BusinessException(advanceSearchResponse);
//            }
//
//            if (CollUtil.isNotEmpty(apiAdvanceSearchList)) {
//                // 有数据
//                ApiAdvanceSearchInfo apiAdvanceSearchInfo = apiAdvanceSearchList.get(0);
//                int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
//
//                // 如果是虚拟用户 apiBuildAcct = virtual
//                // 虚拟用户，先删除，以后创建都是集成账号
//                String apiBuildAcct = apiAdvanceSearchInfo.getApiBuildAcct();
//                if (apiBuildAcct.equals(Constants.VIRTUAL_USER)) {
//                    log.info(apiName + " 是虚拟用户，先进行删除操作");
//                    // 稳妥起见，1.1版本的也删除一遍，以后不会再有虚拟用户，所以不影响
//                    dealApiMgmtDelete(apiName, "1.1", token);
//                    dealApiMgmtDelete(apiName, "1.0", token);
//
//                    approvedStatusCode = 1;
//                }
//
//
//                String version = apiAdvanceSearchInfo.getVersion();
//                apiMgmtBaseInfo.setVersion(version);
//                // 1草稿，2审核中，3开发中，4已定版，5停用
//                // 草稿的可以直接保存，模型没有审核状态，开发中的要取回，已定版的需要进版，模型没有停用状态
//                switch (approvedStatusCode) {
//                    case Constants.API_STATUS_DRAFT:
//                        // 草稿状态，可以直接保存
//                        log.info("api是草稿状态");
//                        dealApiMgmtSave(apiMgmtModelSaveJson, version, token);
//                        break;
//                    case Constants.API_STATUS_DEV:
//                        // 开发中状态，要取回再保存到草稿
//                        log.info("api是开发状态，需要取回");
//                        dealApiMgmtRetrieve(apiName, version, token);
//                        log.info("已取回");
//                        dealApiMgmtSave(apiMgmtModelSaveJson, version, token);
//                        break;
//                    case Constants.API_STATUS_CONFIRMED:
//                        // 已经定版的，需要进版
//                        log.info("api已经定版，需要获取进版版本号再进版");
//                        // 1.获取进版的版本号
//                        String apiVersion = getApiVersion(apiName, token);
//                        apiMgmtBaseInfo.setVersion(apiVersion);
//                        log.info("进版版本号={}", apiVersion);
//                        // 2.保存到草稿
//                        dealApiMgmtSave(apiMgmtModelSaveJson, apiVersion, token);
//                        break;
//                    default:
//                        // 其他结果处理
//                        throw new BusinessException("解析-查询api结果的状态未知apiName=" + apiName);
//                }
//            } else {
                apiMgmtBaseInfo.setVersion(version);
                // 没有数据，第一次保存
                log.info(apiName + "没有数据，第一次保存");
                dealApiMgmtSave(apiMgmtModelSaveJson, version, token);
          //  }
            apiUpdateList.add(apiMgmtBaseInfo);
        }
        return apiUpdateList;
    }


    // 删除api方法封装
    private void dealApiMgmtDelete(String apiName, String version, String token) {

        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);

        List<ApiMgmtBaseInfo> apiList = new ArrayList<>();
        apiList.add(apiMgmtBaseInfo);

        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        String domain = apimgmtUrl;

        String deleteUrl = domain + "/restful/standard/apimgmt/ApiDelete/Delete";

        ApiMgmtUpdateModel apiMgmtApiDelete = new ApiMgmtUpdateModel();
        apiMgmtApiDelete.setApiList(apiList);
        apiMgmtApiDelete.setStatusId(3);
        String jsonRetrieveApi = JSON.toJSONString(apiMgmtApiDelete);
        log.info("ApiDelete api mgmt request is -->{}", jsonRetrieveApi);
        String deleteApiResponse = HttpUtil.createPost(deleteUrl).body(jsonRetrieveApi).addHeaders(headers).execute().body();
        log.info("ApiDelete api mgmt response is -->{}", deleteApiResponse);
        JSONObject jsonObjectResponse = JSON.parseObject(deleteApiResponse);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(deleteApiResponse);
        }
        log.info("删除成功, apiName is -->{}", apiName);
    }



    // 获取进版的版本号的方法封装
    private String getApiVersion(String apiName, String token) {

        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setTenantId("");

        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        String domain = apimgmtUrl;

        String getVersionUrl = domain + "/restful/standard/apimgmt/ApiVersion/Get";

        String jsonStringRequest = JSON.toJSONString(apiMgmtBaseInfo);
        log.info("get version api mgmt request is -->{}", jsonStringRequest);
        String response = HttpUtil.createPost(getVersionUrl).addHeaders(headers).body(jsonStringRequest).execute().body();
        log.info("get version api mgmt response is -->{}", response);
        JSONObject jsonObjectResponse = JSON.parseObject(response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }

        String version = response1.getString("version");

        return version;
    }


    // 取回apimgmt的方法封装
    private void dealApiMgmtRetrieve(String apiName, String version, String token) {

        ApiMgmtUpdateModel apiMgmtRetrieveModel = new ApiMgmtUpdateModel();
        List<ApiMgmtBaseInfo> apiList = new ArrayList<>();
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);
        apiList.add(apiMgmtBaseInfo);

        apiMgmtRetrieveModel.setApiList(apiList);


        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        String domain = apimgmtUrl;

        String retrieveUrl = domain + "/restful/standard/apimgmt/ApiSpecRetrieve/Update";

        String jsonStringRequest = JSON.toJSONString(apiMgmtRetrieveModel);
        log.info("retrieve api mgmt request is -->{}", jsonStringRequest);
        String response = HttpUtil.createPost(retrieveUrl).addHeaders(headers).body(jsonStringRequest).execute().body();
        log.info("retrieve api mgmt response is -->{}", response);
        JSONObject jsonObjectResponse = JSON.parseObject(response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("retrieve api mgmt success, apiName is -->{}", apiName);
    }


    // 保存apimgmt的方法封装
    private void dealApiMgmtSave(JSONObject apiMgmtModelSaveJson, String version, String token) {

        // 按版本保存
        apiMgmtModelSaveJson.put("apiVersion",version);
        String apiName = apiMgmtModelSaveJson.getString("apiName");

        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");

        String domain = apimgmtUrl;

        String saveUrl = domain + "/restful/standard/apimgmt/ApiSpec/Save";

        String jsonStringRequest = JSON.toJSONString(apiMgmtModelSaveJson);
        log.info("save api mgmt request is -->{}", jsonStringRequest);
        String response = HttpUtil.createPost(saveUrl).addHeaders(headers).body(jsonStringRequest).execute().body();
        log.info("save api mgmt response is -->{}", response);
        JSONObject jsonObjectResponse = JSON.parseObject(response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("保存成功, apiName is -->{}", apiName);
    }







    /**
     * @return void
     * @Description //删除apimgmt的数据
     * @Date 2023/6/8 13:50
     * @Param [publishActionMetaDataInfo, token]
     **/
    public void deleteActionMeataDataInApimgmt(JSONObject publishActionMetaDataInfo, String token) {

        if (publishActionMetaDataInfo == null) {
            log.info("deleteActionMeataDataInApimgmt, publishActionMetaDataInfo is null");
            return;
        }

        String domain = apimgmtUrl;
        String uri = domain + "/restful/standard/apimgmt/ApiDelete/Delete";

        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");


        ApiMgmtDeleteModel apiMgmtDeleteModel = new ApiMgmtDeleteModel();
        List<ApiMgmtBaseInfo> list = new ArrayList<>();
        JSONArray jsonArray = publishActionMetaDataInfo.getJSONArray("apiList");
        if (jsonArray == null || jsonArray.size() ==0) {
            log.info("dpublishActionMetaDataInfo.getJSONArray is null");
            return;
        }
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();

            // 删除，已经定版的不可以删除，开发中的删除，草稿中的也可以删除
            // 删除之前先查询，获取版本号和状态
            String apiName = jsonObject.getString("apiName");
            ApiAdvanceSearchInfo apiAdvanceSearchInfo = queryApiVersionAndStatus(apiName, token);
            if (apiAdvanceSearchInfo == null) {
                continue;
            }
            int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
            if (Constants.API_STATUS_CONFIRMED == approvedStatusCode) {
                // 已经定版的不删除
                log.info("do not delete confirmed api , apiName is = {}", apiName);
                continue;
            }

            // 删除草稿或者开发态的api
            apiMgmtBaseInfo.setApiName(apiName);
            apiMgmtBaseInfo.setVersion(apiAdvanceSearchInfo.getVersion());
            list.add(apiMgmtBaseInfo);
        }

        apiMgmtDeleteModel.setStatusId(1);
        apiMgmtDeleteModel.setApiList(list);
        String jsonStringRequest = JSON.toJSONString(apiMgmtDeleteModel);

        log.info("deleteActionMeataDataInApimgmt api mgmt request is -->{}", jsonStringRequest);
        String response = HttpUtil.createPost(uri).addHeaders(headers).body(jsonStringRequest).execute().body();
        log.info("deleteActionMeataDataInApimgmt api mgmt response is -->{}", response);
        JSONObject jsonObjectDelResponse = JSON.parseObject(response);
        JSONObject responseDel = jsonObjectDelResponse.getJSONObject("response");
        String updateCode = responseDel.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(response);
        }
        log.info("delete api mgmt success");
    }


    private ApiAdvanceSearchInfo queryApiVersionAndStatus(String apiName,String token) {

        Map<String, String> headers = new HashMap<>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");


        // 1.查询api的最大版本号，和状态
        String domain = apimgmtUrl;
        String advanceSearchUrl = domain + "/restful/standard/apimgmt/AdvanceSearchApiList/Get";

        List<ApiMgmtCondition> apiMgmtConditions = new ArrayList<>();
        ApiMgmtCondition apiMgmtCondition = new ApiMgmtCondition();
        apiMgmtCondition.setCondition("apiName");
        apiMgmtCondition.setEquation("equal");
        apiMgmtCondition.setContent(apiName);

        apiMgmtConditions.add(apiMgmtCondition);

        AdvanceSearchConditions advanceSearchConditions = new AdvanceSearchConditions();
        advanceSearchConditions.setConditionList(apiMgmtConditions);

        String advanceSearchRequest = JSON.toJSONString(advanceSearchConditions);
        log.info("advanceSearch api mgmt request is -->{}", advanceSearchRequest);
        String advanceSearchResponse = HttpUtil.createPost(advanceSearchUrl).addHeaders(headers).body(advanceSearchRequest).execute().body();
        log.info("advanceSearch api mgmt response is -->{}", advanceSearchResponse);

        int status = 0;
        List<ApiAdvanceSearchInfo> apiAdvanceSearchList = new ArrayList<>();
        try {
            // 1.1获取到结果后处理
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

            // 解析参数
            ApiAdvanceSearchResponse apiAdvanceSearchResponse =
                    objectMapper.readValue(advanceSearchResponse, new TypeReference<ApiAdvanceSearchResponse>() {
                    });
            status = apiAdvanceSearchResponse.getStatus();
            apiAdvanceSearchList = apiAdvanceSearchResponse.getResponse();

        } catch (Exception exception) {
            log.info("get apiName is nothing!!!!!");
            return null;
        }

        if (status != 200) {
            throw new BusinessException(advanceSearchResponse);
        }

        if (CollUtil.isEmpty(apiAdvanceSearchList)) {
            return null;
        }
        return apiAdvanceSearchList.get(0);
    }

}