package com.digiwin.athena.knowledgegraph.support;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismAchiveRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-11-03 20:45
 **/
@Primary
@Service
public class CompositeMechanismCustomer implements MechanismCustomer{

    @Autowired
    private List<MechanismCustomer> customers;

    @Override
    public boolean accept(MechanismContext context) {

        return false;
    }

    @Override
    public Object notifyChange(MechanismContext context) throws DWBusinessException {
        if(null==context){return null;}
        for (MechanismCustomer customer: customers){
            if (customer.accept(context)){
               return customer.notifyChange(context);
            }
        }
        return null;
    }

    @Override
    public Object notifyApproveSuccess(MechanismContext context) throws DWBusinessException {
        if(null==context){return null;}
        for (MechanismCustomer customer: customers){
            if (customer.accept(context)){
                return customer.notifyApproveSuccess(context);
            }
        }
        return null;
    }

    @Override
    public Object filter(MechanismContext context) {
        if(null==context){return null;}
        for (MechanismCustomer customer: customers){
            if (customer.accept(context)){
                return customer.filter(context);
            }
        }
        return null;
    }

    @Override
    public void innerDoMechanismMaterialConfig(MechanismContext context) {
        if(null==context){}
        for (MechanismCustomer customer: customers){
            if (customer.accept(context)){
                 customer.innerDoMechanismMaterialConfig(context);
                 return;
            }
        }
    }
}
