package com.digiwin.athena.knowledgegraph.support;

import com.digiwin.app.resource.DWResourceBundleUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.NoSuchMessageException;
import org.springframework.stereotype.Service;

/**
需要有动态从某个地方(如redis)加载翻译字典功能
 **/
//@Service
public class LangService implements ApplicationContextAware {

    ApplicationContext context;

    public String getLang(String code){

        return getLang(code,null );

    };

    public String getLang(String code,Object[] param){

        try{
            return context.getMessage(code,param ,DWResourceBundleUtils.getCurrentLocale());
        }catch(NoSuchMessageException e){
            return null;
        }


    };

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}
