package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import java.util.List;
import java.util.Map;

/**
 * @ClassName Process
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/7/21 11:10
 * @Version 1.0
 **/
public class Process {
    private String id;
    private String name;
    private String tenantId;
    private List<Node> nodes;
    private List<Link> links;
    private List<ProcessVariable> processVariable;
    private Map nameI18n;
    private String linkType;
    private int limit;
    private Map completedEvent;
    private Map terminatedEvent;
    private Map abortedEvent;
    private boolean isAbortedNotice;
    private boolean isTerminatedNotice;
    private boolean isCompletedNotice;
    private boolean isReassignNotice;
    private boolean isRollbackNotice;
    private String categoryId;
    private String currentAuthorId;


    public String getId() {
        return id;
    }

    public Process setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public Process setName(String name) {
        this.name = name;
        return this;
    }

    public String getTenantId() {
        return tenantId;
    }

    public Process setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public List<Node> getNodes() {
        return nodes;
    }

    public Process setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public List<Link> getLinks() {
        return links;
    }

    public Process setLinks(List<Link> links) {
        this.links = links;
        return this;
    }

    public List<ProcessVariable> getProcessVariable() {
        return processVariable;
    }

    public Process setProcessVariable(List<ProcessVariable> processVariable) {
        this.processVariable = processVariable;
        return this;
    }

    public Map getNameI18n() {
        return nameI18n;
    }

    public Process setNameI18n(Map nameI18n) {
        this.nameI18n = nameI18n;
        return this;
    }

    public String getLinkType() {
        return linkType;
    }

    public Process setLinkType(String linkType) {
        this.linkType = linkType;
        return this;
    }

    public int getLimit() {
        return limit;
    }

    public Process setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Map getCompletedEvent() {
        return completedEvent;
    }

    public Process setCompletedEvent(Map completedEvent) {
        this.completedEvent = completedEvent;
        return this;
    }

    public Map getTerminatedEvent() {
        return terminatedEvent;
    }

    public Process setTerminatedEvent(Map terminatedEvent) {
        this.terminatedEvent = terminatedEvent;
        return this;
    }

    public Map getAbortedEvent() {
        return abortedEvent;
    }

    public Process setAbortedEvent(Map abortedEvent) {
        this.abortedEvent = abortedEvent;
        return this;
    }

    public boolean isAbortedNotice() {
        return isAbortedNotice;
    }

    public Process setAbortedNotice(boolean abortedNotice) {
        isAbortedNotice = abortedNotice;
        return this;
    }

    public boolean isTerminatedNotice() {
        return isTerminatedNotice;
    }

    public Process setTerminatedNotice(boolean terminatedNotice) {
        isTerminatedNotice = terminatedNotice;
        return this;
    }

    public boolean isCompletedNotice() {
        return isCompletedNotice;
    }

    public Process setCompletedNotice(boolean completedNotice) {
        isCompletedNotice = completedNotice;
        return this;
    }

    public boolean isReassignNotice() {
        return isReassignNotice;
    }

    public Process setReassignNotice(boolean reassignNotice) {
        isReassignNotice = reassignNotice;
        return this;
    }

    public boolean isRollbackNotice() {
        return isRollbackNotice;
    }

    public Process setRollbackNotice(boolean rollbackNotice) {
        isRollbackNotice = rollbackNotice;
        return this;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public Process setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public String getCurrentAuthorId() {
        return currentAuthorId;
    }

    public Process setCurrentAuthorId(String currentAuthorId) {
        this.currentAuthorId = currentAuthorId;
        return this;
    }
}
