package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

/**
 * @ClassName VelocityEngineHelper
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/8/20 17:24
 * @Version 1.0
 **/
public class VelocityEngineHelper {

    private static final String CLASS_LOADER_NAME = "classpath.resource.loader.class";
    private static final String CLASSPATH = "classpath";

    public static String replace(Map vars, String vmFilePath) {
        // 初始化模板引擎
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty(RuntimeConstants.RESOURCE_LOADER, CLASSPATH);
        ve.setProperty(CLASS_LOADER_NAME, ClasspathResourceLoader.class.getName());
        ve.init();
        // 获取模板文件
        Template template = ve.getTemplate(vmFilePath);
        // 设置变量
        VelocityContext ctx = new VelocityContext(vars);
        // 输出
        try (StringWriter sw = new StringWriter()) {
            template.merge(ctx,sw);
            return sw.toString();
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }

    }
}
