package com.digiwin.athena.knowledgegraph.svcomposition.graph;

import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @ClassName GraphHelperTemplate
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/8/18 13:58
 * @Version 1.0
 **/
public abstract class GraphHelperTemplate {

    public static final String VAR_DELIMITER = "_";

    public abstract void generateEdges(Map<String, Map> actionMap, Set<String> actionIds, List<Edge> edgeList, HashMap item, String queryActionId);

    public abstract void queryRequireFields(HashMap item, String queryActionId, Set<String> actionIds);

    public abstract void queryCreatesFields(HashMap item, String queryActionId);

    public final void processNodeAndEdges(Map<String, Map> actionMap, Set<String> actionIds, List<Edge> edgeList, HashMap item, String queryActionId) {
        generateEdges(actionMap, actionIds, edgeList, item, queryActionId);
        //查询依赖字段
        queryRequireFields(item, queryActionId, actionIds);
        //查询创建字段
        queryCreatesFields(item, queryActionId);
    }

    public static int getFirstNodeIndex(MatrixGraph graph) {
        for (int i = 0; i < graph.size(); i++) {
            if (graph.inDegree(i) == 0) {
                return i;
            }
        }
        throw new DWDataException(I18nUtils.getValue("knowledgegraph.startEndNodeNotFound"));
    }

}
