package com.digiwin.athena.knowledgegraph.synonym.controller.impl;


import com.digiwin.athena.knowledgegraph.synonym.controller.ISynonymService;
import com.digiwin.athena.knowledgegraph.synonym.dao.AppThresholdConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.BigScreenViewConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.EntityTypeDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.SmartUserConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.SyncAppInfoDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.SynonymDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.EntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.Synonym;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.*;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-25  17:21
 * @Description: TODO
 * @Version: 1.0
 */
@Service
public class SynonymService implements ISynonymService {
    @Autowired
    private SynonymDao synonymDao;
    @Autowired
    private AppThresholdConfigDao appThresholdConfigDao;
    @Autowired
    private BigScreenViewConfigDao bigScreenViewConfigDao;
    @Autowired
    private EntityTypeDao entityTypeDao;
    @Autowired
    private SmartUserConfigDao smartUserConfigDao;
    @Autowired
    private SyncAppInfoDao syncAppInfoDao;

    public ResultBean<?> test( Synonym synonymVo ) {
        return ResultBean.success("测试成功"+synonymVo.toString());
    }
    @Override
    public ResultBean<?> insertOrUpdate( Synonym synonymVo) {
        try {
            synonymDao.insertOrUpdate(synonymVo);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }
    @Override

    public ResultBean<?> saveAll( List<Synonym> synonym ) {
        try {
            synonymDao.saveAll(synonym);
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<?> insertAll(List<Synonym> synonym) {
        try {
            synonymDao.insertAll(synonym);
        }catch (Exception businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success(null);
    }

    @Override

    public ResultBean<Object> findListPage( PageSelectVo page) {
        try {

            return ResultBean.success(synonymDao.findListPage(page.getTenantId(),page.getProperNoun(),page.getEntityTypeName(),page.getDes(),page.getPage(),page.getPageSize()));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }
    @Override

    public ResultBean<Object> findListEx( ExportVo exportVo) {
        try {

            return ResultBean.success(synonymDao.findList(exportVo.getTenantId(),exportVo.getProperNoun(),exportVo.getEntityTypeName(),exportVo.getDes()));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }
    @Override

    public ResultBean<Object> findList( DeleteVo findVo) {
        try {
            return ResultBean.success(synonymDao.findList(findVo.getTid(),findVo.getIds()));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override

    public ResultBean<Object> delete( DeleteVo deleteVo) {
        try {
            synonymDao.delete(deleteVo.getIds(),deleteVo.getTid());
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> findOne(ExportVo exportVo) {
        try {
            return ResultBean.success(synonymDao.getOne(exportVo.getTenantId(),exportVo.getProperNoun(),exportVo.getEntityTypeName()));
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> findTwIsNotNull() {
        try {
            return ResultBean.success(synonymDao.getTwIsNotNullList());
        }catch (BusinessException businessException){
            return ResultBean.fail(1,businessException.getMessage());
        }
    }

    @Override

    public ResultBean<Object> dataMajor() {
        appThresholdConfigDao.dataMigration();
        bigScreenViewConfigDao.dataMigration();
        entityTypeDao.dataMigration();
        smartUserConfigDao.dataMigration();
        syncAppInfoDao.dataMigration();
        synonymDao.dataMigration();
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> findAll(PageSelectVo page) {
        return ResultBean.success(synonymDao.findAll(page.getPage(),page.getPageSize()));
    }

    @Override
    public ResultBean<Object> groupByEntityCount(DeleteVo deleteVo) {
        return ResultBean.success(synonymDao.groupByEntityCount(deleteVo.getTid()));
    }
}
