package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-14  16:52
 * @Description:
 * @Version: 1.0
 */
@Repository
public class BigScreenViewConfigDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;
    public BigScreenViewConfig findOne(String code){
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("bigScreenCode").is(code));
        query.addCriteria(criteria);
        return this.mongoTemplate.findOne(query, BigScreenViewConfig.class);
    }

    public List<BigScreenViewConfig> findList(String appCode, String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is(tenantId);
        if (StringUtils.isNotBlank(appCode)) {
            criteria.and("appCode").is(appCode);
        }
        query.addCriteria(criteria);
        List<BigScreenViewConfig> bigScreenViewConfigs = this.mongoTemplate.find(query, BigScreenViewConfig.class);
        return bigScreenViewConfigs;
    }
    public void deleteList(String tid, List<String> ids,String appCode) {
        if (StringUtils.isEmpty(tid)){
            throw new BusinessException("租户id不能为空");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is(tid);
        criteria.and("appCode").is(appCode);
        criteria.and("type").ne("custom");

        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("bigScreenCode").in(ids);
        }
        query.addCriteria(criteria);
        this.mongoTemplate.remove(query, BigScreenViewConfig.class);
    }
    public void save(BigScreenViewConfig bigScreenViewConfig) {
        this.mongoTemplate.save(bigScreenViewConfig);
    }
    public void insertAll(List<BigScreenViewConfig> bigScreenViewConfigs){
        mongoTemplate.insertAll(bigScreenViewConfigs);
    }
    public void dataMigration(){
        List<BigScreenViewConfig> all = systemMongoTemplate.findAll(BigScreenViewConfig.class);
        mongoTemplate.insertAll(all);
    }
}
