package com.digiwin.athena.knowledgegraph.synonym.domain.subscription;

import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionTrigger;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * @author gudahua
 * @title:
 * @projectName athena_designer
 * @description:
 * @Date
 */
@Data
@Accessors(chain = true)
@Document(collection = "agiledata_subscription")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Subscription extends MongoBaseDto{
    @Id
    private String objectId;
    private String type;//entry词条 subscription订阅
    private String tenantId;
    private String code;//词条主键 随机数 自己生成  订阅主键 订阅接口返回
    private String desc;//词条描述
    private EntryInfo question;//词条信息
    private List<DataSubscriptionTrigger> frequency;//周期 频率
    private String subsType; //byUser byRole
    private List<SubscriberInfo> subscribers;//作为词条信息时存在

    private String subscriber;//订阅用户 作为订阅信息时存在
    private String subscriberName;//订阅用户名稱 作为订阅信息时存在
}
