package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.ActivityOld;
import com.digiwin.athena.knowledgegraph.domain.ActivityData;
import com.digiwin.athena.kg.activity.Language;
import com.digiwin.athena.kg.activity.Activities;
import com.digiwin.athena.kg.activity.ActivityBaseInfoVO;
import com.digiwin.athena.kg.activity.ActivityVO;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityInputData;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface ActivityRepository extends Neo4jRepository<ActivityOld,Long> {

//    @Query("MATCH (task:Task)-[:Contains]->(activity:Activity) where task.code = $0 and activity.code = $1 " +
//        "OPTIONAL MATCH (activity)-[:TRANSLATION]->(language:Language {locale:$2}) " +
//        "OPTIONAL MATCH (activity)-[:CUSTOMIZE]->(custom:CustomizationActivity {level:'tenant',levelId:$3,type:'modify'}) " +
//        "OPTIONAL MATCH (custom)-[:TRANSLATION]->(customLanguage:Language {locale:$2}) " +
//        "return activity, language, custom, customLanguage")
//    ActivityData getByCode(String taskCode, String activityCode, String locale, String tenantId);

    @Query("MATCH (task:Task)-[:Contains]->(activity:Activity) where task.code = $0 and activity.code = $1 " +
            "return activity")
    ActivityOld getActivityByCode(String taskCode, String activityCode);

    @Query("MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 " +
            "return activity")
    ActivityOld getActivityByCodeAndVersion(String activityCode, String tenantVersion);

//    @Query("MATCH (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{version:$2,code:$1})-[:Contains]->(activity:Activity) return activity.code")
    @Query("MATCH(task:Task{version:$2,code:$1})-[:Contains]->(activity:Activity) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return activity.code")
    List<String> getActivityCodes(String tenantId, String taskCode, String tenantVersion);

    @Query("MATCH (task:Task{code:$0})-[:Contains]->(activity:Activity{code:$1})-[:TRANSLATION]->(language:Language) return language")
    List<Language> getActivityLanguageByCode(String taskCode, String activityCode);

//    @Query(value = "MATCH (t:Activity {code:$0})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
//    Optional<ActivityInputData> getActivityInputData(String activityId);

//    @Query(value = "MATCH (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$3})-[:Contains]->(t:Activity {code:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    @Query(value = "MATCH (task:Task{code:$1,version:$3})-[:Contains]->(t:Activity {code:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    Optional<ActivityInputData> getActivityInputData(String tenantId, String code, String activityId, String tenantVersion);

//    @Query(value = "MATCH (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{version:$2})-[:Contains]->(t:Activity {code:$1})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    @Query(value = "MATCH (task:Task{version:$2})-[:Contains]->(t:Activity {code:$1})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    Optional<ActivityInputData> getActivityInputData(String tenantId, String activityId, String tenantVersion);

    @Query(value = "MATCH (sp:SolvePlan)-[:TroubleShoot]->(de:DataEntity) " +
            "MATCH (sp)-[:Instance]->(aSet:ActivitySet) " +
            "WHERE sp.planId = $0 and de.name = $1 and sp.version = $2 " +
            "RETURN aSet.activities as activities")
    Activities getActivitySetByPlanId(String planId, String dataName, String tenantVersion);

    @Query("MATCH (task:Task{code:$0})-[:TRANSLATION]->(language:Language) return language")
    List<Language> getTaskLanguageByCode(String taskCode);

    @Query("MATCH (task:Task{code:$0})-[:Achieves]->(target:TaskTarget)-[:TRANSLATION]->(language:Language) return language")
    List<Language> getTargetLanguageByCode(String taskCode);


    @Query("MATCH (task:Task)-[:Contains]->(activity:CustomizationActivity {level:'tenant',levelId:$3,type:'add'}) " +
            "where task.code = $0 and activity.code = $1 " +
            "OPTIONAL MATCH (activity)-[:TRANSLATION]->(language:Language {locale:$2}) " +
            "return activity, language")
    ActivityData getAddedCustomByCode(String taskCode, String activityCode, String locale, String tenantId);

    @Query("MATCH (n:Activity) WHERE n.code in $0 and n.version = $2 and (n.tenantId in ['SYSTEM',$3] or n.tenantId is null or $3 in n.inclusionTenant)" +
            "OPTIONAL MATCH (n)-[:TRANSLATION]->(lang:Language {locale:$1}) " +
            "RETURN n.code AS activityId, n.sourceLevel as sourceLevel, n.tenantId as tenantId," +
            "CASE WHEN lang.name is null " +
            "THEN n.name " +
            "ELSE lang.name END AS activityName ")
    List<ActivityVO> getActivitySetByIds(List<String> ids, String locale, String tenantVersion, String tenantId);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:TASK]->(t:Task{version:$3}) -[:Contains]->(a:Activity) where t.code in $0 and (t.hideDeliverySetting is null or  t.hideDeliverySetting  = false) and a.category = \"APPROVAL\" " +
//    "return t.code as taskId,a.allowSubLevel as allowSubLevel,a.needEnableApprove as needEnableApprove, case when $2 = 'zh_CN' then  coalesce(t.`lang.name.zh_CN`, t.name) when $2 = 'zh_TW' then coalesce(t.`lang.name.zh_TW`, t.name) else  coalesce(t.`lang.name.en_US`, t.name) end as taskName, " +
//            "a.code as activityId, case when $2 = 'zh_CN' then  coalesce(a.`lang.name.zh_CN`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.en_US`, a.name) end as activityName, " +
//            "case when $2 = 'zh_CN' then  coalesce(a.`lang.startApproveActivityName.zh_CN`, a.startApproveActivityName) when $2 = 'zh_TW' then coalesce(a.`lang.startApproveActivityName.zh_TW`, a.startApproveActivityName) else  coalesce(a.`lang.startApproveActivityName.en_US`, a.startApproveActivityName) end as startApproveActivityName, " +
//            "case when $2 = 'zh_CN' then  coalesce(a.`lang.approvePlanDesc.zh_CN`, a.approvePlanDesc) when $2 = 'zh_TW' then coalesce(a.`lang.approvePlanDesc.zh_TW`, a.approvePlanDesc) else  coalesce(a.`lang.approvePlanDesc.en_US`, a.approvePlanDesc) end as approvePlanDesc")
@Query("match (t:Task{version:$3})-[:Contains]->(a:Activity) where t.code in $0 and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null) and (t.hideDeliverySetting is null or  t.hideDeliverySetting  = false) and a.category = \"APPROVAL\" " +
        "return t.code as taskId,a.allowSubLevel as allowSubLevel,a.needEnableApprove as needEnableApprove, case when $2 = 'zh_CN' then  coalesce(t.`lang.name.zh_CN`, t.name) when $2 = 'zh_TW' then coalesce(t.`lang.name.zh_TW`, t.name) else  coalesce(t.`lang.name.en_US`, t.name) end as taskName, " +
        "a.code as activityId, case when $2 = 'zh_CN' then  coalesce(a.`lang.name.zh_CN`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.en_US`, a.name) end as activityName, " +
        "case when $2 = 'zh_CN' then  coalesce(a.`lang.startApproveActivityName.zh_CN`, a.startApproveActivityName) when $2 = 'zh_TW' then coalesce(a.`lang.startApproveActivityName.zh_TW`, a.startApproveActivityName) else  coalesce(a.`lang.startApproveActivityName.en_US`, a.startApproveActivityName) end as startApproveActivityName, " +
        "case when $2 = 'zh_CN' then  coalesce(a.`lang.approvePlanDesc.zh_CN`, a.approvePlanDesc) when $2 = 'zh_TW' then coalesce(a.`lang.approvePlanDesc.zh_TW`, a.approvePlanDesc) else  coalesce(a.`lang.approvePlanDesc.en_US`, a.approvePlanDesc) end as approvePlanDesc")
    List<ActivityBaseInfoVO> getApproveActivityListByTaskIds(List<String> taskIdList, String tenantId, String locale, String tenantVersion);


//    @Query("match (te:TenantEntity{tenantId:$1})-[:ACTIVITY]->(a:Activity{version:$2}) where a.code in $0 and a.category = \"APPROVAL\" " +
//            "return a.code as activityId, a.version as activityVersion")
    @Query("match(a:Activity{version:$2}) where a.code in $0 and a.category = \"APPROVAL\"  and (a.tenantId in ['SYSTEM',$1] or a.tenantId is null) " +
        "return a.code as activityId, a.version as activityVersion")
    List<ActivityBaseInfoVO> getApproveActivityListByActivityIds(List<String> activityIdList, String tenantId, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:TASK]->(t:Task{version:$2}) -[:Contains]->(a:Activity) where t.code in $0 and a.executeType = \"MANUAL\" and a.category <> \"APPROVAL\" " +
//            "return t.code as taskId, a.code as activityId, a.name as activityName")
    @Query("match (t:Task{version:$2}) -[:Contains]->(a:Activity) where t.code in $0 and a.executeType = \"MANUAL\" and a.category <> \"APPROVAL\" and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null) " +
        "return t.code as taskId, a.code as activityId, a.name as activityName")
    List<ActivityBaseInfoVO> getManualActivityListByTaskIds(List<String> taskIdList, String tenantId, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$1})-[:TASK]->(t:Task{version:$3}) -[:Contains]->(a:Activity) where t.code in $0 " +
//            "return t.code as taskId, a.code as activityId,a.sequence as sequence, case when $2 = 'en_US' then  coalesce(a.`lang.name.en_US`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.zh_CN`, a.name) end as activityName order by a.sequence")
    @Query("match (t:Task{version:$3}) -[:Contains]->(a:Activity) where t.code in $0  and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null)" +
        "return t.code as taskId, a.code as activityId,a.sequence as sequence, case when $2 = 'en_US' then  coalesce(a.`lang.name.en_US`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.zh_CN`, a.name) end as activityName order by a.sequence")
    List<ActivityBaseInfoVO> getActivityListByTaskIds(List<String> taskIdList, String tenantId, String locale, String tenantVersion);
}