package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-10-10 11:30
 **/
@Repository
public interface MechanismRepository extends Neo4jRepository<MechanismOld,Long> {

//    @Query("match(te:TenantEntity{tenantId:$0})-[:MECHANISM]->(m:Mechanism{key:$1,version:$2}) return m")
    @Query("match(m:Mechanism{key:$1,version:$2})  where (m.tenantId in ['SYSTEM',$0] or m.tenantId is null) return m")
    MechanismOld findMechanism(String tenantId, String key, String tenantVersion);

    @Depth(value = -1)
    MechanismOld findOneByKeyAndVersion(String key, String version);

    @Query("match(m:Mechanism)-[:TASKFORMULA]->(t:TaskMechanismFormula) where m.key=$0 and  t.taskId=$1 return t limit 1")
    TaskMechanismConfig taskFormula(String key, String taskId);



}
