package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.SolvePlan;
import com.digiwin.athena.kg.activity.SolvePlanData;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface SolvePlanRepository extends Neo4jRepository<SolvePlan,Long> {


//    @Query("match (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2})-[:Creates]->(:TaskProblematicData)<-[:TroubleShoot]-(solvePlan:SolvePlan) return solvePlan ")
    @Query("match (task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2})-[:Creates]->(:TaskProblematicData)<-[:TroubleShoot]-(solvePlan:SolvePlan)  where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return solvePlan ")
    List<SolvePlan> getByActivity(String tenantId, String code, String activityId, String tenantVersion);

//    @Query("match (te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{version:$2})-[:Contains]->(activity:Activity{code:$1})-[:Creates]->(:TaskProblematicData)<-[:TroubleShoot]-(solvePlan:SolvePlan) return solvePlan ")
    @Query("match (task:Task{version:$2})-[:Contains]->(activity:Activity{code:$1})-[:Creates]->(:TaskProblematicData)<-[:TroubleShoot]-(solvePlan:SolvePlan)  where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return solvePlan ")
    List<SolvePlan> getByActivity(String tenantId, String activityId, String tenantVersion);

//    @Query("match (solvePlan:SolvePlan)-[:TroubleShoot]->(:TaskProblematicData)<-[:Creates]-(:Activity {code:$0}) " +
//            "OPTIONAL MATCH (solvePlan)-[:TRANSLATION]->(language:Language{locale:$1}) " +
//            "return solvePlan, language")
//    List<SolvePlanData> getByActivity(String activityId, String locale);

    @Query("match (solvePlan:SolvePlan{version:$2})-[:TroubleShoot]->(:TaskProblematicData {name:$0}) " +
            "OPTIONAL MATCH (solvePlan)-[:TRANSLATION]->(language:Language{locale:$1}) " +
            "OPTIONAL MATCH (solvePlan)-[:Instance]->(activitySet:ActivitySet) " +
            "return solvePlan, language, activitySet")
    List<SolvePlanData> getByData(String dataName, String locale, String tenantVersion);
}