package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Service;
import java.util.Map;

/**
 * 取得API映射关系
 * Path:[/restful/standard/mdc/ApiRelation/Get]
 */
@Service
public class ApiRelationGetService extends AbstractApiService {

	public ApiRelationGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.API_RELATION_GET_SCHEMA;
	}

	/**
	 *  查询映射关系信息
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		// 組成回傳訊息
		ObjectNode tDataNode = mapper.createObjectNode();
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String apiName = tRequestJsonNode.get(MdcConstant.API_NAME).asText();
		String tenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		tDataNode.put("parentApiName", getParentName(apiName, tenantId));
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
