package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.ParamFormatErrorException;
import com.digiwin.metadatacache.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 新增APP版本
 * [/restful/standard/mdc/AppSupportVersion/Add]
 */
@Service
public class AppSupportVersionAddService extends AbstractApiService {

    @Autowired
    private AppSupportVersionDao appSupportVersionDao;

    public AppSupportVersionAddService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.APP_SUPPORT_LIST_ADD_SCHEMA;
    }

    /**
     * 新增APP版本
     *
     * @param validatorResult * @param validatorResult
     * @return map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
                + ", 原始訊息: " + tRequestJsonNode);
        ArrayNode tTenantIdArr = (ArrayNode) tRequestJsonNode.get(MdcConstant.TENANT_ID);
        ArrayNode tAppVerArr = (ArrayNode) tRequestJsonNode.get(MdcConstant.APP_VER);
        for (JsonNode tTenantIdJsonNode : tTenantIdArr) {
            String tTenantId = tTenantIdJsonNode.asText();
            if (StringUtil.isEmptyOrSpace(tTenantId)) {
                throw new ParamFormatErrorException("租户Id不可为空!", this.getClass());
            }
            for (JsonNode tAppVerJsonNode : tAppVerArr) {
                String tAppId = tAppVerJsonNode.get(MdcConstant.APP_ID).asText();
                String tVersion = tAppVerJsonNode.get(MdcConstant.VERSION).asText();
                if (StringUtil.isEmptyOrSpace(tAppId)) {
                    throw new ParamFormatErrorException("appId不可为空!",this.getClass());
                }
                if (StringUtil.isEmptyOrSpace(tVersion)) {
                    throw new ParamFormatErrorException("app版本不可为空!",this.getClass());
                }
                Map<String, String> tConditions = new HashMap<>();
                tConditions.put(MdcConstant.TENANT_ID, tTenantId);
                tConditions.put(MdcConstant.APP_ID, tAppId);
                List<AppSupportVersion> tAppSupportVersionList = appSupportVersionDao.fetch(tConditions);
                if (tAppSupportVersionList == null || tAppSupportVersionList.isEmpty()) {
                    // 新增
                    AppSupportVersion tpAppSupportVersion = new AppSupportVersion();
                    tpAppSupportVersion.setTenantId(tTenantId);
                    tpAppSupportVersion.setAppId(tAppId);
                    tpAppSupportVersion.setAppVersion(tVersion);
                    appSupportVersionDao.add(tpAppSupportVersion);
                } else {
                    // 修改
                    for (AppSupportVersion tpAppSupportVersion : tAppSupportVersionList) {
                        tpAppSupportVersion.setAppVersion(tVersion);
                        appSupportVersionDao.update(tpAppSupportVersion);
                    }
                }
            }
        }
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}