package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.TenantIDNotFoundException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 *  取得支持穩態应用產品版本的租户
 *  Path:[/restful/standard/mdc/AppSupportVersion/Get]
 */
@Service
public class AppSupportVersionGetService extends AbstractApiService {
	
	@Autowired
	private AppSupportVersionDao appSupportVersionDao;
	
	public AppSupportVersionGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.APP_SUPPORT_VERSION_GET_SCHEMA;
	}

	/**
	 * 查询APP版本对应的租户信息
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException  BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tAppId = tRequestJsonNode.get(MdcConstant.APP_ID).asText();
		String tVersion = tRequestJsonNode.get(MdcConstant.VERSION).asText();
		Map<String, String> tConditions = new HashMap<>();
		tConditions.put(MdcConstant.APP_ID, tAppId);
		tConditions.put(MdcConstant.VERSION, tVersion);
		List<AppSupportVersion> tAppSupportVersionList = appSupportVersionDao.fetch(tConditions);
		// 未找到支持應用版本的租戶
		if (tAppSupportVersionList == null || tAppSupportVersionList.isEmpty()) {
			throw new TenantIDNotFoundException(getClass());
		}
		// 組成回傳訊息
		// 建立data節點
		ObjectNode tDataNode = mapper.createObjectNode();
		// 建立應用、版本陣列
		ArrayNode tVersionAryNode = mapper.createArrayNode();
		for (AppSupportVersion tAppSupportVersion : tAppSupportVersionList) {
			tVersionAryNode.add(tAppSupportVersion.getTenantId().trim());
		}
		tDataNode.set(MdcConstant.TENANT_ID, tVersionAryNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription =getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}

}
