package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.*;
import com.digiwin.metadatacache.model.*;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2025/3/26
 */

/**
 * 取得產品主機的雲地映射
 * Path:[/restful/standard/mdc/CloudMappingSetting/Update]
 */
@Service
public class CloudMappingSettingUpdateService extends AbstractApiService {

    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    @Autowired
    private ProductDao productDao;

    @Autowired
    private ServiceDao serviceDao;

    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;


    public CloudMappingSettingUpdateService () {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.CLOUD_MAPPING_SETTING_UPDATE_SCHEMA;
    }

    @Override
    protected Map<String, Object> processData (ValidatorResult validatorResult) throws Exception {
        JsonNode requestNode = validatorResult.getJsonContent();
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
                         + ", 原始訊息: " + requestNode);
        // 取出入參tenant
        String action = requestNode.get(MdcConstant.ACTION).asText();
        String eocSetting = requestNode.get(MdcConstant.EOC_SETTING).asText();
        String tenantId = requestNode.get(MdcConstant.TENANT_ID).asText();
        String prodName = requestNode.get(MdcConstant.PROD_NAME).asText();
        String uid = requestNode.get(MdcConstant.UID).asText();
        ArrayNode mappingInfoArrayNode = (ArrayNode) requestNode.get(MdcConstant.MAPPING_INFO);

        if (MdcConstant.UPDATE.equalsIgnoreCase(action)) {

            Map<String, String> queryCondition = new HashMap<>();
            queryCondition.put(MdcConstant.TENANT_ID, tenantId);
            queryCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
            queryCondition.put(MdcConstant.UID, uid);
            queryCondition.put(MdcConstant.PROD_NAME, prodName);
            List<EocIntgMapping> tMappings = eocIntgMappingDao.fetch(queryCondition);

            Map<String, EocIntgMapping> eocIntgMappingMap = tMappings.stream().collect(Collectors.toMap(
                    x -> x.getEocId().concat("_").concat(x.getIntgId()).concat("_").concat(x.getCloudMappingType()), x -> x
            ));
            mappingInfoArrayNode.forEach(mappingInfo -> {
                String key=mappingInfo.get(MdcConstant.EOC_ID).asText().concat("_").concat(mappingInfo.get(MdcConstant.INTG_ID).asText())
                        .concat("_").concat(mappingInfo.get(MdcConstant.MAPPING_TYPE).asText());
                //新增禁用的数据
                if (ObjectUtils.allNotNull(mappingInfo.get(MdcConstant.EOC_ID), mappingInfo.get(MdcConstant.INTG_ID))
                && eocIntgMappingMap.get(key)==null) {
                    EocIntgMapping eocIntgMapping = new EocIntgMapping();

                    eocIntgMapping.setEocLevel(MdcConstant.CLOUD_MAPPING_ID);
                    eocIntgMapping.setTenantId(tenantId);
                    eocIntgMapping.setProducName(prodName);
                    eocIntgMapping.setProductUid(uid);

                    eocIntgMapping.setEocId(mappingInfo.get(MdcConstant.EOC_ID).asText());
                    eocIntgMapping.setIntgId(mappingInfo.get(MdcConstant.INTG_ID).asText());
                    eocIntgMapping.setCloudMappingType(mappingInfo.get(MdcConstant.MAPPING_TYPE).asText());
                    eocIntgMapping.setBuildTime(Calendar.getInstance());

                    Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
                    tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, prodName);
                    tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, eocIntgMapping.getCloudMappingType());
                    List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao
                            .fetch(tPrdDatakeyMappingCondition);
                    if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                        eocIntgMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                    }

                    eocIntgMappingDao.save(eocIntgMapping);
                }
            });

            // 用UID找出所有符合的產品
            Map<String, String> tProductCondition = new HashMap<>();
            tProductCondition.put(MdcConstant.UID, uid);
            List<Product> tProducts = productDao.fetch(tProductCondition);

            if(CollectionUtils.isNotEmpty(tProducts)){
                //存在租户的产品
                Map<String, Product> productMap = tProducts.stream()
                                                           .filter(x-> StringUtils.isNotBlank(x.getTenantId()))
                                                           .collect(Collectors.toMap(Product::getTenantId, x -> x));
                //存在该租户的产品
                if(Objects.nonNull(productMap.get(tenantId))){
                    Product product = productMap.get(tenantId);
                    if (eocSetting != null) {
                        product.setEocSetting(eocSetting);
                    }
                    product.setLastUpdateTime(Calendar.getInstance());
                    productDao.save(product);
                }else {
                    //eaiUid key maps by tenantId is null
                    Map<String, Product> productMapByTenantIdIsNull = tProducts.stream()
                            .filter(x-> StringUtils.isBlank(x.getTenantId()))
                            .collect(Collectors.toMap(Product::getEaiUid, x -> x));

                    //不存在查询对应的tenantId
                    Map<String, String> tCondition = new HashMap<>();
                    tCondition.put(MdcConstant.TENANT, tenantId);
                    List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);

                    //无租户的产品和当前租户的eaiUid存在相同设定该租户
                    if(CollectionUtils.isNotEmpty(eaiTenantMappings) &&
                            Objects.nonNull(productMapByTenantIdIsNull.get(eaiTenantMappings.get(0).getEaUid()))){
                        Product product = productMapByTenantIdIsNull.get(eaiTenantMappings.get(0).getEaUid());
                        if (eocSetting != null) {
                            product.setEocSetting(eocSetting);
                        }
                        product.setTenantId(tenantId);
                        product.setLastUpdateTime(Calendar.getInstance());
                        productDao.save(product);
                    }else {
                        //eaiUid key maps
                        Map<String, Product> productMapByEaiUid = tProducts.stream().collect(Collectors.toMap(Product::getEaiUid, x -> x));
                        //存在有租户的产品并且和当前租户的eaiUid一致
                        if(CollectionUtils.isNotEmpty(eaiTenantMappings) &&
                                Objects.nonNull(productMapByEaiUid.get(eaiTenantMappings.get(0).getEaUid()))){
                            Product product = productMapByEaiUid.get(eaiTenantMappings.get(0).getEaUid());
                            List<com.digiwin.metadatacache.model.Service> tServices = serviceDao.getByPrdId(product.getId());

                            // 設定租戶ID、清空主鍵、儲存
                            if (eocSetting != null) {
                                product.setEocSetting(eocSetting);
                            }
                            product.setBuildTime(Calendar.getInstance());
                            product.setTenantId(tenantId);
                            product.setId(null);
                            Product tReturnedProduct = productDao.save(product);
                            // 設定服務清單
                            for (com.digiwin.metadatacache.model.Service service : tServices) {
                                service.setProduct(tReturnedProduct);
                                service.setId(null);
                                serviceDao.save(service);
                            }
                        }
                    }
                }
            }

        }else if (MdcConstant.DELETE.equalsIgnoreCase(action)) {
            mappingInfoArrayNode.forEach(mappingInfo -> {

                String eocId = mappingInfo.get(MdcConstant.EOC_ID).asText();
                String intGId = mappingInfo.get(MdcConstant.INTG_ID).asText();
                String type = mappingInfo.get(MdcConstant.MAPPING_TYPE).asText();
                String level = mappingInfo.get(MdcConstant.LEVEL).asText();
                // 刪除該工廠層級運營配置
                eocIntgMappingDao.deleteCloudMapping(tenantId, level, type , uid, prodName, eocId, intGId);
            });


            // 用租戶ID和產品UID找出綁定的產品主機
            Map<String, String> tCondition = new HashMap<>();
            tCondition.put(MdcConstant.TENANT, tenantId);
            if (uid != null && !StringUtil.isEmptyOrSpace(uid)) {
                tCondition.put(MdcConstant.UID, uid);
            }
            List<Product> tProducts = productDao.fetch(tCondition);
            // 取得該租戶該產品主機的運營資料
            Map<String, String> tMappingCondition = new HashMap<>();
            tMappingCondition.put(MdcConstant.PRODUCT_UID, uid);
            tMappingCondition.put(MdcConstant.TENANT_ID, tenantId);
            tMappingCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
            List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tMappingCondition);
            // 如果該租戶已經沒有該產品主機的運營資料，則將該產品主機的tenant_id設為空字串
            if (CollectionUtils.isNotEmpty(tProducts) && tEocIntgMappings.isEmpty()) {
                tProducts.get(0).setTenantId("");
                productDao.save(tProducts.get(0));
            }
        }
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return converJsonNodeToMap(tResponseJsonNode);
    }

}
