package com.digiwin.metadatacache.apiservice;

import java.util.Map;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得租戶的EOC清單
 * Path:[/restful/standard/mdc/EOCInfo/Get]
 */
@org.springframework.stereotype.Service
public class EocInfoGetService extends AbstractApiService {

	public EocInfoGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.EOC_INFO_GET_SCHEMA;
	}

	/**
	 * 查询当前请求用的默认运营单元配置信息
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		Object tToken = DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN);
		// 根據租戶ID取得EOC運營單元碼
		ObjectNode tEocInfoNode;
		if (null != tToken) {
			tEocInfoNode = EocInfoServiceUtil.getEocInfoByUserToken(tToken.toString());
		} else {
			tEocInfoNode = EocInfoServiceUtil.getEocInfoByTenantId(tTenantId);
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tEocInfoNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}

	@Override
	protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pEocInfoNode) {
		ObjectNode tResponseJsonNode = mapper.createObjectNode();
		ObjectNode tExecutionNode = mapper.createObjectNode();
		tResponseJsonNode.set(MdcConstant.EXECUTION, tExecutionNode);
		tExecutionNode.put(MdcConstant.CODE, pCode);
		if (!StringUtil.isEmptyOrSpace(pDescription)) {
			tExecutionNode.put(MdcConstant.DESCRIPTION, pDescription);
		}
		if (pEocInfoNode != null) {
			tResponseJsonNode.set(MdcConstant.EOC_INFO, pEocInfoNode);
		}
		return tResponseJsonNode;
	}
}