package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Map;

/**
 * 取得租戶的EOC清單V2(雲地映射)
 * Path:[/restful/standard/mdc//EOCInfoV2/Get]
 */
@org.springframework.stereotype.Service
public class EocInfoV2GetService extends AbstractApiService {

	public EocInfoV2GetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.EOC_INFO_V2_GET_SCHEMA;
	}

	/**
	 * 查询当前请求用的默认运营单元配置信息
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		Object tToken = DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN);
		// 根據租戶ID取得EOC運營單元碼
		ObjectNode tEocInfoNode;
		if (null != tToken) {
			tEocInfoNode = EocInfoServiceUtil.getEocInfoV2ByUserToken(tToken.toString());
		} else {
			tEocInfoNode = EocInfoServiceUtil.getEocInfoV2ByTenantId(tTenantId);
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tEocInfoNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}

	@Override
	protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pEocInfoNode) {
		ObjectNode tResponseJsonNode = mapper.createObjectNode();
		ObjectNode tExecutionNode = mapper.createObjectNode();
		tResponseJsonNode.set(MdcConstant.EXECUTION, tExecutionNode);
		tExecutionNode.put(MdcConstant.CODE, pCode);
		if (!StringUtil.isEmptyOrSpace(pDescription)) {
			tExecutionNode.put(MdcConstant.DESCRIPTION, pDescription);
		}
		if (pEocInfoNode != null) {
			ObjectNode eocInfoResult = mapper.createObjectNode();
			ObjectNode dataResult = mapper.createObjectNode();
			ArrayNode operations = mapper.createArrayNode();
			JsonNode data = pEocInfoNode.get("data");
			if (data != null) {
				JsonNode listNode = data.get("list");
				if (listNode instanceof ArrayNode) {
					ArrayNode list = (ArrayNode) listNode;
					list.forEach(x->{
						if (x.hasNonNull("id") && x.hasNonNull("name")) {
							operations.add(mapper.createObjectNode()
									.put(MdcConstant.ID, x.get("id").asText())
									.put(MdcConstant.NAME, x.get("name").asText()));
						}
					});
				}

				dataResult.set(MdcConstant.OPERATIONS, operations);
				eocInfoResult.put(MdcConstant.CODE,pEocInfoNode.get("code").asText());
				eocInfoResult.put(MdcConstant.MESSAGE,pEocInfoNode.get("message").asText());
				eocInfoResult.set(MdcConstant.DATA,dataResult);
			}
			tResponseJsonNode.set(MdcConstant.EOC_INFO, eocInfoResult);
		}
		return tResponseJsonNode;
	}
}