package com.digiwin.metadatacache.apiservice;

import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得集成代碼清單(取得穩態產品om清單)
 * Path:[/restful/standard/mdc/IntgInfo/Get]
 */
@org.springframework.stereotype.Service
public class IntgInfoGetService extends AbstractApiService {

	public IntgInfoGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.INTG_INFO_GET_SCHEMA;
	}

	/**
	 * 获取集成代码清单
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		String tEntId = null;
		if (tRequestJsonNode.get(MdcConstant.ENT_ID) != null) {
			tEntId = tRequestJsonNode.get(MdcConstant.ENT_ID).asText();
		}
		String tProdName = tRequestJsonNode.get(MdcConstant.PROD_NAME).asText();
		String tUid = tRequestJsonNode.get(MdcConstant.UID).asText();
		// 根據tProdName, tUid呼叫ESP->ERP取得集成代碼
		JsonNode tIntgNode = IntgInfoServiceUtil.getIntgInfo(tEntId, tTenantId, tProdName, tUid);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription =getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tIntgNode);
		return converJsonNodeToMap(tResponseJsonNode);

	}

	@Override
	protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pIntgInfoNode) {
		ObjectNode tResponseJsonNode = mapper.createObjectNode();
		ObjectNode tExecutionNode = mapper.createObjectNode();
		tResponseJsonNode.set(MdcConstant.EXECUTION, tExecutionNode);
		tExecutionNode.put(MdcConstant.CODE, pCode);
		if (!StringUtil.isEmptyOrSpace(pDescription)) {
			tExecutionNode.put(MdcConstant.DESCRIPTION, pDescription);
		}
		if (pIntgInfoNode != null) {
			tResponseJsonNode.set(MdcConstant.INTG_INFO, pIntgInfoNode);
		}
		return tResponseJsonNode;
	}
}