package com.digiwin.metadatacache.apiservice;

import java.util.*;
import java.util.stream.Collectors;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.exception.*;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.Service;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 启用运营单元配置
 * Path:[/restful/standard/mdc/OperationManageSetting/Update]
 */
@org.springframework.stereotype.Service
public class OperationManageSettingUpdateService extends AbstractApiService {

	@Autowired
	private ProductDao productDao;

	@Autowired
	private ServiceDao serviceDao;

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	@Autowired
	private EaiTenantMappingDao eaiTenantMappingDao;

	@Autowired
	private PrdDatakeyMappingDao prdDatakeyMappingDao;

	public OperationManageSettingUpdateService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.OPERATION_MANAGE_SETTING_UPDATE_SCHEMA;
	}

	/**
	 * 启用运营单元配置
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		updateOperationManageSetting(tRequestJsonNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJson = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		return converJsonNodeToMap(tResponseJson);
	}

	/** 新增or刪除運營配置 **/
	private List<EocIntgMapping> updateOperationManageSetting(JsonNode pRequestJson) throws Exception {
		// 要更新的清單
		List<EocIntgMapping> tListToUpdate = new ArrayList<>();
		// 提交新增or更新的配置-->tMappingInfoAryNode
		ArrayNode tMappingArray = (ArrayNode) pRequestJson.get(MdcConstant.MAPPING_INFO);
		String tToken = DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN).toString();
		String tAction = pRequestJson.get(MdcConstant.ACTION).asText();
		String tTenantId = pRequestJson.get(MdcConstant.TENANT_ID).asText();
		String tUid = null;
		String tEocSettingType = null;
		String tRegionEocSettingType = null;
		String eaiUid = null;
		List<JsonNode> tSubmitCompanyList = new ArrayList<>();
		List<JsonNode> tSubmitSiteList = new ArrayList<>();
		ArrayNode tEocCompanyAry = mapper.createArrayNode();
		ArrayNode tEocFactoriesAry = mapper.createArrayNode();
		// 暫時不處理場域層級運營單元
		if (tMappingArray != null && tMappingArray.size() != 0) {
			// 取得雲控制台的eoc運營單元清單
			JsonNode tEocList = EocInfoServiceUtil.getEocInfoByUserToken(tToken);
			ObjectNode tEocData = (ObjectNode) tEocList.get(MdcConstant.DATA);
			// 公司層級eoc
			tEocCompanyAry = (ArrayNode) tEocData.get(MdcConstant.COMPANIES);
			// 工廠層級eoc
			tEocFactoriesAry = (ArrayNode) tEocData.get(MdcConstant.FACTORIES);
			// 將提交的配置做層級分組
			for (JsonNode tMappingNode : tMappingArray) {
				if (tMappingNode.get(MdcConstant.LEVEL).asText().equals(MdcConstant.COMPANY_ID)) {
					tSubmitCompanyList.add(tMappingNode);
				} else if (tMappingNode.get(MdcConstant.LEVEL).asText().equals(MdcConstant.SITE_ID)) {
					tSubmitSiteList.add(tMappingNode);
				}
			}
		}
		// 有eoc_setting
		if (pRequestJson.get(MdcConstant.EOC_SETTING) != null && pRequestJson.get(MdcConstant.EOC_SETTING).asText().length() != 0) {
			tEocSettingType = pRequestJson.get(MdcConstant.EOC_SETTING).asText();
		}
		// 有eoc_setting_region
		if (pRequestJson.get(MdcConstant.EOC_SETTING_REGION) != null
				&& pRequestJson.get(MdcConstant.EOC_SETTING_REGION).asText().length() != 0) {
			tRegionEocSettingType = pRequestJson.get(MdcConstant.EOC_SETTING_REGION).asText();
		}
		// 有eai_uid
		if (pRequestJson.get(MdcConstant.EAI_UID) != null
				&& pRequestJson.get(MdcConstant.EAI_UID).asText().length() != 0) {
			eaiUid = pRequestJson.get(MdcConstant.EAI_UID).asText();
		}
		// 刪除運營配置
		if (tAction.equals(MdcConstant.DISABLE)) {
			// 逐RequestJson的每個mapping
			for (JsonNode tMappingNode : tMappingArray) {
				// 層級
				String tLevel = tMappingNode.get(MdcConstant.LEVEL).asText();
				// 產品uid
				tUid = tMappingNode.get(MdcConstant.UID).asText();
				// 產品名稱
				String tProdName = tMappingNode.get(MdcConstant.PROD_NAME).asText();
				// eoc id
				String tEocId = tMappingNode.get(MdcConstant.EOC_ID).asText();
				// om id
				String tOmId = tMappingNode.get(MdcConstant.INTG_ID).asText();
				// mapping是公司層級
				if (tLevel.equals(MdcConstant.COMPANY_ID)) {
					// 找出資料庫中符合的公司層級運營配置
					Map<String, String> tCondition = new HashMap<>();
					tCondition.put(MdcConstant.TENANT_ID, tTenantId);
					tCondition.put(MdcConstant.EOC_LEVEL, tLevel);
					tCondition.put(MdcConstant.UID, tUid);
					tCondition.put(MdcConstant.PROD_NAME, tProdName);
					tCondition.put(MdcConstant.EOC_ID, tEocId);
					tCondition.put(MdcConstant.INTG_ID, tOmId);
					List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(tCondition);
					boolean deleteEoc = false;
					// 資料庫中存在符合的公司層級運營配置
					if (eocIntgMappings != null && !eocIntgMappings.isEmpty()) {
						// 逐每個公司層級eoc單元
						for (JsonNode tEocCompanyNode : tEocCompanyAry) {
							// 比對兩個集合，如果兩者id吻合則必須刪除雲控制台eoc
							if (tEocCompanyNode.get(MdcConstant.ID).asText().equals(eocIntgMappings.get(0).getEocId())) {
								deleteEoc = true;
								// 先確認該公司沒有被其他產品主機配置
								Map<String, String> tEocMappingCondition = new HashMap<>();
								tEocMappingCondition.put(MdcConstant.EOC_LEVEL, tLevel);
								tEocMappingCondition.put(MdcConstant.TENANT_ID, tTenantId);
								tEocMappingCondition.put(MdcConstant.EOC_ID, tEocId);
								List<EocIntgMapping> tEocCompanyAlreadySetList = eocIntgMappingDao
										.fetch(tEocMappingCondition);
								List<EocIntgMapping> tTargetEocIntgMapping = new ArrayList<>();
								for (EocIntgMapping mapping : tEocCompanyAlreadySetList) {
									if (mapping.getProductName().equals(tProdName)
											&& mapping.getProductUid().equals(tUid)) {
										tTargetEocIntgMapping.add(mapping);
									}
								}
								tEocCompanyAlreadySetList.removeAll(tTargetEocIntgMapping);
								// 如果該公司有被其他產品主機配置則結束，不繼續執行刪除雲控制台eoc
								// 如果該公司沒有被其他產品主機配置則將雲控制台其底下的工廠層級eoc先刪除，再刪除公司層級eoc
								eocIntgMappingDao.deleteChildMapping(eocIntgMappings.get(0).getId());
								eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
								break;
							}
						}
						if (!deleteEoc) {
							// 刪除該公司層級運營配置底下的工廠層級運營配置
							eocIntgMappingDao.deleteChildMapping(eocIntgMappings.get(0).getId());
							// 刪除該公司層級運營配置
							eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
						}
						// 檢查如果該租戶, 產品, 產品UID沒有任何其他公司工廠層級運營配置，則同時刪除其集團配置
						clearEnterPriseSetting(tTenantId, tProdName, tUid);
						// 檢查如果該租戶, 產品, 產品UID沒有任何其他公司工廠層級運營配置，則同時刪除其場域配置
						clearRegionSetting(tTenantId, tProdName, tUid);
					}
					// mapping非公司層級(工廠)
				} else if (tLevel.equals(MdcConstant.SITE_ID)) {
					// 逐每個工廠層級eoc單元
					for (JsonNode tEocSiteNode : tEocFactoriesAry) {
						// 比對兩個集合，如果兩者id吻合則必須刪除雲控制台eoc
						if (tEocSiteNode.get(MdcConstant.ID).asText().equals(tEocId) && tEocSiteNode.get(MdcConstant.COMPANYID) != null
								&& tEocSiteNode.get(MdcConstant.COMPANYID).asText()
										.equals(tMappingNode.get(MdcConstant.PARENT_EOC_ID).asText())) {
							// 要刪除的話，要再確認該eoc沒有被其他產品配置到
							// Q:如何找出有配置該eoc的紀錄?
							// A:先確認層級，在確認租戶，在確認eoc_id
							Map<String, String> tEocMappingCondition = new HashMap<>();
							tEocMappingCondition.put(MdcConstant.EOC_LEVEL, tLevel);
							tEocMappingCondition.put(MdcConstant.TENANT_ID, tTenantId);
							tEocMappingCondition.put(MdcConstant.EOC_ID, tEocId);
							List<EocIntgMapping> tEocAlreadySetList = eocIntgMappingDao.fetch(tEocMappingCondition);
							List<EocIntgMapping> tTargetEocIntgMapping = new ArrayList<>();
							for (EocIntgMapping mapping : tEocAlreadySetList) {
								if (mapping.getProductName().equals(tProdName)
										&& mapping.getProductUid().equals(tUid)) {
									tTargetEocIntgMapping.add(mapping);
								}
							}
							tEocAlreadySetList.removeAll(tTargetEocIntgMapping);
						}
					}
					// 刪除該工廠層級運營配置
					eocIntgMappingDao.deleteMapping(tTenantId, tLevel, tUid, tProdName, tEocId, tOmId);
					// 檢查其所屬公司層級底下是否還有其他工廠
					Map<String, String> tCondition = new HashMap<>();
					tCondition.put(MdcConstant.TENANT_ID, tTenantId);
					tCondition.put(MdcConstant.EOC_LEVEL, tMappingNode.get(MdcConstant.PARENT_LEVEL).asText());
					tCondition.put(MdcConstant.UID, tUid);
					tCondition.put(MdcConstant.PROD_NAME, tProdName);
					tCondition.put(MdcConstant.EOC_ID, tMappingNode.get(MdcConstant.PARENT_EOC_ID).asText());
					List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(tCondition);
					if (eocIntgMappings != null && eocIntgMappings.size() != 0) {
						List<EocIntgMapping> childMappings = eocIntgMappingDao
								.getChildMapping(eocIntgMappings.get(0).getId());
						// 所屬公司層級運營配置底下無任何工廠配置
						if (childMappings == null || childMappings.size() == 0) {
							// 刪除該公司層級運營配置
							eocIntgMappingDao.remove(eocIntgMappings.get(0).getId());
						}
					}
					// 檢查如果該租戶, 產品, 產品UID沒有任何其他公司工廠層級運營配置，則同時刪除其集團配置
					clearEnterPriseSetting(tTenantId, tProdName, tUid);
				}
			}
			// 用租戶ID和產品UID找出綁定的產品主機
			Map<String, String> tCondition = new HashMap<>();
			tCondition.put(MdcConstant.TENANT, tTenantId);
			if (tUid != null && !StringUtil.isEmptyOrSpace(tUid)) {
				tCondition.put(MdcConstant.UID, tUid);
			}
			List<Product> tProducts = productDao.fetch(tCondition);
			// 取得該租戶該產品主機的運營資料
			Map<String, String> tMappingCondition = new HashMap<>();
			tMappingCondition.put(MdcConstant.PRODUCT_UID, tUid);
			tMappingCondition.put(MdcConstant.TENANT_ID, tTenantId);
			List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tMappingCondition);
			// 如果該租戶已經沒有該產品主機的運營資料，則將該產品主機的tenant_id設為空字串
			if (CollectionUtils.isNotEmpty(tProducts) && tEocIntgMappings.size() == 0) {
				tProducts.get(0).setTenantId("");
				productDao.save(tProducts.get(0));
			}
			if (!StringUtil.isEmpty(tTenantId)) {
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + tTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + tTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
				String tenantProductMappingKey  = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + tTenantId;
				Map<String, List<String>> tProductServiceMapFromCache = (Map<String, List<String>>) cacheService.get(tenantProductMappingKey);
				if (CollectionUtils.isNotEmpty(tProducts)) {
					String tProductKey = tProducts.get(0).getName()
							+ MdcSymbolConstant.COLON + tProducts.get(0).getUid()
							+ MdcSymbolConstant.COLON + tProducts.get(0).getEaiUid();
					if (tProductServiceMapFromCache != null) {
						tProductServiceMapFromCache.remove(tProductKey);
						cacheService.set(tenantProductMappingKey, tProductServiceMapFromCache);
						log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(清除產品)：" + "key = " + tenantProductMappingKey);
						log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(清除產品)：" + "tenant = "
								+ tTenantId + ", product = " + tProductKey);
					}
				}
			}
		} else if (tAction.equals(MdcConstant.ENABLE)) {
			// 判定当前租户是否有配置其他地中台运营配置
			if (null != eaiUid) {
				Map<String, String> pCondition = new HashMap<>();
				pCondition.put(MdcConstant.TENANT, tTenantId);
				List<Product> products = productDao.fetch(pCondition);
				if (CollectionUtils.isNotEmpty(products)) {
					String finalEaiUid = eaiUid;
					products = products.stream().filter(x-> !finalEaiUid.equals(x.getEaiUid())).collect(Collectors.toList());
				    if (CollectionUtils.isNotEmpty(products)) {
                        throw new TenantIdRelationAlreadyExistsException(getClass());
					}
				}
			}
            // 新增or更新運營配置
			if (null != tMappingArray && tMappingArray.isArray()) {
				// 逐request body中的mapping檢查
				for (JsonNode tMappingInfoNode : tMappingArray) {
					// 先把沒有階層關係(公司層級)的存起來
					if ((tMappingInfoNode.get(MdcConstant.PARENT_EOC_ID) == null
							|| tMappingInfoNode.get(MdcConstant.PARENT_EOC_ID).asText().length() == 0)) {
						EocIntgMapping tMapping = new EocIntgMapping();
						// 沒有eoc_id element則不新增該筆運營
						if (tMappingInfoNode.get(MdcConstant.EOC_ID) == null) {
							continue;
						} else {
							tMapping.setEocId(tMappingInfoNode.get(MdcConstant.EOC_ID).asText());
						}
						tMapping.setIntgId(tMappingInfoNode.get(MdcConstant.INTG_ID).asText());
						tMapping.setEocName(tMappingInfoNode.get(MdcConstant.EOC_NAME).asText());
						tMapping.setIntgName(tMappingInfoNode.get(MdcConstant.INTG_NAME).asText());
						tMapping.setEocLevel(tMappingInfoNode.get(MdcConstant.LEVEL).asText());
						tMapping.setProducName(tMappingInfoNode.get(MdcConstant.PROD_NAME).asText());
						tMapping.setProductUid(tMappingInfoNode.get(MdcConstant.UID).asText());
						tMapping.setTenantId(tTenantId);
						if (tMappingInfoNode.get(MdcConstant.REGION_TYPE) != null) {
							tMapping.setRegionType(tMappingInfoNode.get(MdcConstant.REGION_TYPE).asText());
						}
						Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
						tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, tMappingInfoNode.get(MdcConstant.PROD_NAME).asText());
						tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, tMappingInfoNode.get(MdcConstant.LEVEL).asText());
						List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao
								.fetch(tPrdDatakeyMappingCondition);
						if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
							tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
						}
						tMapping.setBuildTime(Calendar.getInstance());
						tListToUpdate.add(tMapping);
					}
				}
			}
			// 已經存在的配置要從更新清單剃除
			List<EocIntgMapping> tRemoveList = new ArrayList<>();
			for (EocIntgMapping eocIntgMapping : tListToUpdate) {
				Map<String, String> tCondition = new HashMap<>();
				tCondition.put(MdcConstant.TENANT_ID, tTenantId);
				tCondition.put(MdcConstant.EOC_LEVEL, eocIntgMapping.getEocLevel());
				tCondition.put(MdcConstant.UID, eocIntgMapping.getProductUid());
				tCondition.put(MdcConstant.PROD_NAME, eocIntgMapping.getProducName());
				tCondition.put(MdcConstant.EOC_ID, eocIntgMapping.getEocId());
				tCondition.put(MdcConstant.INTG_ID, eocIntgMapping.getIntgId());
				List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(tCondition);
				// 如果資料已經存在就略過
				if (eocIntgMappings != null && !eocIntgMappings.isEmpty()) {
					tRemoveList.add(eocIntgMapping);
				}
			}
			tListToUpdate.removeAll(tRemoveList);
			eocIntgMappingDao.updateList(tListToUpdate);
			tListToUpdate.clear();
			// 建立階層關係
			for (JsonNode tNode : tMappingArray) {
				if (tNode.get(MdcConstant.PARENT_EOC_ID) != null && tNode.get(MdcConstant.PARENT_EOC_ID).asText().length() != 0
						&& tNode.get(MdcConstant.PARENT_LEVEL) != null && tNode.get(MdcConstant.PARENT_LEVEL).asText().length() != 0) {
					Map<String, String> tEocIntgMappingCondition = new HashMap<>();
					tEocIntgMappingCondition.put(MdcConstant.EOC_ID, tNode.get(MdcConstant.PARENT_EOC_ID).asText());
					tEocIntgMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.PARENT_LEVEL).asText());
					tEocIntgMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
					tEocIntgMappingCondition.put(MdcConstant.TENANT_ID, tTenantId);
					List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tEocIntgMappingCondition);
					EocIntgMapping tMapping = new EocIntgMapping();
					tMapping.setEocId(tNode.get(MdcConstant.EOC_ID).asText());
					tMapping.setEocName(tNode.get(MdcConstant.EOC_NAME).asText());
					tMapping.setIntgId(tNode.get(MdcConstant.INTG_ID).asText());
					tMapping.setIntgName(tNode.get(MdcConstant.INTG_NAME).asText());
					tMapping.setEocLevel(tNode.get(MdcConstant.LEVEL).asText());
					tMapping.setProducName(tNode.get(MdcConstant.PROD_NAME).asText());
					tMapping.setProductUid(tNode.get(MdcConstant.UID).asText());
					tMapping.setTenantId(tTenantId);
					if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
						tMapping.setEocIntgMapping(tEocIntgMappings.get(0));
					}
					Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
					tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
					tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.LEVEL).asText());
					List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
					if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
						tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
					}
					tMapping.setBuildTime(Calendar.getInstance());
					tListToUpdate.add(tMapping);
				}
			}
			tRemoveList.clear();
			for (EocIntgMapping eocIntgMapping : tListToUpdate) {
				Map<String, String> tCondition = new HashMap<>();
				tCondition.put(MdcConstant.TENANT_ID, tTenantId);
				tCondition.put(MdcConstant.EOC_LEVEL, eocIntgMapping.getEocLevel());
				tCondition.put(MdcConstant.UID, eocIntgMapping.getProductUid());
				tCondition.put(MdcConstant.PROD_NAME, eocIntgMapping.getProducName());
				tCondition.put(MdcConstant.EOC_ID, eocIntgMapping.getEocId());
				tCondition.put(MdcConstant.INTG_ID, eocIntgMapping.getIntgId());
				List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(tCondition);
				// 如果資料已經存在就略過
				if (eocIntgMappings != null && !eocIntgMappings.isEmpty()) {
					for (EocIntgMapping mapping : eocIntgMappings) {
						if (mapping.getEocIntgMapping().getEocId()
								.equals(eocIntgMapping.getEocIntgMapping().getEocId())) {
							tRemoveList.add(eocIntgMapping);
						}
					}
				}
			}
			tListToUpdate.removeAll(tRemoveList);
			// 再處理有階層關係的eoc_intg_mapping資料
			eocIntgMappingDao.updateList(tListToUpdate);
			// 用UID找出所有符合的產品
			Map<String, String> tProductCondition = new HashMap<>();
			tProductCondition.put(MdcConstant.UID, tMappingArray.get(0).get(MdcConstant.UID).asText());
			List<Product> tProducts = productDao.fetch(tProductCondition);
			boolean tProductWithSameTenantIdExist = false;
			boolean tProductWithNoTenantIdExist = false;
			for (Product tProduct : tProducts) {
				// 存在相同租戶ID的產品
				if (tTenantId.equals(tProduct.getTenantId())) {
					if (tEocSettingType != null) {
						tProduct.setEocSetting(tEocSettingType);
					}
					if (tRegionEocSettingType != null) {
						tProduct.setEocSettingRegion(tRegionEocSettingType);
					}
					tProduct.setLastUpdateTime(Calendar.getInstance());
					productDao.save(tProduct);
					tProductWithSameTenantIdExist = true;
				}
			}
			// 不存在相同租戶ID的產品
			if (!tProductWithSameTenantIdExist) {
				for (Product tProduct : tProducts) {
					if (tProduct.getTenantId() == null || tProduct.getTenantId().length() == 0) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						// 要檢查是否相同eai uid
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							// 存在無租戶ID的產品，則設定租戶ID、儲存
							if (tEocSettingType != null) {
								tProduct.setEocSetting(tEocSettingType);
							}
							if (tRegionEocSettingType != null) {
								tProduct.setEocSettingRegion(tRegionEocSettingType);
							}
							tProduct.setTenantId(tTenantId);
							tProduct.setLastUpdateTime(Calendar.getInstance());
							productDao.save(tProduct);
							tProductWithNoTenantIdExist = true;
							break;
						}
					}
				}
				// 不存在無租戶ID的產品
				if (!tProductWithNoTenantIdExist) {
					// 複製其中一筆產品的資訊和服務清單
					for (Product tProduct : tProducts) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							List<Service> tServices = serviceDao.getByPrdId(tProduct.getId());
							// 設定租戶ID、清空主鍵、儲存
							if (tEocSettingType != null) {
								tProduct.setEocSetting(tEocSettingType);
							}
							if (tRegionEocSettingType != null) {
								tProduct.setEocSettingRegion(tRegionEocSettingType);
							}
							tProduct.setBuildTime(Calendar.getInstance());
							tProduct.setTenantId(tTenantId);
							tProduct.setId(null);
							Product tReturnedProduct = productDao.save(tProduct);
							// 設定服務清單
							for (Service service : tServices) {
								service.setProduct(tReturnedProduct);
								service.setId(null);
								serviceDao.save(service);
							}
							break;
						}
					}
				}
			}
			if (!StringUtil.isEmpty(tTenantId)) {
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.COLON + tTenantId + MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.COLON + tTenantId+ MdcSymbolConstant.ASTERISK_SYMBOL);
				cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
				String tenantProductMappingKey  = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.COLON + tTenantId;
				Map<String, List<String>> tProductServiceMapFromCache = (Map<String, List<String>>) cacheService.get(tenantProductMappingKey);
				String tProductKey = tProducts.get(0).getName()
						+ MdcSymbolConstant.COLON + tProducts.get(0).getUid()
						+ MdcSymbolConstant.COLON + tProducts.get(0).getEaiUid();
				if (tProductServiceMapFromCache != null) {
					tProductServiceMapFromCache.remove(tProductKey);
					cacheService.set(tenantProductMappingKey, tProductServiceMapFromCache);
					log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(清除產品)：" + "key = " + tenantProductMappingKey);
					log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "清除快取(清除產品)：" + "tenant = "
							+ tTenantId + ", product = " + tProductKey);
				}
			}
			if (tMappingArray.size() != 0) {
				// 逐每個提交啟用的公司層級運營配置
				for (JsonNode tNode : tSubmitCompanyList) {
					boolean companyExist = false;
					// 逐每個雲控制台EOC公司層級運營單元
					for (JsonNode tEocCompanyNode : tEocCompanyAry) {
						// 逐一比對兩個集合的公司層級單元，如果兩者有吻合則eoc存在不用執行新增雲控制台eoc的動作
						if (tEocCompanyNode.get(MdcConstant.ID).asText().equals(tNode.get(MdcConstant.EOC_ID).asText())) {
							companyExist = true;
							break;
						}
					}
					// 沒有吻合則要新增雲控制台eoc運營單元
					if (!companyExist) {
						// 新增雲控制台eoc運營單元
						// 如果要新增公司層級單元，要提供parentsid，公司的parentsid就是集團，所以要獲取集團的sid
						// 获取集团信息->/api/eoc/v2/corp/simple(method：GET)
						String tParentEnterpriseSid = EocInfoServiceUtil.getEnterPriseSid(tToken);
						// 執行新增雲控制台eoc運營單元
						EocInfoServiceUtil.updateEocEntry("", tNode.get(MdcConstant.EOC_ID).asText(), tToken, 2, 2, tParentEnterpriseSid, 0);
					}
				}
				// 逐每個提交啟用的工廠層級運營配置
				for (JsonNode tSiteNode : tSubmitSiteList) {
					boolean siteExist = false;
					// 逐一比對兩個集合的工廠層級單元，，如果兩者有吻合則eoc存在不用執行新增雲控制台eoc的動作
					for (JsonNode tEocSiteNode : tEocFactoriesAry) {
						if (tEocSiteNode.get(MdcConstant.ID).asText().equals(tSiteNode.get(MdcConstant.EOC_ID).asText())
								&& tEocSiteNode.get(MdcConstant.COMPANYID) != null
								&& tEocSiteNode.get(MdcConstant.COMPANYID).asText().equals(tSiteNode.get(MdcConstant.PARENT_EOC_ID).asText())) {
							siteExist = true;
							break;
						}
					}
					// 沒有吻合則要新增雲控制台eoc運營單元
					if (!siteExist) {
						// 如果要新增工廠，要提供parentsid，工廠的parentsid就是公司，所以要獲取公司的sid
						// 公司别列表查询(内含工厂)[分页]->/api/eoc/v2/corp/company(method：GET)
						String tCompanySid = EocInfoServiceUtil.getCompanySid(tToken, tSiteNode.get(MdcConstant.PARENT_EOC_ID).asText());
						EocInfoServiceUtil.updateEocEntry("", tSiteNode.get(MdcConstant.EOC_ID).asText(), tToken, 3, 3, tCompanySid, 0);
					}
				}
			}
		}
		return tListToUpdate;
	}

	private void clearEnterPriseSetting(String pTenantId, String pProdName, String pUid) {
		Map<String, String> tCondition = new HashMap<>();
		tCondition.put(MdcConstant.TENANT_ID, pTenantId);
		tCondition.put(MdcConstant.PROD_NAME, pProdName);
		tCondition.put(MdcConstant.UID, pUid);
		boolean tRestCompanyOrSite = false;
		List<EocIntgMapping> eocIntgRestMappings = eocIntgMappingDao.fetch(tCondition);
		// 有殘留
		if (eocIntgRestMappings != null && !eocIntgRestMappings.isEmpty()) {
			for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
				if (eocIntgMapping.getEocLevel().equals(MdcConstant.COMPANY_ID) || eocIntgMapping.getEocLevel().equals(MdcConstant.SITE_ID)) {
					tRestCompanyOrSite = true;
					break;
				}
			}
			if (!tRestCompanyOrSite) {
				for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
					if (eocIntgMapping.getEocLevel().equals(MdcConstant.ENTERPRISE_ID)) {
						eocIntgMappingDao.remove(eocIntgMapping.getId());
					}
				}
			}
		}
	}

	private void clearRegionSetting(String pTenantId, String pProdName, String pUid) {
		Map<String, String> tCondition = new HashMap<>();
		tCondition.put(MdcConstant.TENANT_ID, pTenantId);
		tCondition.put(MdcConstant.PROD_NAME, pProdName);
		tCondition.put(MdcConstant.UID, pUid);
		boolean tRestCompanyOrSite = false;
		List<EocIntgMapping> eocIntgRestMappings = eocIntgMappingDao.fetch(tCondition);
		// 有殘留
		if (eocIntgRestMappings != null && !eocIntgRestMappings.isEmpty()) {
			for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
				if (eocIntgMapping.getEocLevel().equals(MdcConstant.COMPANY_ID) || eocIntgMapping.getEocLevel().equals(MdcConstant.SITE_ID)) {
					tRestCompanyOrSite = true;
					break;
				}
			}
			if (!tRestCompanyOrSite) {
				for (EocIntgMapping eocIntgMapping : eocIntgRestMappings) {
					if (eocIntgMapping.getEocLevel().equals(MdcConstant.REGION_ID)) {
						eocIntgMappingDao.remove(eocIntgMapping.getId());
					}
				}
			}
		}

	}
}