package com.digiwin.metadatacache.apiservice;

import java.util.*;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.services.LoadCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 查询快取
 * 新增本地快取的查询
 * Path:[/restful/standard/mdc/ShowCache]
 */
@Service
public class ShowCacheService extends AbstractApiService {

    @Autowired
    private LoadCacheService loadCacheService;

    public ShowCacheService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.CLEAN_CACHE_SCHEMA;
    }

    /**
     * 拆线呢缓存
     *
     * @param validatorResult * @param validatorResult
     * @return Map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        // 從 validatorResult 中取得 JSON 內容
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        // 從 JSON 內容中取得 "type" 屬性的值
        String tType = tRequestJsonNode.get(MdcConstant.TYPE).asText();
        // 創建一個字串集合 tKeys，用於存放查詢到的緩存鍵
        Set<String> tKeys = new HashSet<>();
        // 根據 "type" 屬性的值，查詢對應的緩存鍵
        switch (tType) {
            case "tenantProductMappingList":
                tKeys = cacheService
                        .getKeysByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode()
                                + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "apiVersionList":
                tKeys = cacheService
                        .getKeysByPattern(CacheMapTypeEnum.api_version_list.getCode()
                                + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "dispatch":
                tKeys = cacheService
                        .getKeysByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode()
                                + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "organizationList":
                tKeys = cacheService
                        .getKeysByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode()
                                + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
//            case "tenantProductListUpdate":
//                tKeys = cacheService
//                        .getKeysByPattern(CacheMapTypeEnum.tenant_product_list_update_cachemap.getCode()
//                                + MdcSymbolConstant.ASTERISK_SYMBOL);
//                break;
            case "apiBaseInfo":
                return loadCacheService.showData();
            case "apiMetadata":
                tKeys.add(tRequestJsonNode.get(MdcConstant.NAME).asText());
                break;
            case "omTenant":
                tKeys = cacheService.getKeysByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode()
                        + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "globalParam":
                tKeys = cacheService.getKeysByPattern(CacheMapTypeEnum.global_param_cachemap.getCode()
                        + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            default:
                break;
        }
        // 創建一個 HashMap，用於存放查詢到的緩存內容
        Map<String, Object> map = new HashMap<>();
        // 如果查詢到了緩存鍵，則遍歷所有的緩存鍵，將其對應的緩存內容存入 map 中
        for (String tKey : tKeys) {
            Object cacheValue = cacheService.get(tKey);
            if (cacheValue != null) {
                map.put(tKey, cacheValue);
            }
        }
        // 返回存放緩存內容的 map
        return map;
    }
}
