package com.digiwin.metadatacache.apiservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得租戶服務分派資訊
 * Path:[/restful/standard/mdc/TenantEaiInfo/Get]
 */
@org.springframework.stereotype.Service
public class TenantEaiInfoGetService extends AbstractApiService {

	@Autowired
	private ProductDao productDao;

	@Autowired
	private EaiTenantMappingDao eaiTenantMappingDao;

	@Autowired

	public TenantEaiInfoGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.TENANT_EAI_INFO_GET_SCHEMA;
	}

	/**
	 * 通过租户获取对应的产品
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		// 組成Node
		ObjectMapper mapper = new ObjectMapper();
		ArrayNode tDataNode = mapper.createArrayNode();
		// 取出租戶清單
		ArrayNode tTenantList = (ArrayNode) tRequestJsonNode.get(MdcConstant.TENANT);
		List<String> tEaiList = new ArrayList<>();
		for (JsonNode tTenant : tTenantList) {
			// 設定尋找條件，取得租戶對應地中台
			Map<String, String> tEaiTenantMappingCondition = new HashMap<>();
			tEaiTenantMappingCondition.put(MdcConstant.TENANT, tTenant.asText());
			List<EaiTenantMapping> tEaiTenantMappings = eaiTenantMappingDao.fetch(tEaiTenantMappingCondition);
			String tEaiUid;
			// 有對應地中台
			if (CollectionUtils.isNotEmpty(tEaiTenantMappings)) {
				tEaiUid = tEaiTenantMappings.get(0).getEaUid();
				if (!tEaiList.contains(tEaiUid)) {
					tEaiList.add(tEaiUid);
					ObjectNode tTenantEaiInfoNode = mapper.createObjectNode();
					tTenantEaiInfoNode.put(MdcConstant.TENANT_ID, tTenant.asText());
					tTenantEaiInfoNode.put(MdcConstant.EAI_UID, tEaiUid);
					ArrayNode tProductInfoNode = mapper.createArrayNode();
					// 設定尋找條件，取得地中台所有產品
					Map<String, String> tProductCondition = new HashMap<>();
					tProductCondition.put(MdcConstant.EAI_UID, tEaiUid);
					List<Product> tProducts = productDao.fetch(tProductCondition);
					if (CollectionUtils.isNotEmpty(tProducts)) {
						List<String> tProdNameList = new ArrayList<>();
						for (Product tProduct : tProducts) {
							if (!tProdNameList.contains(tProduct.getName())) {
								tProdNameList.add(tProduct.getName());
								tProductInfoNode.add(tProduct.getName());
							}
						}
					}
					tTenantEaiInfoNode.set(MdcConstant.PRODUCT, tProductInfoNode);
					tDataNode.add(tTenantEaiInfoNode);
				}
			}
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.set(MdcConstant.DATA, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}