package com.digiwin.metadatacache.apiservice.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/7/19 15:49
 */
@Getter
@Setter
public class SeviceBaseInfoGetResponse {

    private Api api;

    private Product prod;

    private Map<String, Object> eoc;

    private List<Map<String, Object>> dispatch;

    /**
     * 租户版本
     */
    private String tenantVersion;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Api {

        private String parentApi;

        private String name;

        private Boolean idempotency;
    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Product {

        private String name;

        private String uid;

        private String productType;

    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        if (api != null) {
            map.put("api", api);
        }
        if (prod != null) {
            map.put("prod", prod);
        }
        if (eoc != null) {
            map.put("eoc", eoc);
        }
        if (dispatch != null) {
            map.put("dispatch", dispatch);
        }
        if (StringUtils.isNotBlank(tenantVersion)) {
            map.put("tenantVersion", tenantVersion);
        }
        return map;
    }
}
