package com.digiwin.metadatacache.constant;

/**
 * 外部接口调用名
 */
public class InterfaceConstant {

    /**
     * token解析获取租户信息
     */
    public static final String LOGIN_PATH = "/api/iam/v2/identity/token/analyze";

    /**
     * 對應的角色信息
     */
    public static final String USER_ROLE = "/api/iam/v2/user/role";

    /**
     * 檢查token對應的租戶是否為個人租戶
     */
    public static final String GET_TENANT_CURRENT = "/api/iam/v2/tenant/current";

    /**
     * 更新云端eoc
     */
    public static final String UPDATE_EOC_ENTRY = "/api/eoc/v2/corp/company/factory";

    /**
     * 获取集团信息
     */
    public static final String GET_ENTERPRISE_INFO = "/api/eoc/v2/corp/simple";

    /**
     * 公司列表查询
     */
    public static final String GET_COMPANY_INFO = "/api/eoc/v2/corp/company";

    /**
     * 根據租戶ID呼叫TM取得license key
     */
    public static final String KNOW_LEDGE_GRAPH_LICENSE_KEY = "/knowledgegraph/app/licenseKey";

    /**
     * 根據license key呼叫IAM取得userToken
     */
    public static final String IAM_LOGIN = "/api/iam/v2/identity/login";
    
    public static final String IAM_LOGIN_INTERNAL = "/api/iam/v2/identity/login/internal";

    /**
     * 根據userToken呼叫EOC取得運營單元碼
     */
    public static final String EOC_CORP_ALL = "/api/eoc/v2/corp/all";

    /**
     * 根據userToken呼叫EOC取得運營單元碼(新版)
     */
    public static final String EOC_V2_CORP_ALL = "/api/eoc/v2/operation/unit/search";

    /**
     * 查询指定租户的授权信息
     */
    public static final String AUTHORIZATION_TENANT= "/api/cac/v4/authorizations/tenants/%s";

    /**
     * 获取kg 服务产品配置地址
     */
    public static final String KG_GET_SERVICE_CONFIG_URL = "/knowledgegraph/tenant/systemTenantServiceConfig";

    /**
     * 查询租户版本
     */
    public static final String GET_CURRENT_SIMPLE = "/api/iam/v2/tenant/current/simple";
}
