package com.digiwin.metadatacache.dao.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.*;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.services.MdcCacheService;

@Service
@Transactional("mdcTransactionManager")
public class ApiDaoImpl extends GenericDaoImpl<Api, Long> implements ApiDao {

	@Autowired
	protected MdcCacheService cacheService;

	public ApiDaoImpl() {
		super(Api.class);
	}

	@Override
	public Api save(final Api pApi) {
		return getHibernateTemplate().execute(new HibernateCallback<Api>() {
			@Override
			public Api doInHibernate(Session pSession) throws HibernateException {
				Transaction tTransaction = pSession.getTransaction();
				Api margedApi = null;
				try {
					// 紀錄原始要存入的版本
					String tOriginalVersion = pApi.getApiVersions().get(0).getVersion();
					// 舊規則-如果已存在相同名稱的api資料，則更新此筆api資料列
					// 新規則-如果已存在相同名稱、相同租戶ID的api資料，則更新此筆api資料列
					Api existingApi = null;
					String tApiName = pApi.getName();

					if (pApi.getTenantId() != null && pApi.getTenantId().length() != 0) {
						existingApi = getByNameAndTenantId(tApiName, pApi.getTenantId());
					} else {
						existingApi = getByName(tApiName);
					}
					if (existingApi != null) {
						pApi.setId(existingApi.getId());
						// 如果傳入api元數據的版本已存在，則不對原api_version資料列作更動(api_metadata資料列同理)
						List<ApiVersion> toRemove = new ArrayList<>();
						for (ApiVersion tUpdateApiVersion : pApi.getApiVersions()) {
						    for (ApiVersion tOrgApiVersion : existingApi.getApiVersions()) {
						        if (tOrgApiVersion.getVersion().equals(tUpdateApiVersion.getVersion())) {
						            toRemove.add(tUpdateApiVersion);
						            break;
						        }
						    }
						}
						pApi.getApiVersions().removeAll(toRemove);
					}
					pApi.setBuildTime(Calendar.getInstance());
					margedApi = (Api) pSession.merge(pApi);
					for (ApiVersion margedApiVersion : margedApi.getApiVersions()) {
						for (ApiVersion version : pApi.getApiVersions()) {
							if (margedApiVersion.getVersion().equals(version.getVersion())) {
								if(version.getApiMetadata() != null) {
									ApiMetadata tApiMetadata = version.getApiMetadata();
									tApiMetadata.setApiVersionId(margedApiVersion.getId());
									pSession.save(tApiMetadata);
								}
	                            break;
	                        }
	                    }
					}
					// pSession.getTransaction().commit();
					// tTransaction.commit();
					// 清除cache相關資料
					String tKey = "";
					List<String> tKeyList = new ArrayList<>();
					if (margedApi.getTenantId() == null && tOriginalVersion == null) {
						tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + margedApi.getName();
					} else if (margedApi.getTenantId() == null && tOriginalVersion != null) {
						tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + margedApi.getName()
								+ MdcSymbolConstant.COLON + tOriginalVersion;
						tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + margedApi.getName());
					} else if (margedApi.getTenantId() != null && tOriginalVersion == null) {
						tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + margedApi.getTenantId()
								+ MdcSymbolConstant.COLON + margedApi.getName();
					} else if (margedApi.getTenantId() != null && tOriginalVersion != null) {
						tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + margedApi.getTenantId()
								+ MdcSymbolConstant.COLON + margedApi.getName() + MdcSymbolConstant.COLON + tOriginalVersion;
						tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON
								+ margedApi.getTenantId() + MdcSymbolConstant.COLON + margedApi.getName());
					}
					tKeyList.add(tKey);
					for (String key : tKeyList) {
						cacheService.remove(key);
					}
				} catch (Exception e) {
					if (tTransaction != null) {
						tTransaction.rollback();
						throw e;
					}
				}
				return margedApi;
			}
		});
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<Api> fetch(Map<String, String> pConditions) {
		System.out.println(getHibernateTemplate().getSessionFactory());
		return getHibernateTemplate().execute(new HibernateCallback<List<Api>>() {
			@SuppressWarnings("deprecation")
			@Override
			public List<Api> doInHibernate(Session session) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = session.createCriteria(Api.class);

				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				tCriteria.setFetchMode("apiVersions", FetchMode.EAGER);

				if (pConditions.containsKey("tenant_id")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
				} else {
					tCriteria.add(Restrictions.isNull("tenantId"));
				}

				if (pConditions.containsKey("name")) {
					tCriteria.add(Restrictions.like("name", pConditions.get("name"), MatchMode.START));
				}
				return tCriteria.list();
			}
		});
	}

	/** 根據名稱查詢API，不存在則回傳null **/
	@Override
	public Api getByName(String pName) {
		DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
		tDetachedCriteria.add(Restrictions.eq("name", pName));
		List<?> tStandardApis = getHibernateTemplate().findByCriteria(tDetachedCriteria);
		if (tStandardApis.size() == 0) {
			return null;
		} else {
			return (Api) tStandardApis.get(0);
		}
	}

	@Override
	public List<Api> getUcApi() {
		DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
		tDetachedCriteria.add(Restrictions.like("name", "uc.", MatchMode.START));
		return (List<Api>) getHibernateTemplate().findByCriteria(tDetachedCriteria);
	}

	@Override
	public Boolean judgeApi(String pName, String pTenantId, Boolean judge) {
		DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
		tDetachedCriteria.add(Restrictions.eq("name", pName));
		if (null != pTenantId) {
			if(judge){
				Disjunction disjunction = Restrictions.disjunction();
				disjunction.add(Restrictions.eq("tenantId", pTenantId));
				disjunction.add(Restrictions.isNull("tenantId"));
				tDetachedCriteria.add(disjunction);
			} else {
				tDetachedCriteria.add(Restrictions.eq("tenantId", pTenantId));
			}
		}else {
			tDetachedCriteria.add(Restrictions.isNull("tenantId"));
		}
		List<?> apiList = getHibernateTemplate().findByCriteria(tDetachedCriteria);
		return CollectionUtils.isNotEmpty(apiList);
	}

	/** 根據名稱與租戶ID查詢API，不存在則回傳null **/
	@Override
	public Api getByNameAndTenantId(String pName, String pTenantId) {
		DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Api.class);
		tDetachedCriteria.add(Restrictions.eq("name", pName));
		tDetachedCriteria.add(Restrictions.eq("tenantId", pTenantId));
		List<?> tStandardApis = getHibernateTemplate().findByCriteria(tDetachedCriteria);
		if (tStandardApis.size() == 0) {
			return null;
		} else {
			return (Api) tStandardApis.get(0);
		}
	}

	@Override
	public void removeByNameAndVersionTenantId(String pName, String pVersion, String pTenantId) {
		final Api tApi;
		// 取得符合服務名稱和租戶ID的服務
		if (pTenantId != null && pTenantId.length() != 0) {
			tApi = getByNameAndTenantId(pName, pTenantId);
			// 取得符合服務名稱的服務
		} else {
			tApi = getByName(pName);
		}
		// 有找到服務
		if (tApi != null) {
			getHibernateTemplate().execute(new HibernateCallback<List<Api>>() {
				@Override
				public List<Api> doInHibernate(Session pSession) throws HibernateException {
					Transaction tQ = null;
					try {
						// 循環此服務所有版本
						for (ApiVersion tVersion : tApi.getApiVersions()) {
							// 不分穩敏(新規則)
							if (tVersion.getVersion().equals(pVersion)) {
								tQ = pSession.getTransaction();
								// 刪除該服務版本元數據
								Query tQueryRemoveApiMetadata = pSession
										.createQuery("delete ApiMetadata where api_version_id = :api_version_id");
								tQueryRemoveApiMetadata.setParameter("api_version_id", tVersion.getId());
								// 刪除該服務版本
								Query tQueryRemoveApiVersion = pSession
										.createQuery("delete ApiVersion where api_id= :api_id and version = :version");
								tQueryRemoveApiVersion.setParameter("api_id", tApi.getId());
								tQueryRemoveApiVersion.setParameter("version", pVersion);
								// 所有服務版本都被刪除，則刪除該服務
								Query tQueryRemoveApi = pSession.createQuery("delete Api where id = :id");
								tQueryRemoveApi.setParameter("id", tApi.getId());
								// 刪除該服務版本元數據
								tQueryRemoveApiMetadata.executeUpdate();
								// 刪除該服務版本
								tQueryRemoveApiVersion.executeUpdate();
								// 所有服務版本都被刪除，則刪除該服務
								if (tApi.getApiVersions().size() == 1) {
									tQueryRemoveApi.executeUpdate();
								}
								// tQ.commit();
							}
						}
						// 清除cache相關資料
						String tKey = "";
						List<String> tKeyList = new ArrayList<>();
						if (tApi.getTenantId() == null && pVersion == null) {
							tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getName();
						} else if (tApi.getTenantId() == null && pVersion != null) {
							tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getName()
									+ MdcSymbolConstant.COLON + pVersion;
							tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getName());
						} else if (tApi.getTenantId() != null && pVersion == null) {
							tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getTenantId()
									+ MdcSymbolConstant.COLON + tApi.getName();
						} else if (tApi.getTenantId() != null && pVersion != null) {
							tKey = CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getTenantId()
									+ MdcSymbolConstant.COLON + tApi.getName() + MdcSymbolConstant.COLON + pVersion;
							tKeyList.add(CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.COLON + tApi.getTenantId()
									+ MdcSymbolConstant.COLON + tApi.getName());
						}
						tKeyList.add(tKey);
						for (String key : tKeyList) {
							cacheService.remove(key);
						}
					} catch (Exception e) {
						log.error(e);
						if (tQ != null) {
							tQ.rollback();
						}
					}
					return null;
				}
			});
		}
	}
}
