package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.ApiMetadataDao;
import com.digiwin.metadatacache.model.ApiMetadata;

@Service
@Transactional("mdcTransactionManager")
public class ApiMetadataDaoImpl extends GenericDaoImpl<ApiMetadata, Long> implements ApiMetadataDao {

	public ApiMetadataDaoImpl() {
		super(ApiMetadata.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<ApiMetadata> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ApiMetadata>>() {
			@SuppressWarnings("deprecation")
			@Override
			public List<ApiMetadata> doInHibernate(Session pSession) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(ApiMetadata.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				if (pConditions.containsKey("api_version_id")) {
					tCriteria.add(Restrictions.eq("apiVersion.id", Long.valueOf(pConditions.get("api_version_id"))));
				}
				return tCriteria.list();
			}
		});
	}
	
	@Override
	public List<ApiMetadata> getByApiVersionId(final Long pId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ApiMetadata>>() {
			@SuppressWarnings("unchecked")
			@Override
			public List<ApiMetadata> doInHibernate(Session session) throws HibernateException {
				Query<ApiMetadata> tQuery = session.createQuery("from ApiMetadata where api_version_id = :param ");
				tQuery.setParameter("param", pId);
				List<?> list = tQuery.list();
				List<ApiMetadata> tApiMetadatas = (List<ApiMetadata>) list;
				if (list.size() == 0) {
					return null;
				} else {
					return tApiMetadatas;
				}
			}
		});
	}
}
