package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.model.EaiTenantMapping;

@Service
@Transactional("mdcTransactionManager")
public class EaiTenantMappingDaoImpl extends GenericDaoImpl<EaiTenantMapping, Long> implements EaiTenantMappingDao {

	public EaiTenantMappingDaoImpl() {
		super(EaiTenantMapping.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<EaiTenantMapping> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<EaiTenantMapping>>() {
			@Override
			public List<EaiTenantMapping> doInHibernate(Session pSession) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(EaiTenantMapping.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				// 設查詢條件
				// containsKey - boolean containsKey(Object key) 判斷map是否包含指定的key
				// MatchMode.ANYWHERE 等同於 like="%name%"
				if (pConditions.containsKey("tenant")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant")));
				}
				if (pConditions.containsKey("eai_uid")) {
					tCriteria.add(Restrictions.eq("eaUid", pConditions.get("eai_uid")));
				}
				return tCriteria.list();
			}
		});

	}

	@Override
	public void removeByEaiUid(final String pEaiUid) {
		getHibernateTemplate().execute(new HibernateCallback<EaiTenantMapping>() {
			@Override
			public EaiTenantMapping doInHibernate(Session pSession) throws HibernateException {
				Query tQ = pSession.createQuery("delete EaiTenantMapping where eaUid is :eaiUid");
				tQ.setParameter("eaiUid", pEaiUid);
				tQ.executeUpdate();
				return null;
			}
		});
	}
}
