package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.ProductApiDispatchInfoDao;
import com.digiwin.metadatacache.model.ProductApiDispatchInfo;

@Service
@Transactional("mdcTransactionManager")
public class ProductApiDispatchInfoDaoImpl extends GenericDaoImpl<ProductApiDispatchInfo, Long>
		implements ProductApiDispatchInfoDao {

	public ProductApiDispatchInfoDaoImpl() {
		super(ProductApiDispatchInfo.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<ProductApiDispatchInfo> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ProductApiDispatchInfo>>() {
			@Override
			public List<ProductApiDispatchInfo> doInHibernate(Session pSession) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(ProductApiDispatchInfo.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				if (pConditions.containsKey("prod_name")) {
					tCriteria.add(Restrictions.eq("productName", pConditions.get("prod_name")));
				}
				if (pConditions.containsKey("api_name")) {
					tCriteria.add(Restrictions.eq("apiName", pConditions.get("api_name")));
				}
				return tCriteria.list();
			}
		});
	}
}
