package com.digiwin.metadatacache.exception;

import com.digiwin.metadatacache.enums.ValidateStateEnum;

/**
 * 新增产品服务时 请求中找不到新增的产品信息
 */
public class AddProdNotFoundException extends BaseException {

	private static final long serialVersionUID = 1L;

	final private static ValidateStateEnum VALIDATE_STATE_ENUM = ValidateStateEnum.ADD_PRODUCT_INFO_NOT_FOUND;

	public AddProdNotFoundException(Class<?> pClazz) {
		super(pClazz, VALIDATE_STATE_ENUM);
	}

	public AddProdNotFoundException(String pExceptionMsg, Class<?> pClazz) {
		super(pExceptionMsg, pClazz, VALIDATE_STATE_ENUM);
	}

	public AddProdNotFoundException(Throwable pSrcException, Class<?> pClazz) {
		super(pSrcException, pClazz, VALIDATE_STATE_ENUM);
	}

	public AddProdNotFoundException(String pExceptionMsg, Throwable pSrcException, Class<?> pClazz) {
		super(pExceptionMsg, pSrcException, pClazz, VALIDATE_STATE_ENUM);
	}
}