package com.digiwin.metadatacache.model;

import java.io.Serializable;
import java.util.Calendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * The persistent class for the standard_api_version database table.
 * 
 */
@Entity
@Table(name = "api_version")
@NamedQuery(name = "ApiVersion.findAll", query = "SELECT s FROM ApiVersion s")
public class ApiVersion implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	private String version;

	@Column(name = "approved_status")
	private Long approvedStatus;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "idempotency")
	private boolean idempotency;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "api_id")
	private Api Api;
	
	@Transient
	private ApiMetadata apiMetadata;

	public ApiVersion() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getVersion() {
		return this.version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public Api getApi() {
		return this.Api;
	}

	public void setApi(Api Api) {
		this.Api = Api;
	}

	public Long getApprovedStatus() {
		return approvedStatus;
	}

	public void setApprovedStatus(Long approvedStatus) {
		this.approvedStatus = approvedStatus;
	}

	public Calendar getBuildTime() {
		return buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public boolean isIdempotency() {
		return idempotency;
	}

	public void setIdempotency(boolean idempotency) {
		this.idempotency = idempotency;
	}

	public ApiMetadata getApiMetadata() {
		return apiMetadata;
	}

	public void setApiMetadata(ApiMetadata apiMetadata) {
		this.apiMetadata = apiMetadata;
	}
	
	

}