package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 行业表
 */
@Entity
@Data
@Table(name = "asset_industry")
public class AssetIndustry implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "industry_id")
    private Long industryId;

    /**
     * 地区（1.大陆区、2.台湾区）
     */
    @Column(name = "area")
    private String area;

    /**
     * 行业分类（1.门类、2.大类、3.中类、4.小类）
     */
    @Column(name = "industry_type")
    private String industryType;

    /**
     * 行业编号
     */
    @Column(name = "industry_no")
    private String industryNo;

    /**
     * 行业名称
     */
    @Column(name = "industry_name")
    private String industryName;

    /**
     * 父级行业编号
     */
    @Column(name = "parent_industry_no")
    private String parentIndustryN_no;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
