package com.digiwin.metadatacache.model;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 行业辞汇字典
 */
@Entity
@Data
@Table(name = "asset_industry_word_dictionary")
public class AssetIndustryWordDictionary implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "industry_word_dictionary_id")
    private Long industryWrdDictionaryId;

    /**
     * 标准辞汇编号
     */
    @Column(name = "standard_word_no")
    private String standardWordNo;

    /**
     * 标准辞汇名称_繁体
     */
    @Column(name = "standard_word_name_zh_tw")
    private String standardWordNameZhTw;


    /**
     * 标准辞汇名称_简体
     */
    @Column(name = "standard_word_name_zh_cn")
    private String standardWordNameZhCn;

    /**
     * 标准辞汇名称_英文
     */
    @Column(name = "standard_word_name_en_us")
    private String standardWordNameEnUs;

    /**
     * 行业术语主键
     */
    @Column(name = "industry_term_id")
    private Long industryTermId;

    /**
     * 状态(Y.生效 V.失效)
     */
    @Column(name = "manage_status")
    private String manageStatus;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private LocalDateTime createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private String createBy;

    /**
     * 更新呢时间
     */
    @Column(name = "modified_date")
    private LocalDateTime modifiedDate;

    /**
     * 更改人
     */
    @Column(name = "modified_by")
    private String modifiedBy;
}
