package com.digiwin.metadatacache.model;

import java.io.Serializable;
import java.util.Calendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonProperty;

@Entity
@Table(name = "tenant_eoc_set_info")
public class TenantEocSetInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "tenant_id")
	private String tenantId;

	@Column(name = "user_id")
	private String userId;

	@Column(name = "require_setting")
	@JsonProperty("require_setting")
	private boolean requireSetting;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public TenantEocSetInfo() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public boolean isRequireSetting() {
		return requireSetting;
	}

	public void setRequireSetting(boolean requireSetting) {
		this.requireSetting = requireSetting;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Calendar getBuildTime() {
		return buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

}