package com.digiwin.metadatacache.mq;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.model.MqPublishParam;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

/**
 * @author rwm
 */
public class RabbitMqManager {

	protected final Log log = LogFactory.getLog(getClass());

	private static RabbitMqManager rabbitMQManager = null;

	/**
	 * MQ連接共享 不需要每次重建
	 */
	private final Connection connection;

	static {
		try {
			rabbitMQManager = new RabbitMqManager();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static RabbitMqManager getRabbitMQManager() {
		if (rabbitMQManager == null) {
			throw new RuntimeException("RabbitMQ created failed");
		}
		return rabbitMQManager;
	}

	private RabbitMqManager() throws Exception {
		if (null == MdcApplicationParameter._MQ_HOST || MdcApplicationParameter._MQ_HOST.length() == 0) {
			throw new RuntimeException("mdc rabbitmq properties config error");
		}
		ConnectionFactory factory = new ConnectionFactory();
		factory.setUsername(MdcApplicationParameter._MQ_USERNAME);
		factory.setPassword(MdcApplicationParameter._MQ_PASSWORD);
		factory.setHost(MdcApplicationParameter._MQ_HOST);
		if (!MdcApplicationParameter._MQ_VIRTUAL_HOST.isEmpty()) {
			factory.setVirtualHost(MdcApplicationParameter._MQ_VIRTUAL_HOST);
		}
		factory.setPort(Integer.parseInt(MdcApplicationParameter._MQ_PORT));
		// 創建連接
		connection = factory.newConnection();

		try (Channel tChannel = connection.createChannel()) {
			tChannel.exchangeDeclare(MdcApplicationParameter._MQ_EXCHANGE_NAME, MdcApplicationParameter._MQ_EXCHANGE_TYPE, true);
			tChannel.queueDeclare(MdcApplicationParameter._MQ_QUEUE_NAME, true, false, false, null);
			tChannel.queueBind(MdcApplicationParameter._MQ_QUEUE_NAME, MdcApplicationParameter._MQ_EXCHANGE_NAME, MdcApplicationParameter._MQ_ROUTING_KEY);
		} catch (Exception e) {
			log.error("Creat queue failed.", e);
		}
	}

	public boolean publishMessage(MqPublishParam publishParam) {
		boolean result = false;
		if (null == publishParam.getMessage() || publishParam.getMessage().isEmpty()) {
			throw new RuntimeException("message can't be empty");
		}
		if (publishParam.getQueueName() == null || publishParam.getQueueName().isEmpty()) {
			throw new RuntimeException("queueName can't be empty");
		}
		if (publishParam.getRoutingKey() == null || publishParam.getRoutingKey().isEmpty()) {
			throw new RuntimeException("routingKey can't be empty");
		}
		try (Channel channel = connection.createChannel()) {
			// 取得發送結果
			channel.confirmSelect();
			// 發布訊息到RabbitMQ Server
			channel.basicPublish(publishParam.getExchangeName(), publishParam.getRoutingKey(), null, publishParam.getMessage().getBytes());
			// 如果發送失敗會Exception
			channel.waitForConfirmsOrDie();
			result = true;
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		return result;
	}

}