package com.digiwin.metadatacache.rest;

import java.util.Map;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.app.service.restful.DWRestfulService;

/**
 * Metadata Cache接口服務
 */
@DWRestfulService
public interface IMetadataCacheService extends DWService {

    /**
     * 取得API清單
     */
    @DWRequestMapping(path = "/ApiList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiListGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得API元數據(ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiMetadata/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiMetadataGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得API元數據(ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiMetadata/GetByApi", method = {DWRequestMethod.POST})
    Map<String, Object> apiMetadataGetByApi (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶所属地中台上的產品清單
     * or取得租戶所属地中台上實作API的產品清單
     */
    @DWRequestMapping(path = "/TenantProductList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductListGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶服務分派資訊
     */
    @DWRequestMapping(path = "/TenantProductInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductListDispatchInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 保存租戶服务信息(ESP采用app_token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ProductInfo/Add", method = {DWRequestMethod.POST})
    Map<String, Object> productInfoAdd (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶分派資訊(新增服務名稱，用來判斷是否需要分派)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantProductApiDispatchInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductApiDispatchInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得運營單元轉換資訊
     */
    @DWRequestMapping(path = "/TenantOrganizationTrans/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantOrganizationTransGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得運營單元碼清單(存在header不传token的场景)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/EOCInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> eocInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得集成代碼清單
     */
    @DWRequestMapping(path = "/IntgInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> intgInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶產品運營清單(含運營階層關係)(ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantProductOperationList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductOperationListGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶的全域管理參數值
     */
    @DWRequestMapping(path = "/GlobalParams/Get", method = {DWRequestMethod.POST})
    Map<String, Object> globalParamsGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得自動配對EOC運營單元碼清單
     */
    @DWRequestMapping(path = "/DefaultEocMapping/Get", method = {DWRequestMethod.POST})
    Map<String, Object> defaultEocMappingGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得om單元對應租戶ID(ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/OmTenantId/Get", method = {DWRequestMethod.POST})
    Map<String, Object> omTenantIdGet (DWRestfulRequest request) throws Exception;

    /**
     * 清cache
     */
    @DWRequestMapping(path = "/CleanCache", method = {DWRequestMethod.POST})
    Map<String, Object> cleanCache (DWRestfulRequest request) throws Exception;

    /**
     * show cache
     */
    @DWRequestMapping(path = "/ShowCache", method = {DWRequestMethod.POST})
    Map<String, Object> showCache (DWRestfulRequest request) throws Exception;

    /**
     * 同步刪除API元數據
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/StdApiMetadata/Delete", method = {DWRequestMethod.POST})
    Map<String, Object> stdApiMetadataDelete (DWRestfulRequest request) throws Exception;

    /**
     * 同步產品與服務清單(ESP采用app_token验证)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantProductList/Update", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductListUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 同步eoc與om代碼對應
     */
    @DWRequestMapping(path = "/EOCIntgMap/Update", method = {DWRequestMethod.POST})
    Map<String, Object> eocIntgMapUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶穩態產品支持的應用版本
     */
    @DWRequestMapping(path = "/AppSupportList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> appSupportListGet (DWRestfulRequest request) throws Exception;

    /**
     * 查詢支持應用版本的租戶
     */
    @DWRequestMapping(path = "/AppSupportVersion/Get", method = {DWRequestMethod.POST})
    Map<String, Object> appSupportVersionGet (DWRestfulRequest request) throws Exception;

    /**
     * 新增/修改租戶穩態產品支持的應用版本
     */
    @DWRequestMapping(path = "/AppSupportVersion/Add", method = {DWRequestMethod.POST})
    Map<String, Object> appSupportVersionAdd (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶地中台資訊
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantEaiInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantEaiInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得新增或修改的API清單
     */
    @DWRequestMapping(path = "/ApiInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得產品主機的運營配置
     */
    @DWRequestMapping(path = "/OperationManageSetting/Get", method = {DWRequestMethod.POST})
    Map<String, Object> operationManageSettingGet (DWRestfulRequest request) throws Exception;

    /**
     * 啟用/禁用運營單元配置
     */
    @DWRequestMapping(path = "/OperationManageSetting/Update", method = {DWRequestMethod.POST})
    Map<String, Object> operationManageSettingUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶運營配置狀況
     */
    @DWRequestMapping(path = "/tenant/EocSetInfo", method = {DWRequestMethod.POST})
    Map<String, Object> eocSetInfoCheck (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶忽略運營配置狀況
     */
    @DWRequestMapping(path = "/tenant/IgnoreEocSet", method = {DWRequestMethod.POST})
    Map<String, Object> ignoreEocSetInfo (DWRestfulRequest request) throws Exception;

    /**
     * 取得拥有个案api的租户列表
     */
    @DWRequestMapping(path = "/UcTenantList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> ucTenantListGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶ERP產品主機
     */
    @DWRequestMapping(path = "/TenantProductType/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductTypeGet (DWRestfulRequest request) throws Exception;

    /**
     * 查詢租戶所有可調用的產品(ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantBindProductList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantBindProductListGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得API provider
     */
    @DWRequestMapping(path = "/ApiProvider/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiProviderGet (DWRestfulRequest request) throws Exception;

    /**
     * 元数据更新(api_mgmt存在定时任务，没有token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/StdApiMetadata/Update", method = {DWRequestMethod.POST})
    Map<String, Object> StdApiMetadataUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 获取API之间的关联关系 (ESP-SDK未透传token)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiRelation/Get", method = {DWRequestMethod.POST})
    Map<String, Object> ApiRelationGet (DWRestfulRequest request) throws Exception;

    /**
     * 保存API之间的关联关系 (待废弃)
     */
//	@DWRequestMapping(path = "/ApiRelation/Save", method = { DWRequestMethod.POST })
    Map<String, Object> ApiRelationSave (DWRestfulRequest request) throws Exception;

    /**
     * 删除API之间的关联关系 (待废弃)
     */
//	@DWRequestMapping(path = "/ApiRelation/Delete", method = { DWRequestMethod.POST })
    Map<String, Object> ApiRelationDelete (DWRestfulRequest request) throws Exception;

    /**
     * 查询api基础信息（ESP-SDK使用）
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiBaseInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> ApiBaseInfoGet (DWRestfulRequest request) throws Exception;

    /**
     * 资产中心-资产注册
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/Asset/Register", method = {DWRequestMethod.POST})
    Map<String, Object> assetRegister (DWRestfulRequest request) throws Exception;

    /**
     * 资产中心-获取资产清单
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/AssetList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> assetListGet (DWRestfulRequest request) throws Exception;

    /**
     * 资产中心-获取行业辞汇清单
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/AssetIndustryVocabularyList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> assetIndustryVocabularyListGet (DWRestfulRequest request) throws Exception;

    @DWRequestMapping(path = "/TenantApiProduct/batch/get", method = {DWRequestMethod.POST})
    Map<String, Object> batchGetTenantApiProduct (DWRestfulRequest request) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/ServiceBaseInfo/get", method = {DWRequestMethod.POST})
    Map<String, Object> getServiceBaseInfo (DWRestfulRequest request) throws Exception;

    /**
     * 查询产品以及云地映射配置(废弃接口)
     */
    @Deprecated
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantProductCloudMapping/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductCloudMappingGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得產品主機的雲地映射(一览表页面用)
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/CloudMappingSetting/Get", method = {DWRequestMethod.POST})
    Map<String, Object> cloudMappingSettingGet (DWRestfulRequest request) throws Exception;

    /**
     * 云地映射啟用/禁用運營單元配置
     */
    @DWRequestMapping(path = "/CloudMappingSetting/Update", method = {DWRequestMethod.POST})
    Map<String, Object> cloudMappingSettingUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 云地映射场域新增、修改、删除
     */
    @DWRequestMapping(path = "/CloudRegionMapping/Update", method = {DWRequestMethod.POST})
    Map<String, Object> cloudRegionMappingUpdate (DWRestfulRequest request) throws Exception;

    /**
     * 云地映射场域列表查询
     */
    @DWRequestMapping(path = "/CloudRegionMapping/Get", method = {DWRequestMethod.POST})
    Map<String, Object> cloudRegionMappingGet (DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶的EOC清單V2(雲地映射)
     */
    @DWRequestMapping(path = "/EOCInfoV2/Get", method = {DWRequestMethod.POST})
    Map<String, Object> getEOCInfoV2Get(DWRestfulRequest request) throws Exception;

    /**
     * 取得租戶產品運營清單(含運營階層關係)(ESP-SDK未透传token) v2逻辑,返回云端和地端数据
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantProductOperationListV2/Get", method = {DWRequestMethod.POST})
    Map<String, Object> tenantProductOperationListV2Get (DWRestfulRequest request) throws Exception;


    /**
     * 取得租戶version信息
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/TenantInfo/Get", method = {DWRequestMethod.POST})
    Map<String, Object> getTenantInfoGet(DWRestfulRequest request) throws Exception;
}
