package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.constant.InterfaceConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.TenantQueryProdException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@Service
public class CacVerifyService {

    private final Log log = LogFactory.getLog(getClass());

    @Autowired
    private DWHttpClient dwHttpClient;

    @Value("${iamApToken}")
    private String iamApToken;

    ObjectMapper mapper = new ObjectMapper();

    /**
     * 取得enabledModules
     */
    public List<String> getEnabledModules(String tenantId, String pUserToken) throws Exception {
        JsonNode tResponse = analyzeAuthorization(tenantId, pUserToken);
        List<String> ids = new ArrayList<>();
        if (null != tResponse && tResponse.isArray()) {
            for (JsonNode jsonNode : tResponse) {
                if (null != jsonNode.get(MdcConstant.CATEGORY_ID)
                        && MdcConstant.APP.equals(jsonNode.get(MdcConstant.CATEGORY_ID).asText())
                        && null != jsonNode.get(MdcConstant.CODE)
                        && !MdcConstant.ATHENA.equals(jsonNode.get(MdcConstant.CODE).asText())) {
                    ids.add(jsonNode.get(MdcConstant.CODE).asText());
                }
            }
        }
        log.info("请求cac获取对应的产品appId" + ids);
        return ids;
    }

    private JsonNode analyzeAuthorization(String tenantId, String pUserToken) throws Exception {
        try {
            URI tUri = DWURIBuilder.create(MdcApplicationParameter._CAC_HOST
                    + String.format(InterfaceConstant.AUTHORIZATION_TENANT, tenantId)).build();
            HttpGet tGet = new HttpGet(tUri);
            tGet.setHeader(MdcConstant.CONTENT_TYPE, "application/json;charset=UTF-8");
            tGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_USER, pUserToken);
            tGet.setHeader(MdcConstant.DIGI_MIDDLEWARE_AUTH_APP, iamApToken);
            tGet.setHeader(MdcConstant.TOKEN, pUserToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY)) {
                tGet.setHeader(MdcConstant.ROUTER_KEY, DWServiceContext.getContext().getRequestHeader().get(MdcConstant.ROUTER_KEY).toString());
            }
            String tResponse = dwHttpClient.execute(tGet, String.class, new DWRequestOption(false));
            return mapper.readTree(tResponse);
        } catch (Exception e) {
            throw new TenantQueryProdException(getClass());
        }
    }

}
