package com.digiwin.metadatacache.util;

import com.digiwin.metadatacache.services.IamVerifyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * IAM处理类
 */
@Service
public class IamVerifyServiceUtil extends GenericServiceUtil<IamVerifyService> {

    private static IamVerifyService service;

    @Override
    @Autowired
    public void setService(IamVerifyService pService) {
        service = pService;
    }

    public static String getUserName(String pUserToken) throws Exception {
        return service.getUserName(pUserToken);
    }

    public static boolean isSuperAdmin(String userId, String pUserToken) throws Exception {
        return service.isSuperAdmin(userId, pUserToken);
    }

    public static boolean isPersonalTenant(String pUserToken) throws Exception {
        return service.isPersonalTenant(pUserToken);
    }

    /**
     * 查询租户版本
     */
    public static String getCurrentTenantVersion(String pTenantId) throws Exception {
        return service.getCurrentTenantVersion(pTenantId);
    }

    /**
     * 查询租户版本
     */
    public static String getCurrentTenantVersionByToken(String token) throws Exception {
        return service.getCurrentTenantVersionByToken(token);
    }

    /**
     * 查询租户token
     */
    public static String getTenantToken(String pTenantId) throws Exception {
        return service.getTokenByTenant(pTenantId);
    }

}
