package com.digiwin.metadatacache.util;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.model.MqPublishParam;
import com.digiwin.metadatacache.mq.RabbitMqManager;

/**
 * mq Util
 */
public class MQUtil {

    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    /**
     * 线程池
     */
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    /**
     * mq消息推送
     *
     * @param pMessage pMessage
     */
    public static void sendApiMetadata(String pMessage) {
        try {
            final MqPublishParam publishParam = new MqPublishParam();
            publishParam.setExchangeName(MdcApplicationParameter._MQ_EXCHANGE_NAME);
            publishParam.setExchangeType(MdcApplicationParameter._MQ_EXCHANGE_TYPE);
            publishParam.setQueueName(MdcApplicationParameter._MQ_QUEUE_NAME);
            publishParam.setRoutingKey(MdcApplicationParameter._MQ_ROUTING_KEY);
            publishParam.setMessage(pMessage);
            final RabbitMqManager mqManager = RabbitMqManager.getRabbitMQManager();
            EXECUTOR_SERVICE.execute(() -> {
                boolean judge = mqManager.publishMessage(publishParam);
                log.info("MQ推送: " + judge);
            });
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}