/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.DateUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiListGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;

    public ApiListGetService() {
        this.jsonSchemaFileName = "api_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tApiInfoAryNode = this.mapper.createArrayNode();
        tDataNode.set("api_info", (JsonNode)tApiInfoAryNode);
        String tTenantId = null;
        if (tRequestJsonNode.get("tenant_id") != null) {
            tTenantId = tRequestJsonNode.get("tenant_id").asText();
        }
        List<Api> tList = this.getApiList(tTenantId);
        for (Api tApi : tList) {
            ObjectNode tApiObject = this.mapper.createObjectNode();
            tApiObject.put("name", tApi.getName().trim());
            ObjectNode tDescriptionNode = this.mapper.createObjectNode();
            tDescriptionNode.put("zh_TW", tApi.getDescriptionZhTw());
            tDescriptionNode.put("zh_CN", tApi.getDescriptionZhCn());
            tDescriptionNode.put("en", tApi.getDescriptionEn());
            tApiObject.set("description", (JsonNode)tDescriptionNode);
            ObjectNode tRemarkNode = this.mapper.createObjectNode();
            tRemarkNode.put("zh_TW", tApi.getRemarkZhTw());
            tRemarkNode.put("zh_CN", tApi.getRemarkZhCn());
            tRemarkNode.put("en", tApi.getRemarkEn());
            tApiObject.set("remark", (JsonNode)tRemarkNode);
            tApiObject.put("category", tApi.getCategory());
            ArrayNode tVersionAryNode = this.mapper.createArrayNode();
            tApiObject.set("version", (JsonNode)tVersionAryNode);
            List<ApiVersion> tApiVersions = tApi.getApiVersions();
            if (tApiVersions != null && !tApiVersions.isEmpty()) {
                int size = tApi.getApiVersions().size();
                for (ApiVersion tApiVersion : tApiVersions) {
                    tVersionAryNode.add(tApiVersion.getVersion());
                }
                tApiObject.put("last_update_time", DateUtil.formatToSecond(tApi.getApiVersions().get(size - 1).getBuildTime().getTime()));
            }
            tApiInfoAryNode.add((JsonNode)tApiObject);
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private List<Api> getApiList(String pTenantId) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        if (pTenantId != null) {
            pCondition.put("tenant_id", pTenantId);
        }
        return this.apiDao.fetch(pCondition);
    }
}

