/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiMetadataDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.ApiMetadataNotFoundException;
import com.digiwin.metadatacache.exception.ApiNameNotExistException;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMetadataGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    private ApiMetadataDao apiMetadataDao;

    public ApiMetadataGetService() {
        this.jsonSchemaFileName = "api_metadata_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        List<Api> tApiList;
        String tKey;
        String tDataFromCache;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tApiInfoAryNode = this.mapper.createArrayNode();
        tDataNode.set("api_info", (JsonNode)tApiInfoAryNode);
        String tApiName = tRequestJsonNode.get("api_name").asText();
        String tTenantId = null;
        String tApiVersion = null;
        if (tRequestJsonNode.get("tenant_id") != null) {
            tTenantId = tRequestJsonNode.get("tenant_id").asText();
        }
        if (tRequestJsonNode.get("api_version") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("api_version").asText())) {
            tApiVersion = tRequestJsonNode.get("api_version").asText();
        }
        if ((tDataFromCache = (String)this.cacheService.get(tKey = tTenantId == null && tApiVersion == null ? CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApiName : (tTenantId == null ? CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tApiName + ":" + tApiVersion : (tApiVersion == null ? CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tTenantId + ":" + tApiName : CacheMapTypeEnum.api_metadata_cachemap.getCode() + ":" + tTenantId + ":" + tApiName + ":" + tApiVersion)))) != null) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tKey));
            return this.converJsonStringToMap(tDataFromCache);
        }
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("name", tApiName);
        if (tTenantId != null) {
            pCondition.put("tenant_id", tTenantId);
        }
        if (CollectionUtils.isEmpty(tApiList = this.apiDao.fetch(pCondition))) {
            throw new ApiNameNotExistException(this.getClass());
        }
        Api tApi = tApiList.get(0);
        ApiMetadata tApiMetadata = this.getApiMetadata(tApi, tApiVersion);
        ApiVersion apiVersion = (ApiVersion)this.apiVersionDao.get(tApiMetadata.getApiVersionId());
        tDataNode = this.mapper.createObjectNode();
        tDataNode.put("api_name", tApiName);
        if (!StringUtil.isEmptyOrSpace(tApi.getTenantId())) {
            tDataNode.put("tenant_id", tApi.getTenantId());
            if (!StringUtil.isEmptyOrSpace(tApi.getPackageName())) {
                tDataNode.put("package_name", tApi.getPackageName());
            }
        }
        tDataNode.put("type", tApi.getInvokedType());
        tDataNode.put("category", tApi.getCategory());
        ObjectNode tDescriptionNode = this.mapper.createObjectNode();
        tDescriptionNode.put("zh_TW", tApi.getDescriptionZhTw());
        tDescriptionNode.put("zh_CN", tApi.getDescriptionZhCn());
        tDescriptionNode.put("en", tApi.getDescriptionEn());
        tDataNode.set("description", (JsonNode)tDescriptionNode);
        ObjectNode tRemarkNode = this.mapper.createObjectNode();
        tRemarkNode.put("zh_TW", tApi.getRemarkZhTw());
        tRemarkNode.put("zh_CN", tApi.getRemarkZhCn());
        tRemarkNode.put("en", tApi.getRemarkEn());
        tDataNode.set("remark", (JsonNode)tRemarkNode);
        tDataNode.put("api_version", apiVersion.getVersion());
        if (tApi.getApi_type().equals(ApiTypeEnum.agile.toString()) && tApi.getUrl() != null) {
            tDataNode.put("url", tApi.getUrl());
        }
        if (tApi.getApi_type().equals(ApiTypeEnum.standard.toString())) {
            tDataNode.put("url", DWApplicationConfigUtils.getProperty((String)"eaiUrl") + "/CROSS/RESTful");
        }
        JsonNode actualObj = this.mapper.readTree(tApiMetadata.getMetadata());
        tDataNode.set("data_metadata", actualObj);
        tDataNode.put("idempotency", apiVersion.isIdempotency());
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        if (tStateCode.getCode().equals("000")) {
            this.cacheService.remove(tKey);
            this.cacheService.setSyncTimeOut(tKey, tResponseJsonNode.toString(), MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private ApiMetadata getApiMetadata(Api pApi, String pApiVersion) throws ApiMetadataNotFoundException {
        List<ApiMetadata> tApiMetadatas;
        ApiVersion tApiVersion = pApiVersion == null ? this.apiVersionDao.getLatestVerByApiId(pApi.getId()) : this.apiVersionDao.getByApiIdAndVer(pApi.getId(), pApiVersion);
        if (tApiVersion != null && (tApiMetadatas = this.apiMetadataDao.getByApiVersionId(tApiVersion.getId())) != null) {
            return tApiMetadatas.get(0);
        }
        throw new ApiMetadataNotFoundException(this.getClass());
    }
}

