/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.AssetDataModelDao;
import com.digiwin.metadatacache.dao.AssetDataQueryDao;
import com.digiwin.metadatacache.dao.AssetPropertyDao;
import com.digiwin.metadatacache.enums.PropertySourceEnum;
import com.digiwin.metadatacache.enums.PropertyTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiMetadata;
import com.digiwin.metadatacache.model.AssetDataModel;
import com.digiwin.metadatacache.model.AssetDataQuery;
import com.digiwin.metadatacache.model.AssetProperty;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.ElasticsearchService;
import com.digiwin.metadatacache.util.IdUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssetRegisterService
extends AbstractApiService {
    @Autowired
    private AssetDataModelDao assetDataModelDao;
    @Autowired
    private AssetDataQueryDao assetDataQueryDao;
    @Autowired
    private AssetPropertyDao assetPropertyDao;
    @Autowired
    private ElasticsearchService elasticsearchService;
    @Autowired
    AssetRegisterService assetRegisterService;

    public AssetRegisterService() {
        this.jsonSchemaFileName = "asset_register_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.assetRegisterService.saveAsset(tRequestJsonNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    @Transactional(rollbackFor={Exception.class}, value="mdcTransactionManager")
    public void saveAsset(JsonNode tRequestJsonNode) throws Exception {
        ArrayNode tApiArrayNode = (ArrayNode)tRequestJsonNode.get("asset_data");
        LocalDateTime localDateTime = LocalDateTime.now();
        Gson gson = new Gson();
        for (JsonNode jsonNode : tApiArrayNode) {
            AssetProperty assetProperty = new AssetProperty();
            String propertySource = jsonNode.get("property_source").asText();
            String ownerProduct = jsonNode.get("owner_product").asText();
            String propertyType = jsonNode.get("property_type").asText();
            assetProperty.setId(IdUtil.nextId());
            assetProperty.setPropertySource(propertySource);
            assetProperty.setOwnerProduct(ownerProduct);
            assetProperty.setPropertyType(propertyType);
            assetProperty.setCreateDate(localDateTime);
            JsonNode jsonNodeData = jsonNode.get("data");
            HashMap<String, Object> message = new HashMap<String, Object>();
            Long id = jsonNodeData.get("id").asLong();
            assetProperty.setPropertyKey(id.toString());
            String code = jsonNodeData.get("code").asText();
            String name = jsonNodeData.get("name").asText();
            assetProperty.setCode(code);
            assetProperty.setName(name);
            if (PropertyTypeEnum.BusinessDataModel.toString().equals(propertyType)) {
                AssetDataModel assetDataModel = new AssetDataModel();
                assetDataModel.setId(id);
                assetDataModel.setCode(code);
                assetDataModel.setName(name);
                assetDataModel.setTables(jsonNodeData.get("tables").asText());
                assetDataModel.setLinks(jsonNodeData.get("links").asText());
                assetDataModel.setType(jsonNodeData.get("type").asText());
                message.put("id", id);
                message.put("code", code);
                message.put("name", name);
                message.put("tables", gson.fromJson(jsonNodeData.get("tables").asText(), new TypeToken<ArrayList<Map<String, Object>>>(){}.getType()));
                message.put("links", gson.fromJson(jsonNodeData.get("links").asText(), new TypeToken<ArrayList<Map<String, Object>>>(){}.getType()));
                message.put("type", jsonNodeData.get("type").asText());
                boolean assetModelDataExists = this.assetDataModelDao.exists(assetDataModel.getId());
                if (assetModelDataExists) {
                    assetDataModel.setModifiedDate(localDateTime);
                    this.assetDataModelDao.saveOrupdate(assetDataModel);
                } else {
                    assetDataModel.setCreateDate(localDateTime);
                    this.assetDataModelDao.save(assetDataModel);
                }
            } else if (PropertyTypeEnum.QueryProject.toString().equals(propertyType)) {
                AssetDataQuery assetDataQuery = new AssetDataQuery();
                assetDataQuery.setId(id);
                assetDataQuery.setCode(code);
                assetDataQuery.setName(name);
                assetDataQuery.setModelId(jsonNodeData.get("model_id").asLong());
                assetDataQuery.setPlayground(jsonNodeData.get("playground").asText());
                message.put("id", id);
                message.put("code", code);
                message.put("name", name);
                message.put("model_id", jsonNodeData.get("model_id").asText());
                message.put("playground", gson.fromJson(jsonNodeData.get("playground").asText(), new TypeToken<Map<String, Object>>(){}.getType()));
                boolean assetDataQueryExists = this.assetDataQueryDao.exists(assetDataQuery.getId());
                if (assetDataQueryExists) {
                    assetDataQuery.setModifiedDate(localDateTime);
                    this.assetDataQueryDao.saveOrupdate(assetDataQuery);
                } else {
                    assetDataQuery.setCreateDate(localDateTime);
                    this.assetDataQueryDao.save(assetDataQuery);
                }
            }
            this.deletePropertyAndES(assetProperty.getCode(), assetProperty.getPropertyType(), assetProperty.getTenantId());
            this.insertPropertyAndES(assetProperty, message);
        }
    }

    public void saveAssetProperty(String tApiName, String description, String provider, ApiMetadata apiMetadata, String tTenantId, String tUserId) throws Exception {
        AssetProperty assetProperty = new AssetProperty();
        assetProperty.setId(IdUtil.nextId());
        assetProperty.setCode(tApiName);
        assetProperty.setName(description);
        assetProperty.setTenantId(tTenantId);
        assetProperty.setPropertyKey(apiMetadata.getId().toString());
        assetProperty.setPropertySource(tApiName.startsWith(PropertySourceEnum.dmp.toString()) ? PropertySourceEnum.dmp.toString() : (tApiName.startsWith(PropertySourceEnum.bmd.toString()) ? PropertySourceEnum.bmd.toString() : (tApiName.startsWith(PropertySourceEnum.bm.toString()) ? PropertySourceEnum.bm.toString() : null)));
        if (null != provider) {
            assetProperty.setOwnerProduct(provider);
        }
        assetProperty.setPropertyType(PropertyTypeEnum.API.toString());
        assetProperty.setCreateBy(tUserId);
        assetProperty.setCreateDate(LocalDateTime.now());
        assetProperty.setModifiedDate(LocalDateTime.now());
        assetProperty.setModifiedBy(tUserId);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("id", apiMetadata.getId());
        message.put("code", tApiName);
        message.put("name", description);
        message.put("api_version_id", apiMetadata.getApiVersionId());
        message.put("metadata", new Gson().fromJson(apiMetadata.getMetadata(), new TypeToken<Map<String, Object>>(){}.getType()));
        this.insertPropertyAndES(assetProperty, message);
    }

    public void deletePropertyAndES(String code, String propertyType, String tenantId) throws Exception {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("code", code);
        pCondition.put("tenant_id", tenantId);
        pCondition.put("property_type", propertyType);
        List<AssetProperty> assetProperties = this.assetPropertyDao.getAssetPropertyByInfo(pCondition);
        if (CollectionUtils.isNotEmpty(assetProperties)) {
            for (AssetProperty assetProperty : assetProperties) {
                this.assetPropertyDao.remove(assetProperty.getId());
                this.elasticsearchService.deleteAssetDataDoc(assetProperty.getId().toString());
            }
        }
    }

    public void insertPropertyAndES(AssetProperty assetProperty, Map<String, Object> message) throws Exception {
        this.assetPropertyDao.save(assetProperty);
        HashMap<String, Object> objectNode = new HashMap<String, Object>();
        objectNode.put("id", assetProperty.getId());
        objectNode.put("code", assetProperty.getCode());
        objectNode.put("name", assetProperty.getName());
        objectNode.put("content", message);
        objectNode.put("property_source", assetProperty.getPropertySource());
        objectNode.put("owner_product", assetProperty.getOwnerProduct());
        objectNode.put("property_type", assetProperty.getPropertyType());
        this.elasticsearchService.insertAssetDataDoc(assetProperty.getId().toString(), objectNode);
    }
}

